/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.LongPredicate;
import pro.gravit.launcher.events.request.BatchProfileByUsernameRequestEvent;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.request.uuid.BatchProfileByUsernameRequest;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.VerifyHelper;

public class YggdrasilGameProfileRepository
implements GameProfileRepository {
    private static final long BUSY_WAIT_MS = VerifyHelper.verifyLong((long)Long.parseLong(System.getProperty("launcher.com.mojang.authlib.busyWait", Long.toString(100L))), (LongPredicate)VerifyHelper.L_NOT_NEGATIVE, (String)"launcher.com.mojang.authlib.busyWait can't be < 0");
    private static final long ERROR_BUSY_WAIT_MS = VerifyHelper.verifyLong((long)Long.parseLong(System.getProperty("launcher.com.mojang.authlib.errorBusyWait", Long.toString(500L))), (LongPredicate)VerifyHelper.L_NOT_NEGATIVE, (String)"launcher.com.mojang.authlib.errorBusyWait can't be < 0");

    public YggdrasilGameProfileRepository() {
        LogHelper.debug((String)"Patched GameProfileRepository created");
    }

    public YggdrasilGameProfileRepository(YggdrasilAuthenticationService authenticationService) {
        LogHelper.debug((String)"Patched GameProfileRepository created");
    }

    private static void busyWait(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            LogHelper.error((Throwable)e);
        }
    }

    @Override
    public void findProfilesByNames(String[] usernames, Agent agent, ProfileLookupCallback callback) {
        int offset = 0;
        while (offset < usernames.length) {
            boolean debug;
            PlayerProfile[] sliceProfiles;
            String[] sliceUsernames = Arrays.copyOfRange(usernames, offset, Math.min(offset + 128, usernames.length));
            offset += 128;
            try {
                sliceProfiles = ((BatchProfileByUsernameRequestEvent)new BatchProfileByUsernameRequest((String[])sliceUsernames).request()).playerProfiles;
            }
            catch (Exception e) {
                debug = LogHelper.isDebugEnabled();
                for (String username : sliceUsernames) {
                    if (debug) {
                        LogHelper.debug((String)"Couldn't find profile '%s': %s", (Object[])new Object[]{username, e});
                    }
                    callback.onProfileLookupFailed(new GameProfile((UUID)null, username), e);
                }
                YggdrasilGameProfileRepository.busyWait(ERROR_BUSY_WAIT_MS);
                continue;
            }
            int len = sliceProfiles.length;
            debug = len > 0 && LogHelper.isDebugEnabled();
            for (int i = 0; i < len; ++i) {
                PlayerProfile pp = sliceProfiles[i];
                if (pp == null) {
                    String username = sliceUsernames[i];
                    if (debug) {
                        LogHelper.debug((String)"Couldn't find profile '%s'", (Object[])new Object[]{username});
                    }
                    callback.onProfileLookupFailed(new GameProfile((UUID)null, username), new ProfileNotFoundException("Server did not find the requested profile"));
                    continue;
                }
                if (debug) {
                    LogHelper.debug((String)"Successfully looked up profile '%s'", (Object[])new Object[]{pp.username});
                }
                callback.onProfileLookupSucceeded(YggdrasilMinecraftSessionService.toGameProfile(pp));
            }
            YggdrasilGameProfileRepository.busyWait(BUSY_WAIT_MS);
        }
    }
}

