/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.grimoire.common.api.eventbus;

import io.github.crucible.grimoire.common.api.eventbus.ICancelable;
import io.github.crucible.grimoire.common.api.eventbus.IHasResult;

public abstract class CoreEvent {
    private boolean isCanceled = false;
    private Result result = Result.DEFAULT;

    public boolean isCancelable() {
        return this instanceof ICancelable;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean cancel) throws UnsupportedOperationException {
        if (!this.isCancelable()) {
            throw new UnsupportedOperationException("Attempted to call CoreEvent#setCanceled() on a non-cancelable event of type: " + this.getClass().getCanonicalName());
        }
        this.isCanceled = cancel;
    }

    public boolean hasResult() {
        return this instanceof IHasResult;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) throws UnsupportedOperationException {
        if (!this.hasResult()) {
            throw new UnsupportedOperationException("Attempted to call CoreEvent#setCanceled() on a result-less event of type: " + this.getClass().getCanonicalName());
        }
        this.result = result;
    }

    public static enum Result {
        DENY,
        DEFAULT,
        ALLOW;

    }

    public static enum Priority {
        HIGHEST,
        HIGH,
        NORMAL,
        LOW,
        LOWEST;

    }
}

