/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.grimoire.common.events;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.function.Function;

public abstract class SubscribeAnnotationWrapper {
    private static Function<Method, SubscribeAnnotationWrapper> wrapperFactory = null;

    protected SubscribeAnnotationWrapper() {
    }

    public abstract boolean annotationPresent();

    public abstract boolean receiveCanceled();

    public abstract int getEventPriorityOrdinal();

    public static void setWrapperFactory(Function<Method, SubscribeAnnotationWrapper> factory) {
        Preconditions.checkArgument((wrapperFactory == null ? 1 : 0) != 0, (Object)"Factory already set!");
        wrapperFactory = factory;
    }

    public static SubscribeAnnotationWrapper getWrapper(Method method) {
        return wrapperFactory.apply(method);
    }
}

