/*
 * Decompiled with CFR 0.152.
 */
package ml.luxinfine.helper.guis.elements;

import java.util.function.Supplier;
import ml.luxinfine.helper.guis.ElementPosition;

public abstract class GuiText {
    public final int color;
    public final boolean shadow;
    public final ElementPosition position;

    private GuiText(ElementPosition elementPosition, int n, boolean bl) {
         .color = n;
         .position = elementPosition;
         .shadow = bl;
    }

    public static GuiText of(ElementPosition elementPosition, String string, int n) {
        return new GuiStaticText(string, elementPosition, n, false);
    }

    public static GuiText of(ElementPosition elementPosition, String string, int n, boolean bl) {
        return new GuiStaticText(string, elementPosition, n, bl);
    }

    public static GuiText of(String string, int n) {
        return GuiText.of(ElementPosition.LEFT, string, n);
    }

    public static GuiText of(ElementPosition elementPosition, Supplier<String> supplier, int n) {
        return new GuiDynamicText(supplier, elementPosition, n, false);
    }

    public static GuiText of(ElementPosition elementPosition, Supplier<String> supplier, int n, boolean bl) {
        return new GuiDynamicText(supplier, elementPosition, n, bl);
    }

    public static GuiText of(Supplier<String> supplier, int n) {
        return GuiText.of(ElementPosition.LEFT, supplier, n);
    }

    public abstract String getText();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class GuiDynamicText
    extends GuiText {
        public final Supplier<String> i \u0445w;

        public GuiDynamicText(Supplier<String> supplier, ElementPosition elementPosition, int n, boolean bl) {
            super(elementPosition, n, bl);
             .i \u0445w = supplier;
        }

        @Override
        public String getText() {
            GuiDynamicText guiDynamicText;
            return guiDynamicText.i \u0445w.get();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class GuiStaticText
    extends GuiText {
        public final String x\u0441 y;

        public GuiStaticText(String string, ElementPosition elementPosition, int n, boolean bl) {
            super(elementPosition, n, bl);
             .x\u0441 y = string;
        }

        @Override
        public String getText() {
            GuiStaticText guiStaticText;
            return guiStaticText.x\u0441 y;
        }
    }
}

