/*
 * Decompiled with CFR 0.152.
 */
package ml.luxinfine.helper.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Optional;
import team.luxinfine.helper.26_10_2024__16_37_46.twy;
import team.luxinfine.helper.26_10_2024__16_37_46.vqe;

public class NumberUtils {
    public static final DecimalFormat percentPattern = new DecimalFormat(twy."\u043em x");

    public NumberUtils() {
        NumberUtils numberUtils;
    }

    public static boolean isNumber(String string) {
        return string.matches(vqe." aye");
    }

    public static Optional<Double> toDouble(Object object) {
        try {
            return Optional.of(object instanceof Double ? (Double)object : Double.parseDouble(object.toString()));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static Optional<Integer> toInt(Object object) {
        try {
            return Optional.of(object instanceof Integer ? (Integer)object : Integer.parseInt(object.toString()));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static Optional<Long> toLong(Object object) {
        try {
            return Optional.of(object instanceof Long ? (Long)object : Long.parseLong(object.toString()));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static Optional<Float> toFloat(Object object) {
        try {
            return Optional.of(Float.valueOf(object instanceof Float ? ((Float)object).floatValue() : Float.parseFloat(object.toString())));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static boolean inRange(int n, int n2, int n3) {
        return n2 <= n && n <= n3;
    }

    public static int calcScale(double d, double d2, int n) {
        return d2 > 0.0 && d > 0.0 ? Math.min(Math.max((int)((double)n * (d2 / d)), 0), n) : 0;
    }

    public static String format(Object object) {
        return percentPattern.format(object);
    }

    public static String formatInt(int n) {
        return percentPattern.format(n);
    }

    public static String formatLong(long l) {
        return percentPattern.format(l);
    }

    public static String formatDouble(double d) {
        return percentPattern.format(d);
    }

    public static double max(double d, double d2) {
        return d > d2 ? d : d2;
    }

    public static double min(double d, double d2) {
        return d < d2 ? d : d2;
    }

    public static double clamp(double d, double d2, double d3) {
        return d < d2 ? d2 : (d > d3 ? d3 : d);
    }

    public static float max(float f, float f2) {
        return f > f2 ? f : f2;
    }

    public static float min(float $, float $2) {
        return $ < $2 ? $ : $2;
    }

    public static float clamp(float f, float f2, float f3) {
        return f < f2 ? f2 : (f > f3 ? f3 : f);
    }

    public static boolean isEqual(float f, float f2, float f3) {
        return Math.abs(f - f2) <= f3;
    }

    public static boolean isEqual(double d, double d2, double d3) {
        return Math.abs(d - d2) <= d3;
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setGroupingSeparator(' ');
        decimalFormatSymbols.setDecimalSeparator(',');
        percentPattern.setDecimalFormatSymbols(decimalFormatSymbols);
    }
}

