/*
 * Decompiled with CFR 0.152.
 */
package ru.swixy.menu.client.pinger;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import ru.swixy.menu.client.pinger.IOHelper;

@SideOnly(value=Side.CLIENT)
public final class HInput
implements AutoCloseable {
    public final InputStream stream;

    public HInput(byte[] bytes) {
        this.stream = new ByteArrayInputStream(bytes);
    }

    public HInput(InputStream stream) {
        this.stream = Objects.requireNonNull(stream, "stream");
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    public byte[] readByteArray(int max) throws IOException {
        byte[] bytes = new byte[this.readLength(max)];
        IOHelper.read(this.stream, bytes);
        return bytes;
    }

    public int readLength(int max) throws IOException {
        if (max < 0) {
            return -max;
        }
        return IOHelper.verifyLength(this.readVarInt(), max);
    }

    public String readString(int maxBytes) throws IOException {
        return IOHelper.decode(this.readByteArray(maxBytes));
    }

    public int readUnsignedByte() throws IOException {
        int b = this.stream.read();
        if (b < 0) {
            throw new EOFException("readUnsignedByte");
        }
        return b;
    }

    public int readVarInt() throws IOException {
        int result = 0;
        for (int shift = 0; shift < 32; shift += 7) {
            int b = this.readUnsignedByte();
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IOException("VarInt too big");
    }
}

