/*
 * Decompiled with CFR 0.152.
 */
package ru.swixy.menu.client.pinger;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import ru.swixy.menu.client.pinger.IOHelper;

@SideOnly(value=Side.CLIENT)
public final class HOutput
implements AutoCloseable,
Flushable {
    public final OutputStream stream;

    public HOutput(OutputStream stream) {
        this.stream = Objects.requireNonNull(stream, "stream");
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    public void writeByteArray(byte[] bytes, int max) throws IOException {
        this.writeLength(bytes.length, max);
        this.stream.write(bytes);
    }

    public void writeLength(int length, int max) throws IOException {
        IOHelper.verifyLength(length, max);
        if (max >= 0) {
            this.writeVarInt(length);
        }
    }

    public void writeShort(short s) throws IOException {
        this.writeUnsignedByte(s >>> 8 & 0xFF);
        this.writeUnsignedByte(s & 0xFF);
    }

    public void writeString(String s, int maxBytes) throws IOException {
        this.writeByteArray(IOHelper.encode(s), maxBytes);
    }

    public void writeUnsignedByte(int b) throws IOException {
        this.stream.write(b);
    }

    public void writeVarInt(int i) throws IOException {
        while (((long)i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeUnsignedByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        this.writeUnsignedByte(i);
    }
}

