/*
 * Decompiled with CFR 0.152.
 */
package ru.swixy.menu.client.pinger;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@SideOnly(value=Side.CLIENT)
public final class IOHelper {
    public static final Charset UNICODE_CHARSET = StandardCharsets.UTF_8;
    public static final int SOCKET_TIMEOUT = 30000;

    public static String decode(byte[] bytes) {
        return new String(bytes, UNICODE_CHARSET);
    }

    public static byte[] encode(String s) {
        return s.getBytes(UNICODE_CHARSET);
    }

    public static ByteArrayOutputStream newByteArrayOutput() {
        return new ByteArrayOutputStream();
    }

    public static Socket newSocket() throws SocketException {
        Socket socket = new Socket();
        IOHelper.setSocketFlags(socket);
        return socket;
    }

    public static void read(InputStream input, byte[] bytes) throws IOException {
        int length;
        for (int offset = 0; offset < bytes.length; offset += length) {
            length = input.read(bytes, offset, bytes.length - offset);
            if (length >= 0) continue;
            throw new EOFException(String.format("%d bytes remaining", bytes.length - offset));
        }
    }

    public static InetSocketAddress resolve(InetSocketAddress address) {
        if (address.isUnresolved()) {
            return new InetSocketAddress(address.getHostString(), address.getPort());
        }
        return address;
    }

    public static void setSocketFlags(Socket socket) throws SocketException {
        socket.setKeepAlive(false);
        socket.setTcpNoDelay(false);
        socket.setReuseAddress(true);
        socket.setSoTimeout(30000);
        try {
            socket.setTrafficClass(28);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        socket.setPerformancePreferences(1, 0, 2);
    }

    public static int verifyLength(int length, int max) throws IOException {
        if (length < 0 || max < 0 && length != -max || max > 0 && length > max) {
            throw new IOException("Illegal length: " + length);
        }
        return length;
    }

    private IOHelper() {
    }
}

