/*
 * Decompiled with CFR 0.152.
 */
package ru.swixy.menu.client.pinger;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.Instant;
import ru.swixy.menu.client.pinger.HInput;
import ru.swixy.menu.client.pinger.HOutput;
import ru.swixy.menu.client.pinger.IOHelper;

@SideOnly(value=Side.CLIENT)
public final class ServerPinger {
    private final JsonParser parser = new JsonParser();
    private static final int PACKET_LENGTH = 65535;
    private final InetSocketAddress address;
    private final Object cacheLock = new Object();
    private Result cache = null;
    private Exception cacheException = null;
    private Instant cacheTime = null;

    public ServerPinger() {
        this.address = InetSocketAddress.createUnresolved("sky1.swixy.ru", Integer.parseInt("25567"));
    }

    /*
     * Exception decompiling
     */
    private Result doPing() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Result modernPing(HInput input, HOutput output) throws IOException {
        String response;
        byte[] handshakePacket;
        try (ByteArrayOutputStream packetArray = IOHelper.newByteArrayOutput();){
            try (HOutput packetOutput = new HOutput(packetArray);){
                packetOutput.writeVarInt(0);
                packetOutput.writeVarInt(5);
                packetOutput.writeString(this.address.getHostString(), 0);
                packetOutput.writeShort((short)this.address.getPort());
                packetOutput.writeVarInt(1);
            }
            handshakePacket = packetArray.toByteArray();
        }
        output.writeByteArray(handshakePacket, 65535);
        output.writeVarInt(1);
        output.writeVarInt(0);
        output.flush();
        int ab = 0;
        while (ab <= 0) {
            ab = IOHelper.verifyLength(input.readVarInt(), 65535);
        }
        byte[] statusPacket = input.readByteArray(-ab);
        try (HInput packetInput = new HInput(statusPacket);){
            int statusPacketID = packetInput.readVarInt();
            if (statusPacketID != 0) {
                throw new IOException("Illegal status packet ID: " + statusPacketID);
            }
            response = packetInput.readString(65535);
        }
        JsonObject object = this.parser.parse(response).getAsJsonObject();
        JsonObject playersObject = object.get("players").getAsJsonObject();
        int online = playersObject.get("online").getAsInt();
        int max = playersObject.get("max").getAsInt();
        return new Result(online, max, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result ping() throws IOException {
        Instant now = Instant.now();
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.cacheTime == null || Duration.between(now, this.cacheTime).toMillis() >= 30000L) {
                this.cacheTime = now;
                try {
                    this.cache = this.doPing();
                    this.cacheException = null;
                }
                catch (IOException | IllegalArgumentException e) {
                    this.cache = null;
                    this.cacheException = e;
                }
            }
            if (this.cache == null) {
                if (this.cacheException instanceof IOException) {
                    throw (IOException)this.cacheException;
                }
                if (this.cacheException instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)this.cacheException;
                }
                this.cacheException = new IOException("Unavailable");
                throw (IOException)this.cacheException;
            }
            return this.cache;
        }
    }

    public static final class Result {
        public final int onlinePlayers;
        public final int maxPlayers;
        public final String raw;

        public Result(int onlinePlayers, int maxPlayers, String raw) {
            this.onlinePlayers = Math.max(onlinePlayers, 0);
            this.maxPlayers = Math.max(maxPlayers, 0);
            this.raw = raw;
        }
    }
}

