/*
 * Decompiled with CFR 0.152.
 */
package ru.swixy.menu.client.player;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.InputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;
import javazoom.jl.player.Player;

@SideOnly(value=Side.CLIENT)
public class MusicPlayer
extends Player {
    private final Bitstream bitstream;
    private final Decoder decoder;
    private final AudioDevice audio;
    private float volume;

    public MusicPlayer(InputStream stream, AudioDevice device) throws JavaLayerException {
        super(stream, device);
        this.bitstream = new Bitstream(stream);
        this.decoder = new Decoder();
        this.audio = FactoryRegistry.systemRegistry().createAudioDevice();
        this.audio.open(this.decoder);
        this.volume = 1.0f;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean decodeFrame() {
        try {
            AudioDevice out = this.audio;
            if (out == null || this.bitstream.readFrame() == null) {
                return false;
            }
            SampleBuffer output = (SampleBuffer)this.decoder.decodeFrame(this.bitstream.readFrame(), this.bitstream);
            MusicPlayer musicPlayer = this;
            synchronized (musicPlayer) {
                out = this.audio;
                if (out != null) {
                    short[] buf = output.getBuffer();
                    for (int i = 0; i < buf.length; ++i) {
                        buf[i] = (short)((float)buf[i] * this.volume);
                    }
                    out.write(buf, 0, output.getBufferLength());
                }
            }
            this.bitstream.closeFrame();
        }
        catch (JavaLayerException javaLayerException) {
            // empty catch block
        }
        return true;
    }
}

