/*
 * Decompiled with CFR 0.152.
 */
package ru.swixy.menu.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.resources.I18n;

public class ClientMessagePacketSyncDatabase
implements IMessage {
    private double numberLux;
    private double numberSwi;
    private String group;
    private String groupTime;
    private int size;
    private int count;
    public static String Lux = "...";
    public static String Swi = "...";
    public static String Group = "...";
    public static String GroupTime = "...";
    public static String Size = "...";
    public static String Count = "...";

    public ClientMessagePacketSyncDatabase() {
    }

    public ClientMessagePacketSyncDatabase(double numberLux, double numberSwi, String group, String groupTime, int size, int count) {
        this.numberLux = numberLux;
        this.numberSwi = numberSwi;
        this.group = group;
        this.groupTime = groupTime;
        this.size = size;
        this.count = count;
    }

    public void fromBytes(ByteBuf buf) {
        this.numberLux = buf.readDouble();
        this.numberSwi = buf.readDouble();
        this.group = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.groupTime = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.size = buf.readInt();
        this.count = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.numberLux);
        buf.writeDouble(this.numberSwi);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.group);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.groupTime);
        buf.writeInt(this.size);
        buf.writeInt(this.count);
    }

    public static class Handler
    implements IMessageHandler<ClientMessagePacketSyncDatabase, IMessage> {
        public IMessage onMessage(ClientMessagePacketSyncDatabase packet, MessageContext ctx) {
            Lux = "\u00a79" + (int)packet.numberLux + " lux";
            Swi = "\u00a76" + (int)packet.numberSwi + " swi";
            Group = packet.group;
            GroupTime = I18n.func_135052_a((String)packet.groupTime, (Object[])new Object[0]);
            Size = packet.size / 65536 + " " + I18n.func_135052_a((String)"menu.menu.size.chunks", (Object[])new Object[0]);
            Count = packet.count + " " + I18n.func_135052_a((String)"menu.menu.count", (Object[])new Object[0]);
            return null;
        }
    }
}

