/*
 * Decompiled with CFR 0.152.
 */
package ru.swixy.menu.utils;

import ml.luxinfine.hooks.api.HooksContainer;
import ml.luxinfine.hooks.api.IHookContext;
import ml.luxinfine.hooks.api.Inject;
import ml.luxinfine.hooks.api.InjectTarget;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;

@HooksContainer(targetClassRef=AnvilChunkLoader.class)
public class ChunkLoaderHook {
    @Inject(target=InjectTarget.RETURN)
    public static void readChunkFromNBT(AnvilChunkLoader loader, World world, NBTTagCompound data, IHookContext context) {
        Chunk loadedChunk = (Chunk)context.getRedirectedValue();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 1; y < 255; ++y) {
                    int id = ChunkLoaderHook.getBlockIDFromNBT(data, x, y, z);
                    if (id == 0 || Block.func_149729_e((int)id) != null && Block.func_149729_e((int)id) != Blocks.field_150350_a) continue;
                    loadedChunk.func_150807_a(x, y, z, Blocks.field_150348_b, 0);
                }
            }
        }
        context.exit((Object)loadedChunk);
    }

    public static int getBlockIDFromNBT(NBTTagCompound chunkNBT, int x, int y, int z) {
        if (x < 0 || x >= 16 || z < 0 || z >= 16 || y < 0 || y >= 256) {
            throw new IllegalArgumentException("Invalid block coordinates!");
        }
        int sectionY = y / 16;
        int yInSection = y % 16;
        NBTTagList sections = chunkNBT.func_150295_c("Sections", 10);
        NBTTagCompound section = null;
        for (int i = 0; i < sections.func_74745_c(); ++i) {
            NBTTagCompound sec = sections.func_150305_b(i);
            if (sec.func_74771_c("Y") != (byte)sectionY) continue;
            section = sec;
            break;
        }
        if (section == null) {
            return 0;
        }
        byte[] blocks = section.func_74770_j("Blocks");
        if (blocks.length == 0) {
            return 0;
        }
        int index = yInSection * 256 + z * 16 + x;
        int blockID = blocks[index] & 0xFF;
        if (section.func_74764_b("Add")) {
            byte[] add = section.func_74770_j("Add");
            int addIndex = index / 2;
            blockID = index % 2 == 0 ? (blockID += (add[addIndex] & 0xF) << 8) : (blockID += (add[addIndex] >> 4 & 0xF) << 8);
        }
        return blockID;
    }
}

