/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.tabmod.network;

import com.gamerforea.tabmod.TabMod;
import com.gamerforea.tabmod.util.PlayerData;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;

public class PlayerListMessage
implements IMessage {
    private static final String TAG_PLAYER_LIST = "PlayerList";
    private final Map playerDataMap = new HashMap();

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buf);
        NBTTagList playerList = nbt.func_150295_c(TAG_PLAYER_LIST, 10);
        for (int i = 0; i < playerList.func_74745_c(); ++i) {
            PlayerData playerData = PlayerData.readFromNBT(playerList.func_150305_b(i));
            if (playerData == null) continue;
            this.playerDataMap.put(playerData.tabName, playerData);
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList playerList = new NBTTagList();
        List list = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayerMP player : list) {
            playerList.func_74742_a((NBTBase)PlayerData.writePlayerToNBT(new NBTTagCompound(), player));
        }
        tag.func_74782_a(TAG_PLAYER_LIST, (NBTBase)playerList);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<PlayerListMessage, IMessage> {
        public IMessage onMessage(PlayerListMessage message, MessageContext ctx) {
            Map playerDataMap = TabMod.instance.playerDataMap;
            playerDataMap.clear();
            playerDataMap.putAll(message.playerDataMap);
            for (PlayerData data : playerDataMap.values()) {
                TabMod.skinHolder.loadSkin(data.gameProfile);
            }
            return null;
        }
    }
}

