package ru.vizzi.warps.packet;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;

@SerializerMark(
    packetClass = ru.vizzi.warps.packet.CPacketMessage.class
)
public class CPacketMessageSerializer implements ISerializer<CPacketMessage> {
  public void serialize(CPacketMessage value, ByteBuf acc) {
    serialize_CPacketMessage_Generic(value, acc);
  }

  public CPacketMessage unserialize(ByteBuf buf) {
    return unserialize_CPacketMessage_Generic(buf);
  }

  void serialize_CPacketMessage_Generic(CPacketMessage value, ByteBuf acc) {
    serialize_CPacketMessage_Concretic(value, acc);
  }

  CPacketMessage unserialize_CPacketMessage_Generic(ByteBuf buf) {
    return unserialize_CPacketMessage_Concretic(buf);
  }

  void serialize_CPacketMessage_Concretic(CPacketMessage value, ByteBuf acc) {
    serialize_String_Generic(value.getMessageType(), acc);
  }

  CPacketMessage unserialize_CPacketMessage_Concretic(ByteBuf buf) {
    CPacketMessage value = new CPacketMessage(unserialize_String_Generic(buf));
    return value;
  }
}
