package ru.vizzi.warps.packet;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;

@SerializerMark(
    packetClass = ru.vizzi.warps.packet.SPacketTeleport.class
)
public class SPacketTeleportSerializer implements ISerializer<SPacketTeleport> {
  public void serialize(SPacketTeleport value, ByteBuf acc) {
    serialize_SPacketTeleport_Generic(value, acc);
  }

  public SPacketTeleport unserialize(ByteBuf buf) {
    return unserialize_SPacketTeleport_Generic(buf);
  }

  void serialize_SPacketTeleport_Generic(SPacketTeleport value, ByteBuf acc) {
    serialize_SPacketTeleport_Concretic(value, acc);
  }

  SPacketTeleport unserialize_SPacketTeleport_Generic(ByteBuf buf) {
    return unserialize_SPacketTeleport_Concretic(buf);
  }

  void serialize_SPacketTeleport_Concretic(SPacketTeleport value, ByteBuf acc) {
    serialize_String_Generic(value.getName(), acc);
  }

  SPacketTeleport unserialize_SPacketTeleport_Concretic(ByteBuf buf) {
    SPacketTeleport value = new SPacketTeleport(unserialize_String_Generic(buf));
    return value;
  }
}
