/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.crashguard.gui;

import com.falsepattern.crashguard.CrashGuard;
import com.falsepattern.crashguard.gui.GuiText;
import com.falsepattern.crashguard.util.ModIdentifier;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.Util;
import org.lwjgl.Sys;

@SideOnly(value=Side.CLIENT)
public class GuiCrash
extends GuiScreen {
    private final boolean soft;
    private final boolean server;
    private final CrashReport crashReport;
    private final File crashReportFile;
    private final List<GuiText> texts = new ArrayList<GuiText>();
    private final Set<ModContainer> suspects;

    public GuiCrash(boolean soft, boolean server, CrashReport crashReport, File crashReportFile) {
        this.soft = soft;
        this.server = server;
        this.crashReport = crashReport;
        this.crashReportFile = crashReportFile;
        this.suspects = ModIdentifier.identifyFromStacktrace(crashReport.func_71505_b());
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.texts.clear();
        int centerX = this.field_146294_l / 2;
        int bottomY = Math.min(this.field_146295_m / 10 * 9, this.field_146295_m - 24);
        int y = Math.max(this.field_146295_m / 4 - 40, 20);
        this.texts.add(new GuiText(true, (this.server ? "SERVER " : "CLIENT ") + "CRASHED!", centerX, y, 0xFF0000));
        this.texts.add(new GuiText(true, "Description:", centerX, y += 18, 0xFFFFFF));
        this.texts.add(new GuiText(true, this.crashReport.func_71501_a(), centerX, y += 15, 0xFFFF00));
        y += 18;
        if (this.suspects.size() != 0) {
            this.texts.add(new GuiText(true, "Suspected mod" + (this.suspects.size() > 1 ? "s:" : ":"), centerX, y, 0xFFFFFF));
            y += 18;
            if (CrashGuard.crashHint != null && CrashGuard.crashHint.length > 0) {
                for (String string : CrashGuard.crashHint) {
                    this.texts.add(new GuiText(true, string, centerX, y, 0xFFFF00));
                    y += 10;
                }
            }
            for (ModContainer suspect : this.suspects) {
                this.texts.add(new GuiText(true, suspect.getModId() + "@" + suspect.getVersion() + " (" + suspect.getName() + ")", centerX, y, 0xFFFF00));
                y += 10;
            }
        } else if (CrashGuard.crashHint != null && CrashGuard.crashHint.length > 0) {
            for (String string : CrashGuard.crashHint) {
                this.texts.add(new GuiText(true, string, centerX, y, 0xFFFF00));
                y += 10;
            }
        } else {
            this.texts.add(new GuiText(true, "Unknown cause. Check the crash report for any information.", centerX, y, 0xFFFF00));
        }
        GuiButton crashReport = new GuiButton(2, centerX - 100, bottomY, 98, 20, "Crash Report");
        GuiButton quit = new GuiButton(3, centerX + 2, bottomY, 98, 20, I18n.func_135052_a((String)"menu.quit", (Object[])new Object[0]));
        GuiButton toMenu = new GuiButton(1, centerX - 100, bottomY -= 24, I18n.func_135052_a((String)"gui.toMenu", (Object[])new Object[0]));
        GuiButton guiButton = new GuiButton(0, centerX - 100, bottomY -= 24, "Continue Playing");
        if (!this.soft) {
            guiButton.field_146124_l = false;
        }
        if (this.crashReportFile == null) {
            crashReport.field_146124_l = false;
        }
        this.field_146292_n.add(guiButton);
        this.field_146292_n.add(toMenu);
        this.field_146292_n.add(crashReport);
        this.field_146292_n.add(quit);
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.field_146297_k.func_147108_a(null);
                return;
            }
            case 1: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiMainMenu());
                return;
            }
            case 2: {
                String s = this.crashReportFile.getAbsolutePath();
                if (Util.func_110647_a() == Util.EnumOS.OSX) {
                    try {
                        Runtime.getRuntime().exec(new String[]{"/usr/bin/open", s});
                        return;
                    }
                    catch (IOException iOException) {}
                } else if (Util.func_110647_a() == Util.EnumOS.WINDOWS) {
                    String s1 = String.format("cmd.exe /C start \"Open file\" \"%s\"", s);
                    try {
                        Runtime.getRuntime().exec(s1);
                        return;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                boolean flag = false;
                try {
                    Class<?> oClass = Class.forName("java.awt.Desktop");
                    Object object = oClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    oClass.getMethod("browse", URI.class).invoke(object, this.crashReportFile.toURI());
                }
                catch (Throwable throwable) {
                    flag = true;
                }
                if (flag) {
                    Sys.openURL((String)("file://" + s));
                }
                return;
            }
            case 3: {
                this.field_146297_k.func_71400_g();
                return;
            }
        }
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
    }

    public void func_73863_a(int p_73863_1_, int p_73863_2_, float p_73863_3_) {
        this.func_146276_q_();
        for (GuiText text : this.texts) {
            text.draw((Gui)this, this.field_146289_q);
        }
        super.func_73863_a(p_73863_1_, p_73863_2_, p_73863_3_);
    }

    public boolean func_73868_f() {
        return true;
    }
}

