/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.monitor.memory.GarbageCollectorStatistics;
import me.lucko.spark.common.platform.serverconfig.ServerConfigProvider;
import me.lucko.spark.common.sampler.Sampler;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.sampler.aggregator.DataAggregator;
import me.lucko.spark.common.sampler.node.MergeMode;
import me.lucko.spark.common.sampler.node.ThreadNode;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.util.ClassSourceLookup;
import me.lucko.spark.proto.SparkSamplerProtos;

public abstract class AbstractSampler
implements Sampler {
    protected final SparkPlatform platform;
    protected final int interval;
    protected final ThreadDumper threadDumper;
    protected long startTime = -1L;
    protected int startTick = -1;
    protected final long autoEndTime;
    protected final CompletableFuture<Sampler> future = new CompletableFuture();
    protected Map<String, GarbageCollectorStatistics> initialGcStats;

    protected AbstractSampler(SparkPlatform platform, int interval, ThreadDumper threadDumper, long autoEndTime) {
        this.platform = platform;
        this.interval = interval;
        this.threadDumper = threadDumper;
        this.autoEndTime = autoEndTime;
    }

    @Override
    public long getStartTime() {
        if (this.startTime == -1L) {
            throw new IllegalStateException("Not yet started");
        }
        return this.startTime;
    }

    @Override
    public long getAutoEndTime() {
        return this.autoEndTime;
    }

    @Override
    public CompletableFuture<Sampler> getFuture() {
        return this.future;
    }

    protected void recordInitialGcStats() {
        this.initialGcStats = GarbageCollectorStatistics.pollStats();
    }

    protected Map<String, GarbageCollectorStatistics> getInitialGcStats() {
        return this.initialGcStats;
    }

    @Override
    public void start() {
        this.startTime = System.currentTimeMillis();
        TickHook tickHook = this.platform.getTickHook();
        if (tickHook != null) {
            this.startTick = tickHook.getCurrentTick();
        }
    }

    protected void writeMetadataToProto(SparkSamplerProtos.SamplerData.Builder proto, SparkPlatform platform, CommandSender creator, String comment, DataAggregator dataAggregator) {
        TickHook tickHook;
        SparkSamplerProtos.SamplerMetadata.Builder metadata = SparkSamplerProtos.SamplerMetadata.newBuilder().setPlatformMetadata(platform.getPlugin().getPlatformInfo().toData().toProto()).setCreator(creator.toData().toProto()).setStartTime(this.startTime).setEndTime(System.currentTimeMillis()).setInterval(this.interval).setThreadDumper(this.threadDumper.getMetadata()).setDataAggregator(dataAggregator.getMetadata());
        if (comment != null) {
            metadata.setComment(comment);
        }
        if (this.startTick != -1 && (tickHook = this.platform.getTickHook()) != null) {
            int numberOfTicks = tickHook.getCurrentTick() - this.startTick;
            metadata.setNumberOfTicks(numberOfTicks);
        }
        try {
            metadata.setPlatformStatistics(platform.getStatisticsProvider().getPlatformStatistics(this.getInitialGcStats()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            metadata.setSystemStatistics(platform.getStatisticsProvider().getSystemStatistics());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ServerConfigProvider serverConfigProvider = platform.getPlugin().createServerConfigProvider();
            metadata.putAllServerConfigurations(serverConfigProvider.exportServerConfigurations());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        proto.setMetadata(metadata);
    }

    protected void writeDataToProto(SparkSamplerProtos.SamplerData.Builder proto, DataAggregator dataAggregator, Comparator<ThreadNode> outputOrder, MergeMode mergeMode, ClassSourceLookup classSourceLookup) {
        List<ThreadNode> data = dataAggregator.exportData();
        data.sort(outputOrder);
        ClassSourceLookup.Visitor classSourceVisitor = ClassSourceLookup.createVisitor(classSourceLookup);
        for (ThreadNode entry : data) {
            proto.addThreads(entry.toProto(mergeMode));
            classSourceVisitor.visit(entry);
        }
        if (classSourceVisitor.hasMappings()) {
            proto.putAllClassSources(classSourceVisitor.getMapping());
        }
    }
}

