/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.lucko.spark.common.sampler.node.StackTraceNode;
import me.lucko.spark.common.sampler.node.ThreadNode;
import me.lucko.spark.common.util.ClassFinder;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ClassSourceLookup {
    public static final ClassSourceLookup NO_OP = new ClassSourceLookup(){

        @Override
        public @Nullable String identify(Class<?> clazz) {
            return null;
        }
    };

    public @Nullable String identify(Class<?> var1) throws Exception;

    public static Visitor createVisitor(ClassSourceLookup lookup) {
        if (lookup == NO_OP) {
            return NoOpVisitor.INSTANCE;
        }
        return new VisitorImpl(lookup);
    }

    public static enum NoOpVisitor implements Visitor
    {
        INSTANCE;


        @Override
        public void visit(ThreadNode node) {
        }

        @Override
        public boolean hasMappings() {
            return false;
        }

        @Override
        public Map<String, String> getMapping() {
            return Collections.emptyMap();
        }
    }

    public static class VisitorImpl
    implements Visitor {
        private final ClassSourceLookup lookup;
        private final ClassFinder classFinder = new ClassFinder();
        private final Map<String, String> map = new HashMap<String, String>();

        VisitorImpl(ClassSourceLookup lookup) {
            this.lookup = lookup;
        }

        @Override
        public void visit(ThreadNode node) {
            for (StackTraceNode child : node.getChildren()) {
                this.visitStackNode(child);
            }
        }

        @Override
        public boolean hasMappings() {
            return !this.map.isEmpty();
        }

        @Override
        public Map<String, String> getMapping() {
            this.map.values().removeIf(Objects::isNull);
            return this.map;
        }

        private void visitStackNode(StackTraceNode node) {
            String className = node.getClassName();
            if (!this.map.containsKey(className)) {
                try {
                    Class<?> clazz = this.classFinder.findClass(className);
                    Objects.requireNonNull(clazz);
                    this.map.put(className, this.lookup.identify(clazz));
                }
                catch (Throwable e) {
                    this.map.put(className, null);
                }
            }
            for (StackTraceNode child : node.getChildren()) {
                this.visitStackNode(child);
            }
        }
    }

    public static interface Visitor {
        public void visit(ThreadNode var1);

        public boolean hasMappings();

        public Map<String, String> getMapping();
    }

    public static class ByCodeSource
    implements ClassSourceLookup,
    ByUrl {
        @Override
        public @Nullable String identify(Class<?> clazz) throws URISyntaxException, MalformedURLException {
            ProtectionDomain protectionDomain = clazz.getProtectionDomain();
            if (protectionDomain == null) {
                return null;
            }
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource == null) {
                return null;
            }
            URL url = codeSource.getLocation();
            return url == null ? null : this.identifyUrl(url);
        }
    }

    public static class ByFirstUrlSource
    extends ByClassLoader
    implements ByUrl {
        @Override
        public @Nullable String identify(ClassLoader loader) throws IOException, URISyntaxException {
            if (loader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)loader;
                URL[] urls = urlClassLoader.getURLs();
                if (urls.length == 0) {
                    return null;
                }
                return this.identifyUrl(urls[0]);
            }
            return null;
        }
    }

    public static interface ByUrl
    extends ClassSourceLookup {
        default public String identifyUrl(URL url) throws URISyntaxException, MalformedURLException {
            Path path = null;
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                path = Paths.get(url.toURI());
            } else if (protocol.equals("jar")) {
                URL innerUrl = new URL(url.getPath());
                path = Paths.get(innerUrl.getPath().split("!")[0], new String[0]);
            }
            if (path != null) {
                return this.identifyFile(path.toAbsolutePath().normalize());
            }
            return null;
        }

        default public String identifyFile(Path path) {
            return this.identifyFileName(path.getFileName().toString());
        }

        default public String identifyFileName(String fileName) {
            return fileName.endsWith(".jar") ? fileName.substring(0, fileName.length() - 4) : null;
        }
    }

    public static abstract class ByClassLoader
    implements ClassSourceLookup {
        public abstract @Nullable String identify(ClassLoader var1) throws Exception;

        @Override
        public final @Nullable String identify(Class<?> clazz) throws Exception {
            for (ClassLoader loader = clazz.getClassLoader(); loader != null; loader = loader.getParent()) {
                String source = this.identify(loader);
                if (source == null) continue;
                return source;
            }
            return null;
        }
    }
}

