/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.relauncher.Side;
import java.nio.file.Path;
import me.lucko.spark.forge.plugin.ClientSparkPlugin;
import me.lucko.spark.forge.plugin.ServerSparkPlugin;

@Mod(modid="spark", name="spark", acceptableRemoteVersions="*")
public class Spark {
    private Path configDirectory;
    private ServerSparkPlugin activeServerPlugin;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        this.configDirectory = e.getModConfigurationDirectory().toPath();
    }

    @Mod.EventHandler
    public void clientInit(FMLInitializationEvent e) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            ClientSparkPlugin.register(this);
        }
    }

    @Mod.EventHandler
    public void serverInit(FMLServerStartingEvent e) {
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            this.activeServerPlugin = ServerSparkPlugin.register(this, e);
        }
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppingEvent e) {
        if (this.activeServerPlugin != null) {
            this.activeServerPlugin.disable();
            this.activeServerPlugin = null;
        }
    }

    public Path getConfigDirectory() {
        if (this.configDirectory == null) {
            throw new IllegalStateException("Config directory not set");
        }
        return this.configDirectory;
    }
}

