/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge.plugin;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.SparkPlugin;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.util.ClassSourceLookup;
import me.lucko.spark.forge.ForgeClassSourceLookup;
import me.lucko.spark.forge.Spark;
import me.lucko.spark.forge.SparkCommandSender;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;

public abstract class CommonSparkPlugin
extends CommandBase
implements SparkPlugin {
    private final Spark mod;
    protected final ScheduledExecutorService scheduler;
    protected final SparkPlatform platform;
    protected final ThreadDumper.GameThread threadDumper = new ThreadDumper.GameThread();

    protected CommonSparkPlugin(Spark mod) {
        this.mod = mod;
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName("spark-async-worker");
            thread.setDaemon(true);
            return thread;
        });
        this.platform = new SparkPlatform(this);
        this.enable();
    }

    public void enable() {
        this.platform.enable();
    }

    public void disable() {
        this.platform.disable();
        this.scheduler.shutdown();
    }

    @Override
    public String getVersion() {
        return "1.7.10";
    }

    @Override
    public Path getPluginDirectory() {
        return this.mod.getConfigDirectory();
    }

    @Override
    public void executeAsync(Runnable task) {
        this.scheduler.execute(task);
    }

    @Override
    public ThreadDumper getDefaultThreadDumper() {
        return this.threadDumper.get();
    }

    public String func_71517_b() {
        return "spark";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "/" + this.func_71517_b();
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        this.threadDumper.setThread(Thread.currentThread());
        this.platform.executeCommand(new SparkCommandSender(sender), args);
    }

    @Override
    public ClassSourceLookup createClassSourceLookup() {
        return new ForgeClassSourceLookup();
    }

    public List func_71516_a(ICommandSender p_71516_1_, String[] p_71516_2_) {
        return this.platform.tabCompleteCommand(new SparkCommandSender(p_71516_1_), p_71516_2_);
    }
}

