/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.compat.ticon;

import com.google.common.base.Throwables;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import fox.spiteful.avaritia.Lumberjack;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.IMetadataSerializer;
import net.minecraft.util.ResourceLocation;

public abstract class TConTextureResourcePackBase
implements IResourcePack,
IResourceManagerReloadListener {
    public static List<IResourcePack> packs;
    protected static DirectColorModel rgb;
    protected final String name;
    public HashMap<ResourceLocation, byte[]> cachedImages = new HashMap();
    protected IResourcePack delegate;
    protected List<IResourcePack> resourcePackz = null;
    private int[] colourarray = new int[4];

    public TConTextureResourcePackBase(String name) {
        this.name = name.toLowerCase();
        this.delegate = FMLClientHandler.instance().getResourcePackFor("TConstruct");
    }

    public int brightness(int col) {
        return this.brightness(rgb.getRed(col), rgb.getGreen(col), rgb.getBlue(col));
    }

    public int brightness(int r, int g, int b) {
        return (int)((float)r * 0.2126f + (float)g * 0.7152f + (float)b * 0.0722f);
    }

    public void register() {
        List<IResourcePack> packs = this.getiResourcePacks();
        packs.add(this);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
        Lumberjack.info("Registered TCon Resource Pack (" + this.name + ") - " + this.getClass().getSimpleName());
    }

    public List<IResourcePack> getiResourcePacks() {
        List packs1 = packs;
        if (packs1 == null) {
            packs1 = (List)ObfuscationReflectionHelper.getPrivateValue(FMLClientHandler.class, (Object)FMLClientHandler.instance(), (String[])new String[]{"resourcePackList"});
        }
        return packs1;
    }

    public InputStream getStream(ResourceLocation location) {
        InputStream stream = null;
        for (IResourcePack iResourcePack : this.getPacks()) {
            if (!iResourcePack.func_110589_b(location)) continue;
            try {
                stream = iResourcePack.func_110590_a(location);
            }
            catch (IOException iOException) {}
        }
        return stream;
    }

    public List<IResourcePack> getPacks() {
        if (this.resourcePackz == null) {
            this.resourcePackz = new ArrayList<IResourcePack>();
            this.resourcePackz.add(this.delegate);
            List t = Minecraft.func_71410_x().func_110438_M().func_110613_c();
            for (ResourcePackRepository.Entry entry : t) {
                IResourcePack resourcePack = entry.func_110514_c();
                if (!resourcePack.func_110587_b().contains("tinker")) continue;
                this.resourcePackz.add(resourcePack);
            }
        }
        return this.resourcePackz;
    }

    public InputStream func_110590_a(ResourceLocation p_110590_1_) throws IOException {
        byte[] bytes = this.cachedImages.get(p_110590_1_);
        if (bytes == null) {
            BufferedImage image;
            BufferedImage bufferedimage;
            ResourceLocation location = new ResourceLocation("tinker", p_110590_1_.func_110623_a().replace(this.name, ""));
            InputStream inputStream = this.getStream(location);
            if (inputStream == null) {
                location = new ResourceLocation("tinker", p_110590_1_.func_110623_a().replace(this.name, "iron"));
                inputStream = this.getStream(location);
            }
            if (inputStream == null) {
                location = new ResourceLocation("tinker", p_110590_1_.func_110623_a().replace(this.name, "stone"));
                inputStream = this.getStream(location);
            }
            if (inputStream == null) {
                return this.delegate.func_110590_a(p_110590_1_);
            }
            try {
                bufferedimage = ImageIO.read(inputStream);
            }
            catch (IOException err) {
                throw Throwables.propagate((Throwable)err);
            }
            try {
                image = this.modifyImage(bufferedimage);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return this.delegate.func_110590_a(location);
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "PNG", stream);
            bytes = stream.toByteArray();
            this.cachedImages.put(location, bytes);
        }
        return new ByteArrayInputStream(bytes);
    }

    public abstract BufferedImage modifyImage(BufferedImage var1);

    public boolean func_110589_b(ResourceLocation p_110589_1_) {
        if (!"tinker".equals(p_110589_1_.func_110624_b())) {
            return false;
        }
        String resourcePath = p_110589_1_.func_110623_a();
        if (!resourcePath.startsWith("textures/items/") || !resourcePath.endsWith(".png")) {
            return false;
        }
        if (this.delegate.func_110589_b(p_110589_1_)) {
            return false;
        }
        if (!resourcePath.contains(this.name)) {
            return false;
        }
        return this.delegate.func_110589_b(new ResourceLocation("tinker", resourcePath.replace(this.name, "stone"))) || this.delegate.func_110589_b(new ResourceLocation("tinker", resourcePath.replace(this.name, "iron"))) || this.delegate.func_110589_b(new ResourceLocation("tinker", resourcePath.replace(this.name, "")));
    }

    public Set func_110587_b() {
        return this.delegate.func_110587_b();
    }

    public IMetadataSection func_135058_a(IMetadataSerializer p_135058_1_, String p_135058_2_) throws IOException {
        return null;
    }

    public BufferedImage func_110586_a() throws IOException {
        return null;
    }

    public String func_130077_b() {
        return "Avaritia_Delegate_Pack";
    }

    public void func_110549_a(IResourceManager p_110549_1_) {
        this.cachedImages.clear();
        this.resourcePackz = null;
    }

    protected int colour(int r, int g, int b, int a) {
        this.colourarray[0] = r;
        this.colourarray[1] = g;
        this.colourarray[2] = b;
        this.colourarray[3] = a;
        return rgb.getDataElement(this.colourarray, 0);
    }

    static {
        rgb = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    }
}

