/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.toolbox.tools;

import betterquesting.api.client.toolbox.IToolboxTool;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api2.client.gui.controls.PanelButtonQuest;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestLine;
import betterquesting.api2.client.gui.resources.colors.GuiColorPulse;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.lines.BoxLine;
import betterquesting.api2.client.gui.resources.lines.IGuiLine;
import betterquesting.api2.storage.DBEntry;
import betterquesting.client.gui2.editors.designer.PanelToolController;
import betterquesting.client.toolbox.ToolboxTabMain;
import betterquesting.network.handlers.NetChapterEdit;
import betterquesting.questing.QuestLineDatabase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.vector.Vector4f;

public class ToolboxToolScale
implements IToolboxTool {
    private CanvasQuestLine gui;
    private final List<GrabEntry> grabList = new ArrayList<GrabEntry>();
    private final GuiRectangle scaleBounds = new GuiRectangle(0, 0, 0, 0);
    private IGuiLine selLine = new BoxLine();
    private IGuiColor selCol = new GuiColorPulse(-1, -16777216, 2.0, 0.0f);

    @Override
    public void initTool(CanvasQuestLine gui) {
        this.gui = gui;
        this.grabList.clear();
    }

    @Override
    public void disableTool() {
        if (this.grabList.size() > 0) {
            for (GrabEntry grab : this.grabList) {
                IQuestLineEntry qle = (IQuestLineEntry)this.gui.getQuestLine().getValue(((DBEntry)grab.btn.getStoredValue()).getID());
                if (qle == null) continue;
                ((GrabEntry)grab).btn.rect.x = qle.getPosX();
                ((GrabEntry)grab).btn.rect.y = qle.getPosY();
                ((GrabEntry)grab).btn.rect.w = qle.getSizeX();
                ((GrabEntry)grab).btn.rect.h = qle.getSizeY();
            }
            this.grabList.clear();
        }
    }

    @Override
    public void refresh(CanvasQuestLine gui) {
        ArrayList<GrabEntry> tmp = new ArrayList<GrabEntry>();
        block0: for (GrabEntry grab : this.grabList) {
            for (PanelButtonQuest btn : PanelToolController.selected) {
                if (((DBEntry)btn.getStoredValue()).getID() != ((DBEntry)grab.btn.getStoredValue()).getID()) continue;
                tmp.add(new GrabEntry(btn, grab.anchor));
                continue block0;
            }
        }
        this.grabList.clear();
        this.grabList.addAll(tmp);
    }

    @Override
    public void drawCanvas(int mx, int my, float partialTick) {
        if (this.grabList.size() > 0) {
            int snap = Math.max(1, ToolboxTabMain.INSTANCE.getSnapValue());
            int dx = mx + snap / 2;
            int dy = my + snap / 2;
            dx = (dx % snap + snap) % snap;
            dy = (dy % snap + snap) % snap;
            dx = mx + snap / 2 - dx;
            dy = my + snap / 2 - dy;
            this.scaleBounds.w = dx - this.scaleBounds.x;
            this.scaleBounds.h = dy - this.scaleBounds.y;
            boolean shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            for (GrabEntry grab : this.grabList) {
                ((GrabEntry)grab).btn.rect.w = Math.max(1, Math.round((float)this.scaleBounds.w * ((GrabEntry)grab).anchor.z));
                ((GrabEntry)grab).btn.rect.h = Math.max(1, Math.round((float)this.scaleBounds.h * ((GrabEntry)grab).anchor.w));
                if (shift) {
                    ((GrabEntry)grab).btn.rect.x = grab.sx - ((GrabEntry)grab).btn.rect.w / 2;
                    ((GrabEntry)grab).btn.rect.y = grab.sy - ((GrabEntry)grab).btn.rect.h / 2;
                    continue;
                }
                ((GrabEntry)grab).btn.rect.x = this.scaleBounds.x + Math.round((float)this.scaleBounds.w * ((GrabEntry)grab).anchor.x);
                ((GrabEntry)grab).btn.rect.y = this.scaleBounds.y + Math.round((float)this.scaleBounds.h * ((GrabEntry)grab).anchor.y);
            }
            if (this.grabList.size() > 1 && !shift) {
                this.selLine.drawLine(this.scaleBounds, this.scaleBounds, 2, this.selCol, partialTick);
            }
        }
    }

    @Override
    public void drawOverlay(int mx, int my, float partialTick) {
        if (this.grabList.size() > 0) {
            ToolboxTabMain.INSTANCE.drawGrid(this.gui);
        }
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        return this.grabList.size() <= 0 ? null : Collections.emptyList();
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        if (click == 1 && this.grabList.size() > 0) {
            for (GrabEntry grab : this.grabList) {
                IQuestLineEntry qle = (IQuestLineEntry)this.gui.getQuestLine().getValue(((DBEntry)grab.btn.getStoredValue()).getID());
                if (qle == null) continue;
                ((GrabEntry)grab).btn.rect.x = qle.getPosX();
                ((GrabEntry)grab).btn.rect.y = qle.getPosY();
                ((GrabEntry)grab).btn.rect.w = qle.getSizeX();
                ((GrabEntry)grab).btn.rect.h = qle.getSizeY();
            }
            this.grabList.clear();
            return true;
        }
        if (click != 0 || !this.gui.getTransform().contains(mx, my)) {
            return false;
        }
        if (this.grabList.size() > 0) {
            IQuestLine qLine = this.gui.getQuestLine();
            int lID = QuestLineDatabase.INSTANCE.getID(qLine);
            for (GrabEntry grab : this.grabList) {
                IQuestLineEntry qle = (IQuestLineEntry)this.gui.getQuestLine().getValue(((DBEntry)grab.btn.getStoredValue()).getID());
                if (qle == null) continue;
                qle.setPosition(((GrabEntry)grab).btn.rect.x, ((GrabEntry)grab).btn.rect.y);
                qle.setSize(((GrabEntry)grab).btn.rect.w, ((GrabEntry)grab).btn.rect.h);
            }
            NBTTagCompound chPayload = new NBTTagCompound();
            NBTTagList cdList = new NBTTagList();
            NBTTagCompound tagEntry = new NBTTagCompound();
            tagEntry.func_74768_a("chapterID", lID);
            tagEntry.func_74782_a("config", (NBTBase)qLine.writeToNBT(new NBTTagCompound(), null));
            cdList.func_74742_a((NBTBase)tagEntry);
            chPayload.func_74782_a("data", (NBTBase)cdList);
            chPayload.func_74768_a("action", 0);
            NetChapterEdit.sendEdit(chPayload);
            this.grabList.clear();
            return true;
        }
        PanelButtonQuest btnClicked = this.gui.getButtonAt(mx, my);
        if (btnClicked != null) {
            if (PanelToolController.selected.size() > 0) {
                if (!PanelToolController.selected.contains(btnClicked)) {
                    return false;
                }
                boolean first = true;
                for (PanelButtonQuest btn : PanelToolController.selected) {
                    if (first) {
                        this.scaleBounds.x = btn.rect.x;
                        this.scaleBounds.y = btn.rect.y;
                        this.scaleBounds.w = btn.rect.w;
                        this.scaleBounds.h = btn.rect.h;
                        first = false;
                        continue;
                    }
                    this.scaleBounds.x = Math.min(this.scaleBounds.x, btn.rect.x);
                    this.scaleBounds.y = Math.min(this.scaleBounds.y, btn.rect.y);
                    this.scaleBounds.w = Math.max(this.scaleBounds.x + this.scaleBounds.w, btn.rect.x + btn.rect.w) - this.scaleBounds.x;
                    this.scaleBounds.h = Math.max(this.scaleBounds.y + this.scaleBounds.h, btn.rect.y + btn.rect.h) - this.scaleBounds.y;
                }
                for (PanelButtonQuest btn : PanelToolController.selected) {
                    float x = (float)(btn.rect.x - this.scaleBounds.x) / (float)this.scaleBounds.w;
                    float y = (float)(btn.rect.y - this.scaleBounds.y) / (float)this.scaleBounds.h;
                    float w = (float)btn.rect.w / (float)this.scaleBounds.w;
                    float h = (float)btn.rect.h / (float)this.scaleBounds.h;
                    this.grabList.add(new GrabEntry(btn, new Vector4f(x, y, w, h)));
                }
            } else {
                this.scaleBounds.x = btnClicked.rect.x;
                this.scaleBounds.y = btnClicked.rect.y;
                this.scaleBounds.w = btnClicked.rect.w;
                this.scaleBounds.h = btnClicked.rect.h;
                this.grabList.add(new GrabEntry(btnClicked, new Vector4f(0.0f, 0.0f, 1.0f, 1.0f)));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        return false;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        return false;
    }

    @Override
    public boolean onKeyPressed(char c, int key) {
        return this.grabList.size() > 0;
    }

    @Override
    public boolean clampScrolling() {
        return this.grabList.size() <= 0;
    }

    @Override
    public void onSelection(List<PanelButtonQuest> buttons) {
    }

    @Override
    public boolean useSelection() {
        return this.grabList.size() <= 0;
    }

    private class GrabEntry {
        private final PanelButtonQuest btn;
        private final Vector4f anchor;
        private final int sx;
        private final int sy;

        private GrabEntry(PanelButtonQuest btn, Vector4f anchor) {
            this.btn = btn;
            this.anchor = anchor;
            this.sx = btn.rect.x + btn.rect.w / 2;
            this.sy = btn.rect.y + btn.rect.h / 2;
        }
    }
}

