/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainer;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainerInfo;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import WayofTime.alchemicalWizardry.common.tileEntity.TEReagentConduit;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TEBellJar
extends TEReagentConduit {
    public TEBellJar() {
        super(1, 16000);
        this.maxConnextions = 1;
        this.affectedByRedstone = false;
    }

    public int getRSPowerOutput() {
        ReagentStack stack;
        ReagentContainer thisTank = this.tanks[0];
        if (thisTank != null && (stack = thisTank.getReagent()) != null) {
            return 15 * stack.amount / thisTank.getCapacity();
        }
        return 0;
    }

    public static ReagentContainerInfo[] getContainerInfoFromItem(ItemStack stack) {
        NBTTagCompound tag;
        if (stack != null && stack.func_77973_b() instanceof ItemBlock && ModBlocks.blockCrystalBelljar == ((ItemBlock)stack.func_77973_b()).field_150939_a && (tag = stack.func_77978_p()) != null) {
            NBTTagList tagList = tag.func_150295_c("reagentTanks", 10);
            int size = tagList.func_74745_c();
            ReagentContainer[] tanks = new ReagentContainer[size];
            ReagentContainerInfo[] infos = new ReagentContainerInfo[size];
            for (int i = 0; i < size; ++i) {
                NBTTagCompound savedTag = tagList.func_150305_b(i);
                tanks[i] = ReagentContainer.readFromNBT(savedTag);
                if (tanks[i] == null) continue;
                infos[i] = tanks[i].getInfo();
            }
            return infos;
        }
        return new ReagentContainerInfo[0];
    }

    public static ReagentContainerInfo getContainerInfoFromItemForRender(ItemStack stack) {
        NBTTagList tagList;
        int size;
        NBTTagCompound tag;
        if (stack != null && stack.func_77973_b() instanceof ItemBlock && ModBlocks.blockCrystalBelljar == ((ItemBlock)stack.func_77973_b()).field_150939_a && (tag = stack.func_77978_p()) != null && (size = (tagList = tag.func_150295_c("reagentTanks", 10)).func_74745_c()) >= 1) {
            for (int i = 0; i < size; ++i) {
                NBTTagCompound savedTag = tagList.func_150305_b(i);
                if (savedTag == null) continue;
                ReagentContainer container = ReagentContainer.readFromNBT(savedTag);
                return container.getInfo();
            }
        }
        return null;
    }

    public void readTankNBTOnPlace(NBTTagCompound tag) {
        NBTTagList tagList = tag.func_150295_c("reagentTanks", 10);
        int size = tagList.func_74745_c();
        this.tanks = new ReagentContainer[size];
        for (int i = 0; i < size; ++i) {
            NBTTagCompound savedTag = tagList.func_150305_b(i);
            this.tanks[i] = ReagentContainer.readFromNBT(savedTag);
        }
    }

    public void writeTankNBT(NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.tanks.length; ++i) {
            NBTTagCompound savedTag = new NBTTagCompound();
            if (this.tanks[i] != null) {
                this.tanks[i].writeToNBT(savedTag);
            }
            tagList.func_74742_a((NBTBase)savedTag);
        }
        tag.func_74782_a("reagentTanks", (NBTBase)tagList);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.hasChanged == 1) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
            block.func_149695_a(this.field_145850_b, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, block);
            block = this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
            block.func_149695_a(this.field_145850_b, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, block);
            block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            block.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, block);
            block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            block.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, block);
            block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
            block.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, block);
            block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
            block.func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, block);
        }
    }
}

