/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block;

import cofh.api.tileentity.ISecurable;
import cofh.core.CoFHProps;
import cofh.core.RegistrySocial;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTile;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.ServerHelper;
import com.gamerforea.cofh.EventConfig;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;

public abstract class TileCoFHBase
extends TileEntity {
    public void onChunkUnload() {
        if (!this.field_145846_f) {
            this.func_145843_s();
        }
    }

    public abstract String getName();

    public abstract int getType();

    public void blockBroken() {
    }

    public void blockDismantled() {
        this.blockBroken();
    }

    public void blockPlaced() {
    }

    public void markChunkDirty() {
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }

    public void callNeighborBlockChange() {
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
    }

    public void callNeighborTileChange() {
        this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
    }

    public void onNeighborBlockChange() {
    }

    public void onNeighborTileChange(int var1, int var2, int var3) {
    }

    public int getComparatorInput(int var1) {
        return 0;
    }

    public int getLightValue() {
        return 0;
    }

    public boolean canPlayerAccess(EntityPlayer var1) {
        if (!(this instanceof ISecurable)) {
            return true;
        }
        ISecurable.AccessMode var2 = ((ISecurable)((Object)this)).getAccess();
        String var3 = var1.func_70005_c_();
        if (!(var2.isPublic() || CoFHProps.enableOpSecureAccess && CoreUtils.isOp(var3))) {
            GameProfile var4 = ((ISecurable)((Object)this)).getOwner();
            UUID var5 = var4.getId();
            if (SecurityHelper.isDefaultUUID(var5)) {
                return true;
            }
            UUID var6 = SecurityHelper.getID(var1);
            return var5.equals(var6) ? true : var2.isRestricted() && RegistrySocial.playerHasAccess(var3, var4);
        }
        return true;
    }

    public boolean canPlayerDismantle(EntityPlayer var1) {
        return true;
    }

    public boolean isUseable(EntityPlayer var1) {
        return var1.func_70092_e((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) <= 64.0 && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public boolean onWrench(EntityPlayer var1, int var2) {
        return false;
    }

    protected final boolean timeCheck() {
        return this.field_145850_b.func_82737_E() % 32L == 0L;
    }

    protected final boolean timeCheckEighth() {
        return this.field_145850_b.func_82737_E() % 4L == 0L;
    }

    public Packet func_145844_m() {
        return PacketHandler.toMCPacket(this.getPacket());
    }

    public PacketCoFHBase getPacket() {
        return new PacketTile(this);
    }

    public void sendDescPacket() {
        PacketHandler.sendToAllAround((PacketBase)this.getPacket(), this);
    }

    protected void updateLighting() {
        if (EventConfig.enableLighting) {
            int var1 = this.field_145850_b.func_72972_b(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            int var2 = this.getLightValue();
            if (var2 != var1 && this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public void sendUpdatePacket(Side var1) {
        if (this.field_145850_b != null) {
            if (var1 == Side.CLIENT && ServerHelper.isServerWorld(this.field_145850_b)) {
                PacketHandler.sendToAllAround((PacketBase)this.getPacket(), this);
            } else if (var1 == Side.SERVER && ServerHelper.isClientWorld(this.field_145850_b)) {
                PacketHandler.sendToServer(this.getPacket());
            }
        }
    }

    public Object getGuiClient(InventoryPlayer var1) {
        return null;
    }

    public Object getGuiServer(InventoryPlayer var1) {
        return null;
    }

    public int getInvSlotCount() {
        return 0;
    }

    public boolean openGui(EntityPlayer var1) {
        return false;
    }

    public void receiveGuiNetworkData(int var1, int var2) {
    }

    public void sendGuiNetworkData(Container var1, ICrafting var2) {
    }
}

