/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.render;

import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.BlockHelper;
import cofh.repack.codechicken.lib.colour.Colour;
import cofh.repack.codechicken.lib.colour.ColourRGBA;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.render.uv.IconTransformation;
import cofh.repack.codechicken.lib.render.uv.UV;
import cofh.repack.codechicken.lib.vec.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    public static final RenderItem renderItem;
    public static final RenderBlocks renderBlocks;
    public static float[][] angleBaseYNeg;
    public static float[][] angleBaseYPos;
    public static float[][] angleBaseXPos;
    public static final float factor = 0.0625f;
    public static final int[] facingAngle;
    public static ScaledIconTransformation[] renderTransformations;
    public static Vector3 renderVector;
    private static final ColourRGBA colourRGBA;

    public static ScaledIconTransformation getIconTransformation(IIcon var0) {
        if (var0 != null) {
            RenderUtils.renderTransformations[0].icon = var0;
        }
        return renderTransformations[0];
    }

    public static Vector3 getRenderVector(double var0, double var2, double var4) {
        RenderUtils.renderVector.x = var0;
        RenderUtils.renderVector.y = var2;
        RenderUtils.renderVector.z = var4;
        return renderVector;
    }

    public static int getFluidRenderColor(FluidStack var0) {
        return var0.getFluid().getColor(var0);
    }

    public static void setFluidRenderColor(FluidStack var0) {
        CCRenderState.baseColour = 0xFF | var0.getFluid().getColor(var0) << 8;
    }

    public static void preItemRender() {
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        CCRenderState.reset();
        CCRenderState.pullLightmap();
        CCRenderState.useNormals = true;
    }

    public static void postItemRender() {
        CCRenderState.useNormals = false;
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
    }

    public static void preWorldRender(IBlockAccess var0, int var1, int var2, int var3) {
        CCRenderState.reset();
        CCRenderState.setColour(-1);
        CCRenderState.setBrightness(var0, var1, var2, var3);
    }

    public static void renderMask(IIcon var0, IIcon var1, Colour var2, IItemRenderer.ItemRenderType var3) {
        if (var0 != null && var1 != null) {
            if (var2 == null) {
                var2 = colourRGBA;
            }
            var2.glColour();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2884);
            Tessellator var4 = Tessellator.field_78398_a;
            var4.func_78382_b();
            var4.func_78375_b(0.0f, 0.0f, 1.0f);
            if (var3.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
                RenderUtils.preRenderIconInv(var0, 10.0);
            } else {
                RenderUtils.preRenderIconWorld(var0, 0.001);
            }
            var4.func_78381_a();
            var4.func_78382_b();
            var4.func_78375_b(0.0f, 0.0f, -1.0f);
            if (var3.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
                RenderUtils.preRenderIconInv(var0, -0.0635);
            } else {
                RenderUtils.preRenderIconWorld(var0, -0.0635);
            }
            var4.func_78381_a();
            RenderHelper.setBlockTextureSheet();
            GL11.glDepthFunc((int)514);
            GL11.glDepthMask((boolean)false);
            var4.func_78382_b();
            var4.func_78375_b(0.0f, 0.0f, 1.0f);
            if (var3.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
                RenderUtils.preRenderIconInv(var1, 10.0);
            } else {
                RenderUtils.preRenderIconWorld(var1, 0.001);
            }
            var4.func_78381_a();
            var4.func_78382_b();
            var4.func_78375_b(0.0f, 0.0f, -1.0f);
            if (var3.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
                RenderUtils.preRenderIconInv(var1, -0.0635);
            } else {
                RenderUtils.preRenderIconWorld(var1, -0.0635);
            }
            var4.func_78381_a();
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            GL11.glDepthFunc((int)515);
            GL11.glEnable((int)2884);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void preRenderIconWorld(IIcon var0, double var1) {
        Tessellator.field_78398_a.func_78374_a(0.0, 1.0, var1, (double)var0.func_94209_e(), (double)var0.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(1.0, 1.0, var1, (double)var0.func_94212_f(), (double)var0.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(1.0, 0.0, var1, (double)var0.func_94212_f(), (double)var0.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, var1, (double)var0.func_94209_e(), (double)var0.func_94206_g());
    }

    public static void preRenderIconInv(IIcon var0, double var1) {
        Tessellator.field_78398_a.func_78374_a(0.0, 16.0, var1, (double)var0.func_94209_e(), (double)var0.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(16.0, 16.0, var1, (double)var0.func_94212_f(), (double)var0.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(16.0, 0.0, var1, (double)var0.func_94212_f(), (double)var0.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, var1, (double)var0.func_94209_e(), (double)var0.func_94206_g());
    }

    public static void renderItemStack(int var0, int var1, float var2, ItemStack var3, Minecraft var4) {
        if (var3 != null) {
            float var5 = (float)var3.field_77992_b - var2;
            if (var5 > 0.0f) {
                GL11.glPushMatrix();
                float var6 = 1.0f + var5 / 5.0f;
                GL11.glTranslatef((float)(var0 + 8), (float)(var1 + 12), (float)0.0f);
                GL11.glScalef((float)(1.0f / var6), (float)((var6 + 1.0f) / 2.0f), (float)1.0f);
                GL11.glTranslatef((float)(-(var0 + 8)), (float)(-(var1 + 12)), (float)0.0f);
            }
            renderItem.func_82406_b(var4.field_71466_p, var4.field_71446_o, var3, var0, var1);
            if (var5 > 0.0f) {
                GL11.glPopMatrix();
            }
            renderItem.func_77021_b(var4.field_71466_p, var4.field_71446_o, var3, var0, var1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderItemStackAtScale(float var0, float var1, float var2, ItemStack var3, Minecraft var4, float var5, boolean var6) {
        if (var3 != null) {
            int size = var3.field_77994_a;
            try {
                if (!var6) {
                    var3.field_77994_a = 1;
                }
                float var7 = (float)var3.field_77992_b - var2;
                RenderUtils.renderItem.field_77023_b = 500.0f;
                GL11.glPushMatrix();
                GL11.glEnable((int)2929);
                if (var7 > 0.0f) {
                    float var8 = var5 + var7 / 5.0f;
                    GL11.glTranslatef((float)(var0 + 8.0f), (float)(var1 + 12.0f), (float)0.0f);
                    GL11.glScalef((float)(var5 / var8), (float)((var8 + var5) / 2.0f), (float)var5);
                    GL11.glTranslatef((float)(-(var0 + 8.0f)), (float)(-(var1 + 12.0f)), (float)0.0f);
                } else {
                    GL11.glScalef((float)var5, (float)var5, (float)var5);
                }
                RenderUtils.renderItemAndEffectIntoGUI(var4.field_71466_p, var4.field_71446_o, var3, var0, var1);
                renderItem.func_77021_b(var4.field_71466_p, var4.field_71446_o, var3, (int)var0, (int)var1);
                GL11.glPopMatrix();
                RenderUtils.renderItem.field_77023_b = 0.0f;
            }
            finally {
                if (!var6) {
                    var3.field_77994_a = size;
                }
            }
        }
    }

    public static void renderItemAndEffectIntoGUI(FontRenderer var0, TextureManager var1, ItemStack var2, float var3, float var4) {
        if (var2 != null && !ForgeHooksClient.renderInventoryItem((RenderBlocks)renderBlocks, (TextureManager)var1, (ItemStack)var2, (boolean)RenderUtils.renderItem.field_77024_a, (float)RenderUtils.renderItem.field_77023_b, (float)var3, (float)var4)) {
            RenderUtils.renderItemIntoGUI(var0, var1, var2, var3, var4, true);
        }
    }

    public static void renderItemIntoGUI(FontRenderer var0, TextureManager var1, ItemStack var2, float var3, float var4, boolean var5) {
        Item var6 = var2.func_77973_b();
        int var7 = var2.func_77960_j();
        IIcon var8 = var2.func_77954_c();
        Block var13 = Block.func_149634_a((Item)var6);
        if (var2.func_94608_d() == 0 && var13 != null && RenderBlocks.func_147739_a((int)var13.func_149645_b())) {
            var1.func_110577_a(TextureMap.field_110575_b);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(var3 - 2.0f), (float)(var4 + 3.0f), (float)(-3.0f + RenderUtils.renderItem.field_77023_b));
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (RenderUtils.renderItem.field_77024_a) {
                int var9 = var6.func_82790_a(var2, 0);
                float var10 = (float)(var9 >> 16 & 0xFF) / 255.0f;
                float var11 = (float)(var9 >> 8 & 0xFF) / 255.0f;
                float var12 = (float)(var9 & 0xFF) / 255.0f;
                GL11.glColor4f((float)var10, (float)var11, (float)var12, (float)1.0f);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderUtils.renderBlocks.field_147844_c = RenderUtils.renderItem.field_77024_a;
            renderBlocks.func_147800_a(var13, var7, 1.0f);
            RenderUtils.renderBlocks.field_147844_c = true;
            GL11.glPopMatrix();
        } else if (var6.func_77623_v()) {
            GL11.glDisable((int)2896);
            ResourceLocation var14 = var2.func_94608_d() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c;
            var1.func_110577_a(var14);
            int var16 = var6.getRenderPasses(var7);
            for (int var15 = 0; var15 < var16; ++var15) {
                IIcon var17 = var6.getIcon(var2, var15);
                if (RenderUtils.renderItem.field_77024_a) {
                    int var9 = var6.func_82790_a(var2, var15);
                    float var10 = (float)(var9 >> 16 & 0xFF) / 255.0f;
                    float var11 = (float)(var9 >> 8 & 0xFF) / 255.0f;
                    float var12 = (float)(var9 & 0xFF) / 255.0f;
                    GL11.glColor4f((float)var10, (float)var11, (float)var12, (float)1.0f);
                }
                RenderHelper.renderIcon(var3, var4, RenderUtils.renderItem.field_77023_b, var17, 16, 16);
                if (!var2.hasEffect(var15)) continue;
                RenderUtils.renderEffect(var1, var3, var4);
                var1.func_110577_a(var14);
            }
            GL11.glEnable((int)2896);
        } else {
            GL11.glDisable((int)2896);
            ResourceLocation var14 = var1.func_130087_a(var2.func_94608_d());
            var1.func_110577_a(var14);
            if (var8 == null) {
                var8 = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(var14)).func_110572_b("missingno");
            }
            if (RenderUtils.renderItem.field_77024_a) {
                int var9 = var6.func_82790_a(var2, 0);
                float var10 = (float)(var9 >> 16 & 0xFF) / 255.0f;
                float var11 = (float)(var9 >> 8 & 0xFF) / 255.0f;
                float var12 = (float)(var9 & 0xFF) / 255.0f;
                GL11.glColor4f((float)var10, (float)var11, (float)var12, (float)1.0f);
            }
            RenderHelper.renderIcon(var3, var4, RenderUtils.renderItem.field_77023_b, var8, 16, 16);
            GL11.glEnable((int)2896);
            if (var2.hasEffect(0)) {
                RenderUtils.renderEffect(var1, var3, var4);
            }
        }
        GL11.glEnable((int)2884);
    }

    public static void renderEffect(TextureManager var0, float var1, float var2) {
        GL11.glDepthFunc((int)516);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        var0.func_110577_a(RenderHelper.MC_ITEM_GLINT);
        RenderItem var10000 = renderItem;
        var10000.field_77023_b -= 50.0f;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)774, (int)774);
        GL11.glColor4f((float)0.5f, (float)0.25f, (float)0.8f, (float)1.0f);
        RenderUtils.renderGlint(var1 - 2.0f, var2 - 2.0f, 20, 20);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        var10000 = renderItem;
        var10000.field_77023_b += 50.0f;
        GL11.glEnable((int)2896);
        GL11.glDepthFunc((int)515);
    }

    public static void renderGlint(float var0, float var1, int var2, int var3) {
        Tessellator var4 = RenderHelper.tessellator();
        float var5 = 0.00390625f;
        float var6 = 0.00390625f;
        float var7 = 4.0f;
        GL11.glBlendFunc((int)768, (int)1);
        var4.func_78382_b();
        for (int var8 = 0; var8 < 2; ++var8) {
            float var9 = (float)(Minecraft.func_71386_F() % (long)(3000 + var8 * 1873)) / (3000.0f + (float)(var8 * 1873)) * 256.0f;
            float var10 = 0.0f;
            var4.func_78374_a((double)(var0 + 0.0f), (double)(var1 + (float)var3), (double)RenderUtils.renderItem.field_77023_b, (double)((var9 + 0.0f + (float)var3 * var7) * var5), (double)((var10 + (float)var3) * var6));
            var4.func_78374_a((double)(var0 + (float)var2), (double)(var1 + (float)var3), (double)RenderUtils.renderItem.field_77023_b, (double)((var9 + (float)var2 + (float)var3 * var7) * var5), (double)((var10 + (float)var3) * var6));
            var4.func_78374_a((double)(var0 + (float)var2), (double)(var1 + 0.0f), (double)RenderUtils.renderItem.field_77023_b, (double)((var9 + (float)var2 + 0.0f) * var5), (double)((var10 + 0.0f) * var6));
            var4.func_78374_a((double)(var0 + 0.0f), (double)(var1 + 0.0f), (double)RenderUtils.renderItem.field_77023_b, (double)((var9 + 0.0f + 0.0f) * var5), (double)((var10 + 0.0f) * var6));
            var7 = -1.0f;
        }
        var4.func_78381_a();
    }

    public static final void renderItemOnBlockSide(TileEntity var0, ItemStack var1, int var2, double var3, double var5, double var7) {
        if (var1 != null) {
            GL11.glPushMatrix();
            switch (var2) {
                default: {
                    break;
                }
                case 2: {
                    GL11.glTranslated((double)(var3 + 0.75), (double)(var5 + 0.875), (double)(var7 - 9.765625E-4));
                    break;
                }
                case 3: {
                    GL11.glTranslated((double)(var3 + 0.25), (double)(var5 + 0.875), (double)(var7 + 1.0 + 9.765625E-4));
                    GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                    break;
                }
                case 4: {
                    GL11.glTranslated((double)(var3 - 9.765625E-4), (double)(var5 + 0.875), (double)(var7 + 0.25));
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    break;
                }
                case 5: {
                    GL11.glTranslated((double)(var3 + 1.0 + 9.765625E-4), (double)(var5 + 0.875), (double)(var7 + 0.75));
                    GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                }
            }
            GL11.glScaled((double)0.03125, (double)0.03125, (double)-9.765625E-4);
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
            RenderUtils.setupLight(var0, var2);
            RenderHelper.enableGUIStandardItemLighting();
            if (!ForgeHooksClient.renderInventoryItem((RenderBlocks)renderBlocks, (TextureManager)RenderHelper.engine(), (ItemStack)var1, (boolean)true, (float)0.0f, (float)0.0f, (float)0.0f)) {
                renderItem.func_77015_a(Minecraft.func_71410_x().field_71466_p, RenderHelper.engine(), var1, 0, 0);
            }
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glPopMatrix();
            net.minecraft.client.renderer.RenderHelper.func_74519_b();
        }
    }

    public static void setupLight(TileEntity var0, int var1) {
        if (var0 != null) {
            int var2 = var0.field_145851_c + BlockHelper.SIDE_COORD_MOD[var1][0];
            int var3 = var0.field_145848_d + BlockHelper.SIDE_COORD_MOD[var1][1];
            int var4 = var0.field_145849_e + BlockHelper.SIDE_COORD_MOD[var1][2];
            World var5 = var0.func_145831_w();
            if (!var5.func_147439_a(var2, var3, var4).func_149662_c()) {
                int var6 = var5.func_72802_i(var2, var3, var4, 4);
                int var7 = var6 & 0xFFFF;
                int var8 = var6 >>> 16;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)var7, (float)var8);
            }
        }
    }

    static {
        float var0;
        renderItem = new RenderItem();
        renderBlocks = new RenderBlocks();
        angleBaseYNeg = new float[6][3];
        angleBaseYPos = new float[6][3];
        angleBaseXPos = new float[6][3];
        facingAngle = new int[]{0, 0, 180, 0, 90, -90};
        renderTransformations = new ScaledIconTransformation[4];
        colourRGBA = new ColourRGBA(-1);
        RenderUtils.renderTransformations[0] = new ScaledIconTransformation(Blocks.field_150348_b.func_149691_a(0, 0));
        RenderUtils.renderTransformations[1] = new ScaledIconTransformation(Blocks.field_150348_b.func_149691_a(0, 0), -1.0, 0.0);
        RenderUtils.renderTransformations[2] = new ScaledIconTransformation(Blocks.field_150348_b.func_149691_a(0, 0), 0.0, -1.0);
        RenderUtils.renderTransformations[3] = new ScaledIconTransformation(Blocks.field_150348_b.func_149691_a(0, 0), -1.0, -1.0);
        renderVector = new Vector3();
        RenderUtils.angleBaseYNeg[0][2] = var0 = (float)Math.PI;
        RenderUtils.angleBaseYNeg[2][0] = -var0 / 2.0f;
        RenderUtils.angleBaseYNeg[3][0] = var0 / 2.0f;
        RenderUtils.angleBaseYNeg[4][2] = var0 / 2.0f;
        RenderUtils.angleBaseYNeg[5][2] = -var0 / 2.0f;
        RenderUtils.angleBaseYPos[1][2] = var0;
        RenderUtils.angleBaseYPos[2][0] = var0 / 2.0f;
        RenderUtils.angleBaseYPos[3][0] = -var0 / 2.0f;
        RenderUtils.angleBaseYPos[4][2] = -var0 / 2.0f;
        RenderUtils.angleBaseYPos[5][2] = var0 / 2.0f;
        RenderUtils.angleBaseXPos[0][0] = -var0 / 2.0f;
        RenderUtils.angleBaseXPos[1][0] = var0 / 2.0f;
        RenderUtils.angleBaseXPos[2][1] = var0;
        RenderUtils.angleBaseXPos[4][1] = -var0 / 2.0f;
        RenderUtils.angleBaseXPos[5][1] = var0 / 2.0f;
    }

    public static class ScaledIconTransformation
    extends IconTransformation {
        double su = 0.0;
        double sv = 0.0;

        public ScaledIconTransformation(IIcon var1) {
            super(var1);
        }

        public ScaledIconTransformation(IIcon var1, double var2, double var4) {
            super(var1);
            this.su = var2;
            this.sv = var4;
        }

        @Override
        public void apply(UV var1) {
            var1.u = (double)this.icon.func_94214_a(var1.u % 2.0 * 16.0) + this.su * (double)(this.icon.func_94212_f() - this.icon.func_94209_e());
            var1.v = (double)this.icon.func_94207_b(var1.v % 2.0 * 16.0) + this.sv * (double)(this.icon.func_94210_h() - this.icon.func_94206_g());
        }
    }
}

