/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.logger;

import java.util.ArrayList;
import java.util.List;
import minetweaker.api.chat.IChatMessage;
import minetweaker.api.player.IPlayer;
import minetweaker.runtime.ILogger;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StringUtils;

public class MTLogger
implements ILogger {
    private final List<ILogger> loggers = new ArrayList<ILogger>();
    private final List<IPlayer> players = new ArrayList<IPlayer>();
    private final List<String> unprocessed = new ArrayList<String>();

    public void addLogger(ILogger logger) {
        this.loggers.add(logger);
    }

    public void removeLogger(ILogger logger) {
        this.loggers.remove(logger);
    }

    public void addPlayer(IPlayer player) {
        this.players.add(player);
        if (!this.unprocessed.isEmpty()) {
            this.unprocessed.forEach(player::sendChat);
        }
    }

    public void removePlayer(IPlayer player) {
        this.players.remove(player);
    }

    public void clear() {
        this.unprocessed.clear();
    }

    @Override
    public void logCommand(String message) {
        for (ILogger logger : this.loggers) {
            logger.logCommand(message);
        }
    }

    @Override
    public void logInfo(String message) {
        for (ILogger logger : this.loggers) {
            logger.logInfo(message);
        }
    }

    @Override
    public void logWarning(String message) {
        for (ILogger logger : this.loggers) {
            logger.logWarning(message);
        }
        String message2 = "WARNING: " + message;
        if (this.players.isEmpty()) {
            this.unprocessed.add(message2);
        } else {
            for (IPlayer player : this.players) {
                player.sendChat(new CraftTweakerMessage(new ChatComponentText("[WARNING] " + message).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW))));
            }
        }
    }

    @Override
    public void logError(String message) {
        this.logError(message, null);
    }

    @Override
    public void logError(String message, Throwable exception) {
        for (ILogger logger : this.loggers) {
            logger.logError(message, exception);
        }
        String message2 = "ERROR: " + message;
        if (this.players.isEmpty()) {
            this.unprocessed.add(message2);
        } else {
            for (IPlayer player : this.players) {
                StackTraceElement[] stack;
                player.sendChat(new CraftTweakerMessage(new ChatComponentText("[ERROR] " + message).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_RED))));
                if (exception == null) continue;
                String msg = exception.getLocalizedMessage();
                if (!StringUtils.func_151246_b((String)msg)) {
                    player.sendChat(new CraftTweakerMessage(new ChatComponentText(msg).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_RED))));
                }
                if ((stack = exception.getStackTrace()) == null) continue;
                for (StackTraceElement element : stack) {
                    String elemInfo;
                    if (element == null || StringUtils.func_151246_b((String)(elemInfo = element.toString()))) continue;
                    player.sendChat(new CraftTweakerMessage(new ChatComponentText(elemInfo).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_RED))));
                }
            }
        }
    }

    public boolean contains(IPlayer player) {
        return this.players.contains(player);
    }

    private static class CraftTweakerMessage
    implements IChatMessage {
        final IChatComponent comp;

        CraftTweakerMessage(IChatComponent comp) {
            this.comp = comp;
        }

        @Override
        public IChatMessage add(IChatMessage other) {
            return other != null && other.getInternal() instanceof IChatComponent ? new CraftTweakerMessage(this.comp.func_150257_a((IChatComponent)other.getInternal())) : new CraftTweakerMessage(this.comp);
        }

        @Override
        public Object getInternal() {
            return this.comp;
        }
    }
}

