/*
 * Decompiled with CFR 0.152.
 */
package ml.luxinfine.minetweaker.mods.ic2;

import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import minetweaker.IUndoableAction;
import ml.luxinfine.minetweaker.mods.ic2.ModUtils;
import net.minecraft.item.ItemStack;

public final class IC2RecipeRemover
implements IUndoableAction {
    private final String name;
    private final IMachineRecipeManager manager;
    private final ItemStack[] outputs;
    private final List<Map.Entry<IRecipeInput, RecipeOutput>> removedRecipes = new ArrayList<Map.Entry<IRecipeInput, RecipeOutput>>();

    public IC2RecipeRemover(String name, IMachineRecipeManager manager, ItemStack ... outputs) {
        this.name = name;
        this.manager = manager;
        this.outputs = outputs == null || outputs.length == 0 ? null : outputs;
    }

    @Override
    public void apply() {
        Iterator it = this.manager.getRecipes().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry r = it.next();
            if (this.outputs != null && !ModUtils.equals(((RecipeOutput)r.getValue()).items, this.outputs)) continue;
            this.removedRecipes.add(r);
            it.remove();
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        Map crafts = this.manager.getRecipes();
        this.removedRecipes.forEach(entry -> {
            RecipeOutput cfr_ignored_0 = (RecipeOutput)crafts.put(entry.getKey(), entry.getValue());
        });
        this.removedRecipes.clear();
    }

    @Override
    public String describe() {
        return "Removing " + this.name + " recipes with outputs " + (this.outputs == null ? "ALL" : Arrays.stream(this.outputs).map(ItemStack::func_82833_r).collect(Collectors.toList()));
    }

    @Override
    public String describeUndo() {
        return "UnRemoving " + this.name + " recipes with outputs " + (this.outputs == null ? "ALL" : Arrays.stream(this.outputs).map(ItemStack::func_82833_r).collect(Collectors.toList()));
    }

    @Override
    public Object getOverrideKey() {
        return null;
    }
}

