/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.footsteps.engine.implem;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumMap;
import java.util.Map;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.interfaces.EventType;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.interfaces.IAcoustic;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.interfaces.INamedAcoustic;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.interfaces.IOptions;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.interfaces.ISoundPlayer;

@SideOnly(value=Side.CLIENT)
public class EventSelectorAcoustics
implements INamedAcoustic {
    private final String name;
    private final Map<EventType, IAcoustic> pairs = new EnumMap<EventType, IAcoustic>(EventType.class);

    public EventSelectorAcoustics(String acousticName) {
        this.name = acousticName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void playSound(ISoundPlayer player, Object location, EventType event, IOptions inputOptions) {
        IAcoustic acoustic = this.pairs.get((Object)event);
        if (acoustic != null) {
            acoustic.playSound(player, location, event, inputOptions);
        } else if (event.canTransition()) {
            this.playSound(player, location, event.getTransitionDestination(), inputOptions);
        }
    }

    public void setAcousticPair(EventType type, IAcoustic acoustic) {
        this.pairs.put(type, acoustic);
    }
}

