/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.network.EnderPacketHandler;
import com.enderio.core.common.network.PacketProgress;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public abstract class TileEntityEnder
extends TileEntity {
    private final int checkOffset = (int)(Math.random() * 20.0);
    protected final boolean isProgressTile = this instanceof IProgressTile;
    protected int lastProgressScaled = -1;
    protected int ticksSinceLastProgressUpdate;
    public boolean isGuiOpened;
    private long lastUpdate = 0L;
    private BlockCoord cachedLocation = null;

    public final boolean canUpdate() {
        return this.shouldUpdate() || this.isProgressTile;
    }

    protected boolean shouldUpdate() {
        return true;
    }

    public final void func_145845_h() {
        if (ConfigHandler.allowExternalTickSpeedup || this.field_145850_b.func_82737_E() != this.lastUpdate) {
            this.lastUpdate = this.field_145850_b.func_82737_E();
            this.doUpdate();
            if (this.isProgressTile && !this.field_145850_b.field_72995_K) {
                int curScaled = this.getProgressScaled(16);
                if (++this.ticksSinceLastProgressUpdate >= this.getProgressUpdateFreq() || curScaled != this.lastProgressScaled) {
                    this.sendTaskProgressPacket();
                    this.lastProgressScaled = curScaled;
                }
            }
        }
    }

    public final int getProgressScaled(int scale) {
        if (this.isProgressTile) {
            return Util.getProgressScaled(scale, (IProgressTile)((Object)this));
        }
        return 0;
    }

    protected void doUpdate() {
    }

    protected void sendTaskProgressPacket() {
        if (this.isProgressTile) {
            EnderPacketHandler.sendToAllAround(new PacketProgress((IProgressTile)((Object)this)), this);
        }
        this.ticksSinceLastProgressUpdate = 0;
    }

    protected int getProgressUpdateFreq() {
        return 20;
    }

    public final void func_145839_a(NBTTagCompound root) {
        super.func_145839_a(root);
        this.readCustomNBT(root);
    }

    public final void func_145841_b(NBTTagCompound root) {
        super.func_145841_b(root);
        this.writeCustomNBT(root);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readCustomNBT(pkt.func_148857_g());
    }

    public boolean canPlayerAccess(EntityPlayer player) {
        return !this.func_145837_r() && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    protected abstract void writeCustomNBT(NBTTagCompound var1);

    protected abstract void readCustomNBT(NBTTagCompound var1);

    protected void updateBlock() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    protected boolean isPoweredRedstone() {
        return this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e) ? this.field_145850_b.func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0 : false;
    }

    public void init() {
    }

    public BlockCoord getLocation() {
        return this.cachedLocation == null || !this.cachedLocation.equals(this.field_145851_c, this.field_145848_d, this.field_145849_e) ? (this.cachedLocation = new BlockCoord(this)) : this.cachedLocation;
    }

    protected boolean shouldDoWorkThisTick(int interval) {
        return this.shouldDoWorkThisTick(interval, 0);
    }

    protected boolean shouldDoWorkThisTick(int interval, int offset) {
        return (this.field_145850_b.func_82737_E() + (long)this.checkOffset + (long)offset) % (long)interval == 0L;
    }

    public void setGhostSlotContents(int slot, ItemStack stack) {
    }
}

