/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.capbank.GuiCapBank;
import crazypants.enderio.machine.capbank.network.ClientNetworkManager;
import crazypants.enderio.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.machine.capbank.network.NetworkState;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;

public class PacketNetworkStateResponse
implements IMessage,
IMessageHandler<PacketNetworkStateResponse, IMessage> {
    private int id;
    private NetworkState state;

    public PacketNetworkStateResponse() {
    }

    public PacketNetworkStateResponse(ICapBankNetwork network) {
        this(network, false);
    }

    public PacketNetworkStateResponse(ICapBankNetwork network, boolean remove) {
        this.id = network.getId();
        this.state = !remove ? network.getState() : null;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeBoolean(this.state != null);
        if (this.state != null) {
            this.state.writeToBuf(buf);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        boolean hasState = buf.readBoolean();
        this.state = hasState ? NetworkState.readFromBuf(buf) : null;
    }

    public IMessage onMessage(PacketNetworkStateResponse message, MessageContext ctx) {
        if (message.state != null) {
            GuiCapBank bank;
            ClientNetworkManager.getInstance().updateState(EnderIO.proxy.getClientWorld(), message.id, message.state);
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiCapBank && (bank = (GuiCapBank)Minecraft.func_71410_x().field_71462_r).getBoundedNetworkID() == message.id) {
                bank.updateFieldsFromState();
            }
        } else {
            ClientNetworkManager.getInstance().destroyNetwork(message.id);
        }
        return null;
    }
}

