/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import com.enderio.core.client.gui.widget.GhostBackgroundItemSlot;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.machine.gui.AbstractMachineContainer;
import crazypants.enderio.machine.invpanel.PacketItemList;
import crazypants.enderio.machine.invpanel.PacketMoveItems;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import crazypants.enderio.machine.invpanel.server.ChangeLog;
import crazypants.enderio.machine.invpanel.server.InventoryDatabaseServer;
import crazypants.enderio.machine.invpanel.server.ItemEntry;
import crazypants.enderio.network.PacketHandler;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class InventoryPanelContainer
extends AbstractMachineContainer<TileInventoryPanel>
implements ChangeLog {
    public static final int CRAFTING_GRID_X = 31;
    public static final int CRAFTING_GRID_Y = 16;
    public static final int RETURN_INV_X = 31;
    public static final int RETURN_INV_Y = 82;
    public static final int FILTER_SLOT_X = 257;
    public static final int FILTER_SLOT_Y = 7;
    private final HashSet<ItemEntry> changedItems;
    private Slot slotFilter;
    private int slotCraftResult;
    private int firstSlotReturn;
    private int endSlotReturn;
    private int firstSlotCraftingGrid;
    private int endSlotCraftingGrid;
    private boolean updateReturnAreaSlots;
    private boolean storedRecipeExists;

    public InventoryPanelContainer(InventoryPlayer playerInv, TileInventoryPanel te) {
        super(playerInv, te);
        te.eventHandler = this;
        this.changedItems = te.func_145831_w().field_72995_K ? null : new HashSet();
    }

    @Override
    protected void addMachineSlots(InventoryPlayer playerInv) {
        int x;
        int y;
        this.slotCraftResult = this.field_75151_b.size();
        this.func_75146_a((Slot)new SlotCrafting(playerInv.field_70458_d, this.getInv(), this.getInv(), 9, 90, 34){

            public void func_82870_a(EntityPlayer player, ItemStack p_82870_2_) {
                FMLCommonHandler.instance().firePlayerCraftingEvent(player, p_82870_2_, InventoryPanelContainer.this.getInv());
                for (int i = 0; i < 9; ++i) {
                    ItemStack itemstack = ((TileInventoryPanel)InventoryPanelContainer.this.getInv()).func_70301_a(i);
                    if (itemstack == null) continue;
                    ((TileInventoryPanel)InventoryPanelContainer.this.getInv()).func_70298_a(i, 1);
                    if (!itemstack.func_77973_b().hasContainerItem(itemstack)) continue;
                    ItemStack containerIS = itemstack.func_77973_b().getContainerItem(itemstack);
                    if (containerIS != null && containerIS.func_77984_f() && containerIS.func_77960_j() > containerIS.func_77958_k()) {
                        MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, containerIS));
                        continue;
                    }
                    if (itemstack.func_77973_b().func_77630_h(itemstack) && (ItemUtil.doInsertItem((IInventory)InventoryPanelContainer.this.getInv(), (int)10, (int)20, (ItemStack)containerIS) > 0 || player.field_71071_by.func_70441_a(containerIS))) continue;
                    if (((TileInventoryPanel)InventoryPanelContainer.this.getInv()).func_70301_a(i) == null) {
                        ((TileInventoryPanel)InventoryPanelContainer.this.getInv()).func_70299_a(i, containerIS);
                        continue;
                    }
                    player.func_71019_a(containerIS, false);
                }
            }

            public ItemStack func_75209_a(int p_75209_1_) {
                if (this.func_75216_d()) {
                    return super.func_75209_a(this.func_75211_c().field_77994_a);
                }
                return super.func_75209_a(p_75209_1_);
            }
        });
        this.firstSlotCraftingGrid = this.field_75151_b.size();
        int i = 0;
        for (y = 0; y < 3; ++y) {
            x = 0;
            while (x < 3) {
                this.func_75146_a(new Slot(this.getInv(), i, 31 + x * 18, 16 + y * 18));
                ++x;
                ++i;
            }
        }
        this.endSlotCraftingGrid = this.field_75151_b.size();
        this.slotFilter = this.func_75146_a(new Slot(this.getInv(), 10, 257, 7){

            public int func_75219_a() {
                return 1;
            }
        });
        this.firstSlotReturn = this.field_75151_b.size();
        i = 11;
        for (y = 0; y < 2; ++y) {
            x = 0;
            while (x < 5) {
                this.func_75146_a(new Slot(this.getInv(), i, 31 + x * 18, 82 + y * 18));
                ++x;
                ++i;
            }
        }
        this.endSlotReturn = this.field_75151_b.size();
    }

    public void createGhostSlots(List<GhostSlot> slots) {
        slots.add((GhostSlot)new GhostBackgroundItemSlot((Item)EnderIO.itemBasicFilterUpgrade, 257, 7));
    }

    @Override
    public Point getPlayerInventoryOffset() {
        return new Point(63, 130);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!((TileInventoryPanel)this.getInv()).func_145831_w().field_72995_K) {
            ((TileInventoryPanel)this.getInv()).eventHandler = null;
        }
        this.removeChangeLog();
    }

    public TileInventoryPanel getInventoryPanel() {
        return (TileInventoryPanel)this.getInv();
    }

    public Slot getSlotFilter() {
        return this.slotFilter;
    }

    public List<Slot> getCraftingGridSlots() {
        return this.field_75151_b.subList(this.firstSlotCraftingGrid, this.endSlotCraftingGrid);
    }

    public List<Slot> getReturnAreaSlots() {
        return this.field_75151_b.subList(this.firstSlotReturn, this.endSlotReturn);
    }

    public List<Slot> getPlayerInventorySlots() {
        return this.field_75151_b.subList(this.startPlayerSlot, this.endPlayerSlot);
    }

    public List<Slot> getPlayerHotbarSlots() {
        return this.field_75151_b.subList(this.startHotBarSlot, this.endHotBarSlot);
    }

    private void removeChangeLog() {
        InventoryDatabaseServer db;
        if (this.changedItems != null && (db = this.getInventoryPanel().getDatabaseServer()) != null) {
            db.removeChangeLog(this);
        }
    }

    public void func_82847_b(ICrafting crafting) {
        super.func_82847_b(crafting);
        this.removeChangeLog();
    }

    public void func_75132_a(ICrafting crafting) {
        InventoryDatabaseServer db;
        if (this.changedItems != null) {
            this.sendChangeLog();
        }
        super.func_75132_a(crafting);
        if (this.changedItems != null && (db = this.getInventoryPanel().getDatabaseServer()) != null) {
            db.addChangeLog(this);
            if (crafting instanceof EntityPlayerMP) {
                try {
                    byte[] compressed = db.compressItemList();
                    PacketItemList pil = new PacketItemList(this.getInventoryPanel(), db.getGeneration(), compressed);
                    PacketHandler.sendTo((IMessage)pil, (EntityPlayerMP)crafting);
                }
                catch (IOException ex) {
                    Logger.getLogger(InventoryPanelContainer.class.getName()).log(Level.SEVERE, "Exception while compressing item list", ex);
                }
            }
        }
    }

    public void func_75130_a(IInventory inv) {
        InventoryCrafting tmp = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer ep) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            tmp.func_70299_a(i, ((TileInventoryPanel)this.getInv()).func_70301_a(i));
        }
        ((TileInventoryPanel)this.getInv()).func_70299_a(9, CraftingManager.func_77594_a().func_82787_a(tmp, ((TileInventoryPanel)this.getInv()).func_145831_w()));
        this.checkCraftingRecipes();
    }

    public void checkCraftingRecipes() {
        this.storedRecipeExists = false;
        int storedCraftingRecipes = this.getInventoryPanel().getStoredCraftingRecipes();
        if (this.hasCraftingRecipe() && storedCraftingRecipes > 0) {
            List<Slot> craftingGrid = this.getCraftingGridSlots();
            for (int idx = 0; idx < storedCraftingRecipes; ++idx) {
                if (!this.getInventoryPanel().getStoredCraftingRecipe(idx).isEqual(craftingGrid)) continue;
                this.storedRecipeExists = true;
                break;
            }
        }
    }

    public boolean func_94530_a(ItemStack par1, Slot slot) {
        return !(slot instanceof SlotCrafting) && super.func_94530_a(par1, slot);
    }

    public boolean clearCraftingGrid() {
        boolean cleared = true;
        for (Slot slot : this.getCraftingGridSlots()) {
            if (!slot.func_75216_d()) continue;
            this.moveItemsToReturnArea(slot.field_75222_d);
            if (!slot.func_75216_d()) continue;
            cleared = false;
        }
        return cleared;
    }

    public boolean hasCraftingRecipe() {
        return this.func_75139_a(this.slotCraftResult).func_75216_d();
    }

    public boolean hasNewCraftingRecipe() {
        return this.hasCraftingRecipe() && !this.storedRecipeExists;
    }

    @Override
    protected List<AbstractMachineContainer.SlotRange> getTargetSlotsForTransfer(int slotIndex, Slot slot) {
        if (slotIndex == this.slotCraftResult || slotIndex >= this.firstSlotReturn && slotIndex < this.endSlotReturn) {
            return Collections.singletonList(this.getPlayerInventorySlotRange(true));
        }
        if (slotIndex >= this.firstSlotCraftingGrid && slotIndex < this.endSlotCraftingGrid) {
            ArrayList<AbstractMachineContainer.SlotRange> res = new ArrayList<AbstractMachineContainer.SlotRange>();
            res.add(new AbstractMachineContainer.SlotRange(this.firstSlotReturn, this.endSlotReturn, false));
            res.add(this.getPlayerInventorySlotRange(false));
            return res;
        }
        if (slotIndex >= this.startPlayerSlot) {
            return Collections.singletonList(new AbstractMachineContainer.SlotRange(this.firstSlotReturn, this.endSlotReturn, false));
        }
        return Collections.emptyList();
    }

    protected boolean func_75135_a(ItemStack par1ItemStack, int fromIndex, int toIndex, boolean reversOrder) {
        if (!super.func_75135_a(par1ItemStack, fromIndex, toIndex, reversOrder)) {
            return false;
        }
        if (fromIndex < this.endSlotReturn && toIndex > this.firstSlotReturn) {
            this.updateReturnAreaSlots = true;
        }
        return true;
    }

    public void func_75142_b() {
        if (this.updateReturnAreaSlots) {
            this.updateReturnAreaSlots = false;
            this.sendReturnAreaSlots();
        }
        super.func_75142_b();
    }

    private void sendReturnAreaSlots() {
        for (int slotIdx = this.firstSlotReturn; slotIdx < this.endSlotReturn; ++slotIdx) {
            ItemStack stack = ((Slot)this.field_75151_b.get(slotIdx)).func_75211_c();
            if (stack != null) {
                stack = stack.func_77946_l();
            }
            this.field_75153_a.set(slotIdx, stack);
            for (Object crafter : this.field_75149_d) {
                ((ICrafting)crafter).func_71111_a((Container)this, slotIdx, stack);
            }
        }
    }

    @Override
    public void entryChanged(ItemEntry entry) {
        this.changedItems.add(entry);
    }

    @Override
    public void databaseReset() {
        this.changedItems.clear();
    }

    @Override
    public void sendChangeLog() {
        InventoryDatabaseServer db;
        if (!this.changedItems.isEmpty() && !this.field_75149_d.isEmpty() && (db = this.getInventoryPanel().getDatabaseServer()) != null) {
            try {
                byte[] compressed = db.compressChangedItems(this.changedItems);
                PacketItemList pil = new PacketItemList(this.getInventoryPanel(), db.getGeneration(), compressed);
                for (Object crafting : this.field_75149_d) {
                    if (!(crafting instanceof EntityPlayerMP)) continue;
                    PacketHandler.sendTo((IMessage)pil, (EntityPlayerMP)crafting);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(InventoryPanelContainer.class.getName()).log(Level.SEVERE, "Exception while compressing changed items", ex);
            }
        }
        this.changedItems.clear();
    }

    public int getSlotIndex(IInventory inv, int index) {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!slot.func_75217_a(inv, index)) continue;
            return i;
        }
        return -1;
    }

    public void executeFetchItems(EntityPlayerMP player, int generation, int dbID, int targetSlot, int count) {
        TileInventoryPanel te = this.getInventoryPanel();
        InventoryDatabaseServer db = te.getDatabaseServer();
        if (db == null || db.getGeneration() != generation || !db.isCurrent()) {
            return;
        }
        ItemEntry entry = (ItemEntry)db.getExistingItem(dbID);
        if (entry != null) {
            int extracted;
            int maxStackSize;
            ItemStack targetStack;
            Slot slot;
            if (targetSlot < 0) {
                slot = null;
                targetStack = player.field_71071_by.func_70445_o();
                maxStackSize = player.field_71071_by.func_70297_j_();
            } else {
                slot = this.func_75139_a(targetSlot);
                targetStack = slot.func_75211_c();
                maxStackSize = slot.func_75219_a();
            }
            ItemStack tmpStack = new ItemStack(entry.getItem(), 0, entry.meta);
            Log.info("Loading item from ID " + entry.itemID + ". Result: " + Item.field_150901_e.func_148750_c((Object)tmpStack.func_77973_b()) + "  side: " + FMLCommonHandler.instance().getEffectiveSide());
            tmpStack.field_77990_d = entry.nbt;
            maxStackSize = Math.min(maxStackSize, tmpStack.func_77976_d());
            if (targetStack != null && targetStack.field_77994_a > 0) {
                if (!ItemUtil.areStackMergable((ItemStack)tmpStack, (ItemStack)targetStack)) {
                    return;
                }
            } else {
                targetStack = tmpStack.func_77946_l();
            }
            if ((count = Math.min(count, maxStackSize - targetStack.field_77994_a)) > 0 && (extracted = db.extractItems(entry, count, te)) > 0) {
                targetStack.field_77994_a += extracted;
                this.sendChangeLog();
                if (slot != null) {
                    slot.func_75215_d(targetStack);
                } else {
                    player.field_71071_by.func_70437_b(targetStack);
                    player.func_71113_k();
                }
            }
        }
    }

    public boolean moveItemsToReturnArea(int fromSlot) {
        return this.moveItems(fromSlot, this.firstSlotReturn, this.endSlotReturn, Short.MAX_VALUE);
    }

    public boolean moveItems(int fromSlot, int toSlotStart, int toSlotEnd, int amount) {
        if (!this.executeMoveItems(fromSlot, toSlotStart, toSlotEnd, amount)) {
            return false;
        }
        if (((TileInventoryPanel)this.getInv()).func_145831_w().field_72995_K) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketMoveItems(fromSlot, toSlotStart, toSlotEnd, amount));
        }
        return true;
    }

    public boolean executeMoveItems(int fromSlot, int toSlotStart, int toSlotEnd, int amount) {
        if (fromSlot >= toSlotStart && fromSlot < toSlotEnd || toSlotEnd <= toSlotStart || amount <= 0) {
            return false;
        }
        Slot srcSlot = this.func_75139_a(fromSlot);
        ItemStack src = srcSlot.func_75211_c();
        if (src != null) {
            ItemStack toMove = src.func_77946_l();
            toMove.field_77994_a = Math.min(src.field_77994_a, amount);
            int remaining = src.field_77994_a - toMove.field_77994_a;
            if (this.func_75135_a(toMove, toSlotStart, toSlotEnd, false)) {
                if ((remaining += toMove.field_77994_a) == 0) {
                    srcSlot.func_75215_d(null);
                } else {
                    src.field_77994_a = remaining;
                    srcSlot.func_75218_e();
                }
                return true;
            }
        }
        return false;
    }
}

