/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.recipe;

import com.gamerforea.enderio.util.FastOreDictionary;
import crazypants.enderio.machine.recipe.RecipeInput;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryRecipeInput
extends RecipeInput {
    private int oreId;

    public OreDictionaryRecipeInput(ItemStack itemStack, int oreId, int slot) {
        this(itemStack, oreId, 1.0f, slot);
    }

    public OreDictionaryRecipeInput(ItemStack stack, int oreId, float multiplier, int slot) {
        super(stack, true, multiplier, slot);
        this.oreId = oreId;
    }

    public OreDictionaryRecipeInput(OreDictionaryRecipeInput copy) {
        super(copy.getInput(), true, copy.getMulitplier(), copy.getSlotNumber());
        this.oreId = copy.oreId;
    }

    @Override
    public RecipeInput copy() {
        return new OreDictionaryRecipeInput(this);
    }

    @Override
    public boolean isInput(ItemStack test) {
        if (test == null || this.oreId < 0) {
            return false;
        }
        try {
            int[] ids;
            for (int id : ids = FastOreDictionary.getOreIDs((ItemStack)test)) {
                if (id != this.oreId) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public ItemStack[] getEquivelentInputs() {
        ArrayList res = OreDictionary.getOres((Integer)this.oreId);
        if (res == null || res.isEmpty()) {
            return null;
        }
        int size = res.size();
        int stackSize = this.getInput().field_77994_a;
        ItemStack[] res2 = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            ItemStack stack = ((ItemStack)res.get(i)).func_77946_l();
            stack.field_77994_a = stackSize;
            res2[i] = stack;
        }
        return res2;
    }

    @Override
    public String toString() {
        return "OreDictionaryRecipeInput [oreId=" + this.oreId + " name=" + OreDictionary.getOreName((int)this.oreId) + " amount=" + this.getInput().field_77994_a + "]";
    }
}

