/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.tool;

import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.api.tool.ITool;
import crazypants.enderio.item.ItemYetaWrench;
import crazypants.enderio.tool.IToolProvider;
import crazypants.enderio.tool.TEToolProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ToolUtil {
    private static ToolUtil instance;
    private final List<IToolProvider> toolProviders = new ArrayList<IToolProvider>();

    public static boolean isToolEquipped(EntityPlayer player) {
        return ToolUtil.getInstance().isToolEquippedImpl(player);
    }

    public static ITool getEquippedTool(EntityPlayer player) {
        return ToolUtil.getInstance().getEquippedToolImpl(player);
    }

    public static ItemYetaWrench addInterfaces(ItemYetaWrench item) {
        return item;
    }

    public static boolean breakBlockWithTool(Block block, World world, int x, int y, int z, EntityPlayer entityPlayer) {
        ITool tool = ToolUtil.getEquippedTool(entityPlayer);
        if (tool != null && entityPlayer.func_70093_af() && tool.canUse(entityPlayer.func_71045_bC(), entityPlayer, x, y, z)) {
            if (block.removedByPlayer(world, entityPlayer, x, y, z, true)) {
                block.func_149636_a(world, entityPlayer, x, y, z, world.func_72805_g(x, y, z));
            }
            tool.used(entityPlayer.func_71045_bC(), entityPlayer, x, y, z);
            return true;
        }
        return false;
    }

    private static ToolUtil getInstance() {
        if (instance == null) {
            instance = new ToolUtil();
        }
        return instance;
    }

    private ToolUtil() {
        Object obj;
        try {
            obj = Class.forName("crazypants.enderio.tool.BuildCraftToolProvider").newInstance();
            this.toolProviders.add((IToolProvider)obj);
        }
        catch (Exception e) {
            Log.warn("Could not find Build Craft Wrench definition. Wrench integration with other mods may fail");
        }
        try {
            obj = Class.forName("crazypants.enderio.tool.AEToolProvider").newInstance();
            this.toolProviders.add((IToolProvider)obj);
        }
        catch (Exception e) {
            Log.debug("Could not find AE Wrench definition. Wrench integration with AE may fail");
        }
        this.toolProviders.add(new TEToolProvider());
    }

    public void registerToolProvider(IToolProvider toolProvider) {
        this.toolProviders.add(toolProvider);
    }

    private boolean isToolEquippedImpl(EntityPlayer player) {
        return this.getEquippedToolImpl(player) != null;
    }

    private ITool getEquippedToolImpl(EntityPlayer player) {
        EntityPlayer entityPlayer = player = player == null ? EnderIO.proxy.getClientPlayer() : player;
        if (player == null) {
            return null;
        }
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null) {
            return null;
        }
        if (equipped.func_77973_b() instanceof ITool) {
            return (ITool)equipped.func_77973_b();
        }
        return this.getToolImpl(equipped);
    }

    private ITool getToolImpl(ItemStack equipped) {
        for (IToolProvider provider : this.toolProviders) {
            ITool result = provider.getTool(equipped);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

