/*
 * Decompiled with CFR 0.152.
 */
package ExAstris.Bridge;

import ExAstris.Block.BlockBarrelThaumium;
import ExAstris.Block.BlockQStronglyCompressedStone;
import ExAstris.Block.BlockSieveAutomatic;
import ExAstris.Block.TileEntity.TileEntityBarrelThaumium;
import ExAstris.Block.TileEntity.TileEntitySieveAutomatic;
import ExAstris.Block.TileEntity.TileEntityStronglyCompressedStone;
import java.text.DecimalFormat;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Waila
implements IWailaDataProvider {
    public static void callbackRegister(IWailaRegistrar registrar) {
        Waila instance = new Waila();
        registrar.registerBodyProvider((IWailaDataProvider)instance, BlockBarrelThaumium.class);
        registrar.registerBodyProvider((IWailaDataProvider)instance, BlockSieveAutomatic.class);
        registrar.registerBodyProvider((IWailaDataProvider)instance, BlockQStronglyCompressedStone.class);
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack stack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currentTip;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getBlock() instanceof BlockBarrelThaumium) {
            TileEntityBarrelThaumium teBarrel = (TileEntityBarrelThaumium)accessor.getTileEntity();
            currentTip.add(this.getBarrelDisplay(teBarrel.getMode(), teBarrel));
        } else if (accessor.getBlock() instanceof BlockSieveAutomatic) {
            TileEntitySieveAutomatic teSieve = (TileEntitySieveAutomatic)accessor.getTileEntity();
            currentTip.add(this.getSieveDisplay(teSieve));
        } else if (accessor.getBlock() instanceof BlockQStronglyCompressedStone) {
            TileEntityStronglyCompressedStone scStone = (TileEntityStronglyCompressedStone)accessor.getTileEntity();
            currentTip.add(this.getSCStoneDisplay(scStone));
        }
        return currentTip;
    }

    public List<String> getWailaTail(ItemStack stack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getBlock() instanceof BlockSieveAutomatic) {
            TileEntitySieveAutomatic teSieve = (TileEntitySieveAutomatic)accessor.getTileEntity();
            currentTip.add(this.getSieveDisplayTail(teSieve));
        }
        return currentTip;
    }

    public String getBarrelDisplay(TileEntityBarrelThaumium.BarrelMode mode, TileEntityBarrelThaumium barrel) {
        DecimalFormat format = new DecimalFormat("##.#");
        switch (mode) {
            case EMPTY: {
                return "Empty";
            }
            case FLUID: {
                if (barrel.isFull()) {
                    return barrel.fluid.getFluid().getName();
                }
                return barrel.fluid.getFluid().getName() + " " + format.format(barrel.getVolume() * 100.0f) + "%";
            }
            case COMPOST: {
                if (barrel.isFull()) {
                    return "Composting: " + Math.round(this.getBarrelTimeRemaining(barrel)) + "%";
                }
                return "Collecting Material: " + format.format(barrel.getVolume() * 100.0f) + "%";
            }
            case DIRT: {
                return "Dirt";
            }
            case CLAY: {
                return "Clay";
            }
            case MILKED: {
                return "Sliming: " + Math.round(this.getBarrelTimeRemaining(barrel)) + "%";
            }
            case SLIME: {
                return "Slime";
            }
            case SPORED: {
                return "Transforming: " + Math.round(this.getBarrelTimeRemaining(barrel)) + "%";
            }
            case ENDER_COOKING: 
            case BLAZE_COOKING: 
            case PECK_COOKING: 
            case BLIZZ_COOKING: {
                return "Summoning: " + Math.round(this.getBarrelTimeRemaining(barrel)) + "%";
            }
            case ENDER: 
            case BLAZE: 
            case PECK: 
            case BLIZZ: {
                return "Incoming!";
            }
            case DARKOAK: {
                return "Dark Oak Sapling";
            }
            case BEETRAP: {
                return "Scented Artifical Hive";
            }
            case COBBLESTONE: {
                return "Cobblestone";
            }
            case ENDSTONE: {
                return "End Stone";
            }
            case NETHERRACK: {
                return "Netherrack";
            }
            case OBSIDIAN: {
                return "Obsidian";
            }
            case SOULSAND: {
                return "Soul Sand";
            }
            case OBSIDIANTOTEM: {
                return "Obsidian Totem";
            }
            case BEEINFUSED: {
                return "Infused Artifical Hive";
            }
            case BLOCK: {
                return barrel.block.func_149732_F();
            }
        }
        return "";
    }

    public String getSieveDisplay(TileEntitySieveAutomatic sieve) {
        if (sieve.mode == TileEntitySieveAutomatic.SieveMode.EMPTY) {
            return "Empty";
        }
        return Math.round(this.getSieveClicksRemaining(sieve)) + "% left";
    }

    public String getSCStoneDisplay(TileEntityStronglyCompressedStone stone) {
        DecimalFormat format = new DecimalFormat("##.#");
        return "Transforming: " + format.format(stone.getVolume() * 100.0f) + "%";
    }

    public String getSieveDisplayTail(TileEntitySieveAutomatic sieve) {
        return sieve.storage.getEnergyStored() + " / " + sieve.storage.getMaxEnergyStored() + " RF";
    }

    public float getBarrelTimeRemaining(TileEntityBarrelThaumium barrel) {
        return (float)barrel.getTimer() / 1000.0f * 100.0f;
    }

    public float getSieveClicksRemaining(TileEntitySieveAutomatic sieve) {
        return sieve.getVolume() / 1.0f * 100.0f;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return null;
    }
}

