/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.blocks.tileentities;

import exnihilo.ENBlocks;
import exnihilo.ENItems;
import exnihilo.Fluids;
import exnihilo.data.ModData;
import exnihilo.network.ENPacketHandler;
import exnihilo.network.MessageBarrel;
import exnihilo.network.VanillaPacket;
import exnihilo.registries.BarrelRecipeRegistry;
import exnihilo.registries.ColorRegistry;
import exnihilo.registries.CompostRegistry;
import exnihilo.registries.helpers.Color;
import exnihilo.registries.helpers.Compostable;
import exnihilo.registries.helpers.EntityWithItem;
import exnihilo.utils.ItemInfo;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityBarrel
extends TileEntity
implements IFluidHandler,
ISidedInventory {
    private static final float MIN_RENDER_CAPACITY = 0.1f;
    private static final float MAX_RENDER_CAPACITY = 0.9f;
    private static final int MAX_COMPOSTING_TIME = 1000;
    private static final int MAX_FLUID = 1000;
    private static final int UPDATE_INTERVAL = 10;
    private static final int MOSS_SPREAD_X_POS = 2;
    private static final int MOSS_SPREAD_X_NEG = -2;
    private static final int MOSS_SPREAD_Y_POS = 2;
    private static final int MOSS_SPREAD_Y_NEG = -1;
    private static final int MOSS_SPREAD_Z_POS = 2;
    private static final int MOSS_SPREAD_Z_NEG = -2;
    public FluidStack fluid;
    private float volume;
    private int timer;
    private BarrelMode mode;
    public Block block;
    public int blockMeta;
    public Color color;
    private Color colorBase = this.color = ColorRegistry.color("white");
    public IIcon icon;
    public ItemStack outputStack;
    public Fluid transformFluid;
    public Block transformBlock;
    public int transformMeta;
    public EntityLivingBase entity;
    public String entityParticleName;
    public ItemStack peacefulDrop;
    private boolean needsUpdate = false;
    private int updateTimer = 0;

    public BarrelMode getMode() {
        return this.mode;
    }

    public void setMode(BarrelMode mode) {
        this.mode = mode;
        this.needsUpdate = true;
    }

    public TileEntityBarrel() {
        this.setMode(BarrelMode.EMPTY);
        this.volume = 0.0f;
        this.timer = 0;
        this.fluid = new FluidStack(FluidRegistry.WATER, 0);
    }

    public void func_145845_h() {
        if (this.updateTimer >= 10) {
            this.updateTimer = 0;
            if (this.needsUpdate) {
                this.needsUpdate = false;
                VanillaPacket.sendTileEntityUpdate(this);
            }
        } else {
            ++this.updateTimer;
        }
        switch (this.getMode()) {
            case EMPTY: {
                if (this.field_145850_b.field_72995_K || !this.field_145850_b.func_72896_J() || this.field_145848_d < this.field_145850_b.func_72825_h(this.field_145851_c, this.field_145849_e) - 1 || !(this.field_145850_b.func_72807_a((int)this.field_145851_c, (int)this.field_145849_e).field_76751_G > 0.0f) || !ModData.ALLOW_BARREL_FILL_RAIN) break;
                this.fluid = new FluidStack(FluidRegistry.WATER, 0);
                this.setMode(BarrelMode.FLUID);
                break;
            }
            case FLUID: {
                HashSet<ItemInfo> nearby;
                if (!this.field_145850_b.field_72995_K && this.isFull() && (nearby = this.getNearbyBlocks()) != null) {
                    for (ItemInfo next : this.getNearbyBlocks()) {
                        Fluid potentialFluid;
                        if (Block.func_149634_a((Item)next.getItem()) == Blocks.field_150350_a || (potentialFluid = BarrelRecipeRegistry.getFluidTransformRecipeOutput(this.fluid.getFluid(), Block.func_149634_a((Item)next.getItem()), next.getMeta())) == null) continue;
                        this.transformFluid = potentialFluid;
                        this.transformBlock = Block.func_149634_a((Item)next.getItem());
                        this.transformMeta = next.getMeta();
                        this.setMode(BarrelMode.FLUIDTRANSFORM);
                        VanillaPacket.sendTileEntityUpdate(this);
                    }
                }
                if (this.fluid.getFluidID() == FluidRegistry.WATER.getID()) {
                    if (!this.field_145850_b.field_72995_K && !this.isFull() && this.field_145850_b.func_72896_J() && this.field_145848_d >= this.field_145850_b.func_72825_h(this.field_145851_c, this.field_145849_e) - 1 && this.field_145850_b.func_72807_a((int)this.field_145851_c, (int)this.field_145849_e).field_76751_G > 0.0f && ModData.ALLOW_BARREL_FILL_RAIN) {
                        this.volume += this.field_145850_b.func_72807_a((int)this.field_145851_c, (int)this.field_145849_e).field_76751_G / 1000.0f;
                        if (this.volume > 1.0f) {
                            this.volume = 1.0f;
                        }
                        this.fluid.amount = (int)(1000.0f * this.volume);
                        this.needsUpdate = true;
                    }
                    if (!this.field_145850_b.field_72995_K && this.isFull() && ModData.ALLOW_BARREL_RECIPE_SOULSAND && this.getNearbyBlocks((Block)Blocks.field_150391_bh, 0) > 0) {
                        this.colorBase = new Color(this.fluid.getFluid().getColor());
                        this.setMode(BarrelMode.SPORED);
                        this.needsUpdate = true;
                    }
                    if (this.isFull() && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == FluidRegistry.LAVA.getBlock()) {
                        this.setMode(BarrelMode.COBBLESTONE);
                    }
                    if (!this.field_145850_b.field_72995_K && this.fluid.amount > 0 && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_149688_o().func_76217_h() && this.field_145850_b.field_73012_v.nextInt(500) == 0) {
                        int x = this.field_145851_c + (this.field_145850_b.field_73012_v.nextInt(5) + -2);
                        int y = this.field_145848_d + (this.field_145850_b.field_73012_v.nextInt(4) + -1);
                        int z = this.field_145849_e + (this.field_145850_b.field_73012_v.nextInt(5) + -2);
                        int lightLevel = this.field_145850_b.func_72957_l(x, y + 1, z);
                        if (!this.field_145850_b.func_147437_c(x, y, z) && this.field_145850_b.func_72825_h(x, z) > y && lightLevel >= 9 && lightLevel <= 11) {
                            Block selected = this.field_145850_b.func_147439_a(x, y, z);
                            int meta = this.field_145850_b.func_72805_g(x, y, z);
                            if (selected == Blocks.field_150417_aV && meta == 0) {
                                this.field_145850_b.func_147465_d(x, y, z, Blocks.field_150417_aV, 1, 3);
                                this.drain(ForgeDirection.DOWN, 100, true);
                            }
                            if (selected == Blocks.field_150347_e) {
                                this.field_145850_b.func_147465_d(x, y, z, Blocks.field_150341_Y, 0, 3);
                                this.drain(ForgeDirection.DOWN, 100, true);
                            }
                        }
                    }
                }
                if (this.fluid.getFluidID() != FluidRegistry.LAVA.getID()) break;
                if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_149688_o().func_76217_h()) {
                    ++this.timer;
                    if (this.timer % 30 == 0) {
                        this.field_145850_b.func_72869_a("largesmoke", (double)this.field_145851_c + Math.random(), (double)this.field_145848_d + 1.2, (double)this.field_145849_e + Math.random(), 0.0, 0.0, 0.0);
                    }
                    if (this.timer % 5 == 0) {
                        this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + Math.random(), (double)this.field_145848_d + 1.2, (double)this.field_145849_e + Math.random(), 0.0, 0.0, 0.0);
                    }
                    if (this.timer >= 400) {
                        this.timer = 0;
                        if (this.fluid.amount < 1000) {
                            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e, (Block)Blocks.field_150480_ab);
                            return;
                        }
                        this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150353_l, 0, 3);
                        return;
                    }
                }
                if (!this.isFull() || this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) != FluidRegistry.WATER.getBlock()) break;
                this.setMode(BarrelMode.OBSIDIAN);
                break;
            }
            case COMPOST: {
                if (!(this.volume >= 1.0f)) break;
                ++this.timer;
                Color colorDirt = ColorRegistry.color("dirt");
                this.color = Color.average(this.colorBase, colorDirt, (float)this.timer / 1000.0f);
                if (this.timer < 1000) break;
                this.setMode(BarrelMode.DIRT);
                this.timer = 0;
                this.color = ColorRegistry.color("white");
                VanillaPacket.sendTileEntityUpdate(this);
                break;
            }
            case MILKED: {
                ++this.timer;
                Color colorSlime = ColorRegistry.color("water_slime_offset");
                this.color = Color.average(this.colorBase, colorSlime, (float)this.timer / 1000.0f);
                if (!this.isDone()) break;
                this.timer = 0;
                this.setMode(BarrelMode.SLIME);
                VanillaPacket.sendTileEntityUpdate(this);
                break;
            }
            case SLIME: {
                if (this.field_145850_b.field_73013_u == EnumDifficulty.PEACEFUL) break;
                ++this.timer;
                if (!this.isDone()) break;
                this.timer = 0;
                if (!this.field_145850_b.field_72995_K) {
                    EntitySlime slime = new EntitySlime(this.field_145850_b);
                    slime.func_70107_b((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e);
                    this.field_145850_b.func_72838_d((Entity)slime);
                }
                this.resetBarrel();
                break;
            }
            case SPORED: {
                int nearbyMycelium = this.getNearbyBlocks((Block)Blocks.field_150391_bh, 0);
                this.timer += 1 + nearbyMycelium / 2;
                Color colorWitchy = ColorRegistry.color("water_witchy_offset");
                this.color = Color.average(this.colorBase, colorWitchy, (float)this.timer / 1000.0f);
                if (!this.field_145850_b.field_72995_K && nearbyMycelium > 0) {
                    for (int x = -2; x <= 2; ++x) {
                        for (int y = -1; y <= 1; ++y) {
                            for (int z = -2; z <= 2; ++z) {
                                if (this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z) != Blocks.field_150391_bh || !this.field_145850_b.func_147437_c(this.field_145851_c + x, this.field_145848_d + y + 1, this.field_145849_e + z) || this.field_145850_b.field_73012_v.nextInt(1500) != 0) continue;
                                int choice = this.field_145850_b.field_73012_v.nextInt(2);
                                if (choice == 0) {
                                    this.field_145850_b.func_147465_d(this.field_145851_c + x, this.field_145848_d + y + 1, this.field_145849_e + z, (Block)Blocks.field_150338_P, 0, 3);
                                }
                                if (choice != 1) continue;
                                this.field_145850_b.func_147465_d(this.field_145851_c + x, this.field_145848_d + y + 1, this.field_145849_e + z, (Block)Blocks.field_150337_Q, 0, 3);
                            }
                        }
                    }
                }
                if (!this.isDone()) break;
                this.timer = 0;
                this.fluid = FluidRegistry.getFluidStack((String)"witchwater", (int)this.fluid.amount);
                this.setMode(BarrelMode.FLUID);
                VanillaPacket.sendTileEntityUpdate(this);
                break;
            }
            case BLAZE_COOKING: {
                ++this.timer;
                if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_149688_o().func_76217_h()) {
                    this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
                    this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 4.0f, true);
                }
                if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                    this.field_145850_b.func_72869_a("lava", (double)this.field_145851_c + (double)this.field_145850_b.field_73012_v.nextFloat() * 0.6 + 0.2, (double)(this.field_145848_d + 1), (double)this.field_145849_e + (double)this.field_145850_b.field_73012_v.nextFloat() * 0.6 + 0.2, 0.0, 0.0, 0.0);
                }
                if (this.timer >= 700 && this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
                    this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, (Block)Blocks.field_150480_ab);
                }
                if (!this.isDone()) break;
                this.setMode(BarrelMode.BLAZE);
                this.timer = 0;
                break;
            }
            case BLAZE: {
                if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextInt(5) == 0) {
                    this.field_145850_b.func_72869_a("lava", (double)this.field_145851_c + (double)this.field_145850_b.field_73012_v.nextFloat() * 0.6 + 0.2, (double)(this.field_145848_d + 1), (double)this.field_145849_e + (double)this.field_145850_b.field_73012_v.nextFloat() * 0.6 + 0.2, 0.0, 0.0, 0.0);
                }
                if (this.field_145850_b.field_72995_K || this.field_145850_b.field_73013_u == EnumDifficulty.PEACEFUL) break;
                if (this.isDone()) {
                    this.timer = 0;
                    this.resetBarrel();
                    break;
                }
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            if (!this.field_145850_b.func_147437_c(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z) && this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z) != Blocks.field_150480_ab || !this.field_145850_b.func_147437_c(this.field_145851_c + x, this.field_145848_d + y + 1, this.field_145849_e + z) && this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z) != Blocks.field_150480_ab || this.field_145850_b.field_73012_v.nextInt(10) != 0 || this.isDone()) continue;
                            this.timer = 1000;
                            EntityBlaze blaze = new EntityBlaze(this.field_145850_b);
                            blaze.func_70107_b((double)(this.field_145851_c + x) + 0.5, (double)(this.field_145848_d + y), (double)(this.field_145849_e + z) + 0.5);
                            this.field_145850_b.func_72838_d((Entity)blaze);
                        }
                    }
                }
                break;
            }
            case ENDER_COOKING: {
                ++this.timer;
                if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                    float f = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    float f1 = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    float f2 = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    this.field_145850_b.func_72869_a("portal", (double)this.field_145851_c + (double)this.field_145850_b.field_73012_v.nextFloat() * 0.6 + 0.2, (double)(this.field_145848_d + 1), (double)this.field_145849_e + (double)this.field_145850_b.field_73012_v.nextFloat() * 0.6 + 0.2, (double)f, (double)f1, (double)f2);
                }
                if (!this.isDone()) break;
                this.setMode(BarrelMode.ENDER);
                this.timer = 0;
                break;
            }
            case ENDER: {
                if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                    float f = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    float f1 = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    float f2 = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    this.field_145850_b.func_72869_a("portal", (double)this.field_145851_c + (double)this.field_145850_b.field_73012_v.nextFloat() * 0.6 + 0.2, (double)(this.field_145848_d + 1), (double)this.field_145849_e + (double)this.field_145850_b.field_73012_v.nextFloat() * 0.6 + 0.2, (double)f, (double)f1, (double)f2);
                }
                if (this.field_145850_b.field_72995_K || this.field_145850_b.field_73013_u.func_151525_a() <= 0) break;
                if (this.isDone()) {
                    this.timer = 0;
                    this.resetBarrel();
                    break;
                }
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            if (!this.field_145850_b.func_147437_c(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z) || !this.field_145850_b.func_147437_c(this.field_145851_c + x, this.field_145848_d + y + 1, this.field_145849_e + z) || !this.field_145850_b.func_147437_c(this.field_145851_c + x, this.field_145848_d + y + 2, this.field_145849_e + z) || this.field_145850_b.field_73012_v.nextInt(10) != 0 || this.isDone()) continue;
                            this.timer = 1000;
                            EntityEnderman enderman = new EntityEnderman(this.field_145850_b);
                            enderman.func_70107_b((double)(this.field_145851_c + x) + 0.5, (double)(this.field_145848_d + y), (double)(this.field_145849_e + z) + 0.5);
                            this.field_145850_b.func_72838_d((Entity)enderman);
                        }
                    }
                }
                break;
            }
            case MOB: {
                if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextInt(20) == 0 && this.entityParticleName != null) {
                    float f = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    float f1 = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    float f2 = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    this.field_145850_b.func_72869_a(this.entityParticleName, (double)this.field_145851_c + (double)this.field_145850_b.field_73012_v.nextFloat() * 0.6 + 0.2, (double)(this.field_145848_d + 1), (double)this.field_145849_e + (double)this.field_145850_b.field_73012_v.nextFloat() * 0.6 + 0.2, (double)f, (double)f1, (double)f2);
                }
                if (this.field_145850_b.field_72995_K) break;
                if (!this.isDone()) {
                    ++this.timer;
                    ENPacketHandler.sendToAllAround(new MessageBarrel(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.timer), this);
                    break;
                }
                if (this.field_145850_b.field_73013_u != EnumDifficulty.PEACEFUL) {
                    for (int x = -1; x <= 1; ++x) {
                        for (int y = -1; y <= 1; ++y) {
                            for (int z = -1; z <= 1; ++z) {
                                if (!this.field_145850_b.func_147437_c(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z) || !this.field_145850_b.func_147437_c(this.field_145851_c + x, this.field_145848_d + y + 1, this.field_145849_e + z) || !this.field_145850_b.func_147437_c(this.field_145851_c + x, this.field_145848_d + y + 2, this.field_145849_e + z) || this.field_145850_b.field_73012_v.nextInt(10) != 0) continue;
                                this.entity.func_70107_b((double)(this.field_145851_c + x) + 0.5, (double)(this.field_145848_d + y), (double)(this.field_145849_e + z) + 0.5);
                                if (!this.field_145850_b.func_72838_d((Entity)this.entity)) continue;
                                this.timer = 0;
                                ENPacketHandler.sendToAllAround(new MessageBarrel(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.timer), this);
                                this.resetBarrel();
                            }
                        }
                    }
                    break;
                }
                this.outputStack = this.peacefulDrop;
                this.setMode(BarrelMode.RECIPE);
                break;
            }
            case FLUIDTRANSFORM: {
                if (!this.field_145850_b.field_72995_K) {
                    if (this.isDone()) {
                        this.timer = 0;
                        ENPacketHandler.sendToAllAround(new MessageBarrel(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.timer), this);
                        this.fluid = new FluidStack(this.transformFluid, this.fluid.amount);
                        this.setMode(BarrelMode.FLUID);
                        VanillaPacket.sendTileEntityUpdate(this);
                        break;
                    }
                    int blocks = this.getNearbyBlocks(this.transformBlock, this.transformMeta);
                    this.timer += 1 + blocks / 2;
                    ENPacketHandler.sendToAllAround(new MessageBarrel(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.timer), this);
                    this.color = Color.average(new Color(this.fluid.getFluid().getColor()), new Color(this.transformFluid.getColor()), (float)this.timer / 1000.0f);
                    if (!this.fluid.getFluid().equals(FluidRegistry.WATER) || !this.transformFluid.equals(Fluids.fluidWitchWater)) break;
                    for (int x = -2; x <= 2; ++x) {
                        for (int y = -1; y <= 1; ++y) {
                            for (int z = -2; z <= 2; ++z) {
                                if (this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z) != Blocks.field_150391_bh || !this.field_145850_b.func_147437_c(this.field_145851_c + x, this.field_145848_d + y + 1, this.field_145849_e + z) || this.field_145850_b.field_73012_v.nextInt(1500) != 0) continue;
                                int choice = this.field_145850_b.field_73012_v.nextInt(2);
                                if (choice == 0) {
                                    this.field_145850_b.func_147465_d(this.field_145851_c + x, this.field_145848_d + y + 1, this.field_145849_e + z, (Block)Blocks.field_150338_P, 0, 3);
                                }
                                if (choice != 1) continue;
                                this.field_145850_b.func_147465_d(this.field_145851_c + x, this.field_145848_d + y + 1, this.field_145849_e + z, (Block)Blocks.field_150337_Q, 0, 3);
                            }
                        }
                    }
                    break;
                }
                this.color = Color.average(new Color(this.fluid.getFluid().getColor()), new Color(this.transformFluid.getColor()), (float)this.timer / 1000.0f);
            }
        }
    }

    public boolean addCompostItem(Compostable item) {
        if (this.getMode() == BarrelMode.EMPTY) {
            this.setMode(BarrelMode.COMPOST);
            this.timer = 0;
        }
        if (this.getMode() == BarrelMode.COMPOST && this.volume < 1.0f) {
            this.volume += item.value;
            if (this.volume > 1.0f) {
                this.volume = 1.0f;
            }
            float weightA = item.value / this.volume;
            float weightB = 1.0f - weightA;
            float r = weightA * item.color.r + weightB * this.color.r;
            float g = weightA * item.color.g + weightB * this.color.g;
            float b = weightA * item.color.b + weightB * this.color.b;
            float a = weightA * item.color.a + weightB * this.color.a;
            this.color = new Color(r, g, b, a);
            if (this.volume == 1.0f) {
                this.colorBase = this.color;
            }
            VanillaPacket.sendTileEntityUpdate(this);
            return true;
        }
        return false;
    }

    public boolean isFull() {
        return this.volume >= 1.0f;
    }

    public boolean isDone() {
        return this.timer >= 1000;
    }

    public void resetColor() {
        this.colorBase = ColorRegistry.color("white");
        this.color = ColorRegistry.color("white");
    }

    public void giveAppropriateItem() {
        this.giveItem(this.getExtractItem());
    }

    private void giveItem(ItemStack item) {
        if (!this.field_145850_b.field_72995_K && item != null) {
            EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, item);
            double f3 = 0.05f;
            entityitem.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = 0.2;
            entityitem.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * f3;
            this.field_145850_b.func_72838_d((Entity)entityitem);
            this.timer = 0;
        }
        this.resetBarrel();
    }

    private ItemStack getExtractItem() {
        switch (this.getMode()) {
            case CLAY: {
                return new ItemStack(Blocks.field_150435_aG, 1, 0);
            }
            case DIRT: {
                return new ItemStack(Blocks.field_150346_d, 1, 0);
            }
            case ENDSTONE: {
                return new ItemStack(Blocks.field_150377_bs, 1, 0);
            }
            case NETHERRACK: {
                return new ItemStack(Blocks.field_150424_aL, 1, 0);
            }
            case SLIME: {
                return new ItemStack(Items.field_151123_aH, 1 + this.field_145850_b.field_73012_v.nextInt(4));
            }
            case SOULSAND: {
                return new ItemStack(Blocks.field_150425_aM, 1, 0);
            }
            case OBSIDIAN: {
                return new ItemStack(Blocks.field_150343_Z, 1, 0);
            }
            case COBBLESTONE: {
                return new ItemStack(Blocks.field_150347_e, 1, 0);
            }
            case BLAZE: {
                return new ItemStack(Items.field_151072_bj, 1, 0);
            }
            case ENDER: {
                return new ItemStack(Items.field_151079_bi, 1, 0);
            }
            case BEETRAP: {
                return new ItemStack(ENBlocks.BeeTrapTreated, 1, 0);
            }
            case DARKOAK: {
                return new ItemStack(Blocks.field_150345_g, 1, 5);
            }
            case BLOCK: {
                return new ItemStack(this.block);
            }
            case RECIPE: {
                return this.outputStack;
            }
            case MOB: {
                if (this.field_145850_b.field_73013_u == EnumDifficulty.PEACEFUL) {
                    return this.peacefulDrop;
                }
                return null;
            }
        }
        return null;
    }

    public float getVolume() {
        return this.volume;
    }

    public int getTimer() {
        return this.timer;
    }

    public float getAdjustedVolume() {
        float capacity = 0.79999995f;
        float adjusted = this.volume * capacity;
        return adjusted += 0.1f;
    }

    private void resetBarrel() {
        this.fluid = new FluidStack(FluidRegistry.WATER, 0);
        this.volume = 0.0f;
        this.color = ColorRegistry.color("white");
        this.colorBase = ColorRegistry.color("white");
        this.setMode(BarrelMode.EMPTY);
        this.needsUpdate = true;
        this.outputStack = null;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        switch (compound.func_74762_e("mode")) {
            case 0: {
                this.setMode(BarrelMode.EMPTY);
                break;
            }
            case 1: {
                this.setMode(BarrelMode.FLUID);
                break;
            }
            case 2: {
                this.setMode(BarrelMode.COMPOST);
                break;
            }
            case 3: {
                this.setMode(BarrelMode.DIRT);
                break;
            }
            case 4: {
                this.setMode(BarrelMode.CLAY);
                break;
            }
            case 5: {
                this.setMode(BarrelMode.SPORED);
                break;
            }
            case 6: {
                this.setMode(BarrelMode.SLIME);
                break;
            }
            case 7: {
                this.setMode(BarrelMode.NETHERRACK);
                break;
            }
            case 8: {
                this.setMode(BarrelMode.ENDSTONE);
                break;
            }
            case 9: {
                this.setMode(BarrelMode.MILKED);
                break;
            }
            case 10: {
                this.setMode(BarrelMode.SOULSAND);
                break;
            }
            case 11: {
                this.setMode(BarrelMode.BEETRAP);
                break;
            }
            case 12: {
                this.setMode(BarrelMode.OBSIDIAN);
                break;
            }
            case 13: {
                this.setMode(BarrelMode.COBBLESTONE);
                break;
            }
            case 14: {
                this.setMode(BarrelMode.BLAZE_COOKING);
                break;
            }
            case 15: {
                this.setMode(BarrelMode.BLAZE);
                break;
            }
            case 16: {
                this.setMode(BarrelMode.ENDER_COOKING);
                break;
            }
            case 17: {
                this.setMode(BarrelMode.ENDER);
                break;
            }
            case 18: {
                this.setMode(BarrelMode.DARKOAK);
                break;
            }
            case 19: {
                this.setMode(BarrelMode.BLOCK);
                break;
            }
            case 20: {
                this.setMode(BarrelMode.RECIPE);
                break;
            }
            case 21: {
                this.setMode(BarrelMode.MOB);
                break;
            }
            case 22: {
                this.setMode(BarrelMode.FLUIDTRANSFORM);
            }
        }
        this.volume = compound.func_74760_g("volume");
        this.timer = compound.func_74762_e("timer");
        this.color = new Color(compound.func_74762_e("color"));
        this.colorBase = new Color(compound.func_74762_e("colorBase"));
        this.fluid = new FluidStack(FluidRegistry.getFluid((int)compound.func_74765_d("fluid")), (int)(this.volume * 1000.0f));
        this.needsUpdate = true;
        this.block = !compound.func_74779_i("block").equals("") ? (Block)Block.field_149771_c.func_82594_a(compound.func_74779_i("block")) : null;
        this.blockMeta = compound.func_74762_e("blockMeta");
        if (compound.func_74764_b("outputStack")) {
            this.outputStack = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)compound.func_74781_a("outputStack")));
        }
        if (compound.func_74764_b("entity")) {
            this.entity = (EntityLivingBase)EntityList.func_75615_a((NBTTagCompound)((NBTTagCompound)compound.func_74781_a("entity")), (World)this.field_145850_b);
            this.entityParticleName = compound.func_74779_i("entityParticleName");
            if (compound.func_74764_b("peacefulDrop")) {
                this.peacefulDrop = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)compound.func_74781_a("peacefulDrop")));
            }
        }
        if (compound.func_74764_b("transform")) {
            NBTTagCompound tag = compound.func_74775_l("transform");
            this.transformFluid = FluidRegistry.getFluid((int)tag.func_74765_d("transformFluid"));
            this.transformMeta = tag.func_74765_d("transformFluidMeta");
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        NBTTagCompound tag;
        super.func_145841_b(compound);
        compound.func_74768_a("mode", this.getMode().value);
        compound.func_74776_a("volume", this.volume);
        compound.func_74768_a("timer", this.timer);
        compound.func_74768_a("color", this.color.toInt());
        compound.func_74768_a("colorBase", this.colorBase.toInt());
        compound.func_74777_a("fluid", (short)this.fluid.getFluidID());
        if (this.block == null) {
            compound.func_74778_a("block", "");
        } else {
            compound.func_74778_a("block", Block.field_149771_c.func_148750_c((Object)this.block));
        }
        compound.func_74768_a("blockMeta", this.blockMeta);
        if (this.outputStack != null) {
            tag = new NBTTagCompound();
            tag = this.outputStack.func_77955_b(tag);
            compound.func_74782_a("outputStack", (NBTBase)tag);
        }
        if (this.entity != null) {
            tag = new NBTTagCompound();
            this.entity.func_70109_d(tag);
            compound.func_74782_a("entity", (NBTBase)tag);
            compound.func_74778_a("entityParticleName", this.entityParticleName);
            if (this.peacefulDrop != null) {
                tag = new NBTTagCompound();
                tag = this.peacefulDrop.func_77955_b(tag);
                compound.func_74782_a("peacefulDrop", (NBTBase)tag);
            }
        }
        if (this.transformFluid != null) {
            tag = new NBTTagCompound();
            tag.func_74777_a("transformFluid", (short)this.transformFluid.getID());
            tag.func_74777_a("transformFluidMeta", (short)this.transformMeta);
            compound.func_74782_a("transform", (NBTBase)tag);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int capacity = 1000 - this.fluid.amount;
        if (!doFill) {
            if (this.getMode() == BarrelMode.EMPTY) {
                return resource.amount > 1000 ? 1000 : resource.amount;
            }
            if (this.getMode() == BarrelMode.FLUID && resource.getFluidID() == this.fluid.getFluidID()) {
                if (capacity >= resource.amount) {
                    return resource.amount;
                }
                return capacity;
            }
        } else {
            if (this.getMode() == BarrelMode.EMPTY) {
                if (resource.getFluidID() != this.fluid.getFluidID()) {
                    int amount = resource.amount;
                    if (resource.amount > 1000) {
                        resource.amount = 1000;
                    }
                    this.fluid = new FluidStack(FluidRegistry.getFluid((int)resource.getFluidID()), amount);
                } else {
                    int amount;
                    this.fluid.amount = amount = resource.amount > 1000 ? 1000 : resource.amount;
                }
                this.setMode(BarrelMode.FLUID);
                this.volume = (float)this.fluid.amount / 1000.0f;
                VanillaPacket.sendTileEntityUpdate(this);
                return resource.amount;
            }
            if (this.getMode() == BarrelMode.FLUID && resource.getFluidID() == this.fluid.getFluidID()) {
                if (capacity >= resource.amount) {
                    this.fluid.amount += resource.amount;
                    this.volume = (float)this.fluid.amount / 1000.0f;
                    this.needsUpdate = true;
                    return resource.amount;
                }
                this.fluid.amount = 1000;
                this.volume = 1.0f;
                VanillaPacket.sendTileEntityUpdate(this);
                return capacity;
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || this.getMode() != BarrelMode.FLUID || !resource.isFluidEqual(this.fluid)) {
            return null;
        }
        if (!doDrain) {
            if (this.fluid.amount >= resource.amount) {
                FluidStack simulated = new FluidStack(FluidRegistry.getFluid((int)resource.getFluidID()), resource.amount);
                return simulated;
            }
            FluidStack simulated = new FluidStack(FluidRegistry.getFluid((int)resource.getFluidID()), this.fluid.amount);
            return simulated;
        }
        if (this.fluid.amount > resource.amount) {
            FluidStack drained = new FluidStack(FluidRegistry.getFluid((int)resource.getFluidID()), resource.amount);
            this.fluid.amount -= resource.amount;
            this.volume = (float)this.fluid.amount / 1000.0f;
            this.needsUpdate = true;
            return drained;
        }
        FluidStack drained = new FluidStack(FluidRegistry.getFluid((int)resource.getFluidID()), this.fluid.amount);
        this.fluid.amount = 0;
        this.volume = 0.0f;
        this.setMode(BarrelMode.EMPTY);
        this.timer = 0;
        this.needsUpdate = true;
        return drained;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.getMode() != BarrelMode.FLUID) {
            return null;
        }
        if (!doDrain) {
            if (this.fluid.amount >= maxDrain) {
                FluidStack simulated = new FluidStack(FluidRegistry.getFluid((int)this.fluid.getFluidID()), maxDrain);
                return simulated;
            }
            FluidStack simulated = new FluidStack(FluidRegistry.getFluid((int)this.fluid.getFluidID()), this.fluid.amount);
            return simulated;
        }
        if (this.fluid.amount > maxDrain) {
            FluidStack drained = new FluidStack(FluidRegistry.getFluid((int)this.fluid.getFluidID()), maxDrain);
            this.fluid.amount -= maxDrain;
            this.volume = (float)this.fluid.amount / 1000.0f;
            this.needsUpdate = true;
            return drained;
        }
        FluidStack drained = new FluidStack(FluidRegistry.getFluid((int)this.fluid.getFluidID()), this.fluid.amount);
        this.fluid.amount = 0;
        this.volume = 0.0f;
        this.setMode(BarrelMode.EMPTY);
        this.timer = 0;
        this.needsUpdate = true;
        return drained;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo info = new FluidTankInfo(this.fluid, 1000);
        FluidTankInfo[] array = new FluidTankInfo[]{info};
        return array;
    }

    public int getNearbyBlocks(Block block, int blockMeta) {
        int count = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z) != block || this.field_145850_b.func_72805_g(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z) != blockMeta) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public HashSet<ItemInfo> getNearbyBlocks() {
        HashSet<ItemInfo> out = new HashSet<ItemInfo>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    out.add(new ItemInfo(this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z), this.field_145850_b.func_72805_g(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z)));
                }
            }
        }
        return out;
    }

    public int getLightLevel() {
        if (this.getMode() == BarrelMode.FLUID) {
            return this.fluid.getFluid().getLuminosity();
        }
        if (this.getMode() == BarrelMode.BLAZE || this.getMode() == BarrelMode.BLAZE_COOKING) {
            return 15;
        }
        return 0;
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot == 0) {
            return this.getExtractItem();
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (slot == 0) {
            ItemStack item = this.getExtractItem();
            this.resetBarrel();
            return item;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            if (slot == 0) {
                this.resetBarrel();
            }
        } else {
            Item item = stack.func_77973_b();
            int meta = stack.func_77960_j();
            if (slot == 1) {
                if ((this.getMode() == BarrelMode.COMPOST || this.getMode() == BarrelMode.EMPTY) && CompostRegistry.containsItem(item, meta)) {
                    this.addCompostItem(CompostRegistry.getItem(item, meta));
                }
                if (this.getMode() == BarrelMode.FLUID && this.isFull()) {
                    ItemInfo output = BarrelRecipeRegistry.getOutput(this.fluid, stack);
                    if (output != null) {
                        this.outputStack = new ItemStack(output.getItem(), 1, output.getMeta());
                        this.setMode(BarrelMode.RECIPE);
                        VanillaPacket.sendTileEntityUpdate(this);
                        return;
                    }
                    EntityWithItem mob = BarrelRecipeRegistry.getMobOutput(this.fluid, stack);
                    if (mob != null) {
                        try {
                            Constructor constructor = mob.getEntity().getConstructor(World.class);
                            this.entity = (EntityLivingBase)constructor.newInstance(this.field_145850_b);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.entityParticleName = mob.getParticle();
                        this.peacefulDrop = mob.getDrops();
                        this.setMode(BarrelMode.MOB);
                        return;
                    }
                }
            }
        }
        VanillaPacket.sendTileEntityUpdate(this);
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        if (slot == 1) {
            return this.isItemValid(item);
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        if (side == 0) {
            return new int[]{0};
        }
        if (side == 1) {
            return new int[]{1};
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        if (side == 1 && slot == 1) {
            return this.isItemValid(item);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        if (side == 0 && slot == 0) {
            if (this.getMode().canExtract == ExtractMode.Always) {
                return true;
            }
            if (this.field_145850_b.field_73013_u.func_151525_a() == 0 && this.getMode().canExtract == ExtractMode.PeacefulOnly) {
                return true;
            }
        }
        return false;
    }

    public boolean isItemValid(ItemStack stack) {
        Item item = stack.func_77973_b();
        int meta = stack.func_77960_j();
        if ((!this.isFull() && this.getMode() == BarrelMode.COMPOST || this.getMode() == BarrelMode.EMPTY) && ModData.ALLOW_BARREL_RECIPE_DIRT && CompostRegistry.containsItem(item, meta)) {
            return true;
        }
        ItemInfo output = BarrelRecipeRegistry.getOutput(this.fluid, stack);
        if (this.isFull() && this.outputStack == null && output != null && !stack.func_77973_b().hasContainerItem(new ItemStack(output.getItem(), 1, output.getMeta()))) {
            return true;
        }
        EntityWithItem entity = BarrelRecipeRegistry.getMobOutput(this.fluid, stack);
        if (this.isFull() && entity != null && !stack.func_77973_b().hasContainerItem(stack) && this.outputStack == null && !this.isCookingMob()) {
            return true;
        }
        if (this.getMode() == BarrelMode.FLUID && this.isFull()) {
            if (this.fluid.getFluidID() == FluidRegistry.LAVA.getID() && ModData.ALLOW_BARREL_RECIPE_BLAZE_RODS && item == ENItems.DollAngry) {
                return true;
            }
            if (this.fluid.getFluidID() == Fluids.fluidWitchWater.getID() && ModData.ALLOW_BARREL_RECIPE_ENDER_PEARLS && item == ENItems.DollCreepy) {
                return true;
            }
        }
        return false;
    }

    public boolean isCookingMob() {
        return this.mode == BarrelMode.MOB;
    }

    public void setTimer(int timer) {
        this.timer = timer;
    }

    public static enum ExtractMode {
        None,
        Always,
        PeacefulOnly;

    }

    public static enum BarrelMode {
        EMPTY(0, ExtractMode.None),
        FLUID(1, ExtractMode.None),
        COMPOST(2, ExtractMode.None),
        DIRT(3, ExtractMode.Always),
        CLAY(4, ExtractMode.Always),
        SPORED(5, ExtractMode.None),
        SLIME(6, ExtractMode.Always),
        NETHERRACK(7, ExtractMode.Always),
        ENDSTONE(8, ExtractMode.Always),
        MILKED(9, ExtractMode.None),
        SOULSAND(10, ExtractMode.Always),
        BEETRAP(11, ExtractMode.Always),
        OBSIDIAN(12, ExtractMode.Always),
        COBBLESTONE(13, ExtractMode.Always),
        BLAZE_COOKING(14, ExtractMode.None),
        BLAZE(15, ExtractMode.PeacefulOnly),
        ENDER_COOKING(16, ExtractMode.None),
        ENDER(17, ExtractMode.PeacefulOnly),
        DARKOAK(18, ExtractMode.Always),
        BLOCK(19, ExtractMode.Always),
        RECIPE(20, ExtractMode.Always),
        MOB(21, ExtractMode.None),
        FLUIDTRANSFORM(22, ExtractMode.None);

        public int value;
        public ExtractMode canExtract;

        private BarrelMode(int v, ExtractMode extract) {
            this.value = v;
            this.canExtract = extract;
        }
    }
}

