/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.compatibility;

import exnihilo.ExNihilo;
import exnihilo.compatibility.OreList;
import net.minecraft.block.Block;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.library.crafting.Smeltery;

public class TinkersConstruct {
    private static final int INGOT_AMOUNT = 144;

    public static void loadCompatibility() {
        ExNihilo.log.info("--- Tinkers Construct Integration Complete!");
    }

    public static void TryRegisterOre(String name, Block block) {
        name = name.replace("ender_", "");
        if ((name = name.replace("nether_", "")).toLowerCase().equals("iron")) {
            TinkersConstruct.RegisterOre(OreList.Type.Iron, block);
        }
        if (name.toLowerCase().equals("gold")) {
            TinkersConstruct.RegisterOre(OreList.Type.Gold, block);
        }
        if (name.toLowerCase().equals("copper")) {
            TinkersConstruct.RegisterOre(OreList.Type.Copper, block);
        }
        if (name.toLowerCase().equals("tin")) {
            TinkersConstruct.RegisterOre(OreList.Type.Tin, block);
        }
        if (name.toLowerCase().equals("nickel")) {
            TinkersConstruct.RegisterOre(OreList.Type.Nickel, block);
        }
        if (name.toLowerCase().equals("platinum")) {
            TinkersConstruct.RegisterOre(OreList.Type.Platinum, block);
        }
        if (name.toLowerCase().equals("silver")) {
            TinkersConstruct.RegisterOre(OreList.Type.Silver, block);
        }
        if (name.toLowerCase().equals("lead")) {
            TinkersConstruct.RegisterOre(OreList.Type.Lead, block);
        }
        if (name.toLowerCase().equals("aluminum") || name.toLowerCase().equals("aluminium")) {
            TinkersConstruct.RegisterOre(OreList.Type.Aluminum, block);
        }
    }

    public static void RegisterOre(OreList.Type ore, Block block) {
        int meltingPoint = TinkersConstruct.getMeltingPoint(ore);
        FluidStack moltenMetal = TinkersConstruct.getMoltenMetal(ore);
        if (block != null && meltingPoint != 0 && moltenMetal != null) {
            Smeltery.addMelting((Block)block, (int)0, (int)meltingPoint, (FluidStack)moltenMetal);
        }
    }

    private static int getMeltingPoint(OreList.Type ore) {
        switch (ore) {
            case Iron: {
                return 600;
            }
            case Gold: {
                return 400;
            }
            case Tin: {
                return 400;
            }
            case Copper: {
                return 550;
            }
            case Silver: {
                return 400;
            }
            case Lead: {
                return 400;
            }
            case Nickel: {
                return 400;
            }
            case Platinum: {
                return 400;
            }
            case Aluminum: {
                return 400;
            }
        }
        return 0;
    }

    private static FluidStack getMoltenMetal(OreList.Type ore) {
        Fluid metal = TinkersConstruct.findMoltenMetal(ore);
        if (metal != null) {
            return new FluidStack(metal, 288);
        }
        return null;
    }

    private static Fluid findMoltenMetal(OreList.Type ore) {
        switch (ore) {
            case Iron: {
                return FluidRegistry.getFluid((String)"iron.molten");
            }
            case Gold: {
                return FluidRegistry.getFluid((String)"gold.molten");
            }
            case Tin: {
                return FluidRegistry.getFluid((String)"tin.molten");
            }
            case Copper: {
                return FluidRegistry.getFluid((String)"copper.molten");
            }
            case Silver: {
                return FluidRegistry.getFluid((String)"silver.molten");
            }
            case Lead: {
                return FluidRegistry.getFluid((String)"lead.molten");
            }
            case Nickel: {
                return FluidRegistry.getFluid((String)"nickel.molten");
            }
            case Platinum: {
                return FluidRegistry.getFluid((String)"platinum.molten");
            }
            case Aluminum: {
                return FluidRegistry.getFluid((String)"aluminum.molten");
            }
        }
        return null;
    }
}

