/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.events;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import exnihilo.items.hammers.IHammer;
import exnihilo.registries.HammerRegistry;
import exnihilo.registries.helpers.Smashable;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraftforge.event.world.BlockEvent;

public class HandlerHammer {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void hammer(BlockEvent.HarvestDropsEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (event.harvester == null) {
            return;
        }
        if (event.isSilkTouching) {
            return;
        }
        Block block = event.block;
        int meta = event.blockMetadata;
        ArrayList<Smashable> rewards = HammerRegistry.getRewards(block, meta);
        ItemStack held = event.harvester.func_70694_bm();
        if (this.isHammer(held) && this.canHarvest(block, meta, held) && rewards != null && rewards.size() > 0) {
            event.drops.clear();
            event.dropChance = 1.0f;
            int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)event.harvester);
            for (Smashable reward : rewards) {
                if (!(event.world.field_73012_v.nextFloat() <= reward.chance + reward.luckMultiplier * (float)fortune)) continue;
                event.drops.add(new ItemStack(reward.item, 1, reward.meta));
            }
        }
    }

    public boolean isHammer(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof IHammer) {
            return ((IHammer)stack.func_77973_b()).isHammer(stack);
        }
        return stack.func_77942_o() && stack.field_77990_d.func_74767_n("Hammered");
    }

    public boolean canHarvest(Block block, int meta, ItemStack stack) {
        int harvestLevel = 0;
        if (stack.func_77973_b() instanceof ItemTool) {
            harvestLevel = ((ItemTool)stack.func_77973_b()).func_150913_i().func_77996_d();
        }
        return block.getHarvestLevel(meta) <= harvestLevel;
    }
}

