/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.registries;

import exnihilo.registries.helpers.Meltable;
import java.util.Hashtable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class CrucibleRegistry {
    public static Hashtable<String, Meltable> entries = new Hashtable();

    public static void register(Block block, int meta, float solidAmount, Fluid fluid, float fluidAmount, Block appearance, int appearanceMeta) {
        Meltable entry = new Meltable(block, meta, solidAmount, fluid, fluidAmount, appearance, appearanceMeta);
        entries.put(block + ":" + meta, entry);
    }

    public static void register(Block block, int meta, float solidAmount, Fluid fluid, float fluidAmount) {
        CrucibleRegistry.register(block, meta, solidAmount, fluid, fluidAmount, block, meta);
    }

    public static void register(Block block, int meta, float solidAmount, Fluid fluid, float fluidAmount, Block appearance) {
        Meltable entry = new Meltable(block, meta, solidAmount, fluid, fluidAmount, appearance, 0);
        entries.put(block + ":" + meta, entry);
    }

    public static void register(Block block, float solidAmount, Fluid fluid, float fluidAmount) {
        for (int i = 0; i < 16; ++i) {
            CrucibleRegistry.register(block, i, solidAmount, fluid, fluidAmount);
        }
    }

    public static boolean containsItem(Block block, int meta) {
        return entries.containsKey(block + ":" + meta);
    }

    public static Meltable getItem(Block block, int meta) {
        return entries.get(block + ":" + meta);
    }

    public static void load(Configuration config) {
    }

    public static boolean changeFluidFromBlock(Block block, int meta, Fluid newFluid, float newVolume) {
        if (CrucibleRegistry.containsItem(block, meta)) {
            Meltable melt = CrucibleRegistry.getItem(block, meta);
            melt.fluid = newFluid;
            melt.fluidVolume = newVolume;
            return true;
        }
        return false;
    }

    public static void registerMeltables() {
        CrucibleRegistry.register(Blocks.field_150347_e, 0, 2000.0f, FluidRegistry.LAVA, 250.0f);
        CrucibleRegistry.register(Blocks.field_150348_b, 0, 2000.0f, FluidRegistry.LAVA, 250.0f);
        CrucibleRegistry.register(Blocks.field_150351_n, 0, 2000.0f, FluidRegistry.LAVA, 250.0f);
        CrucibleRegistry.register(Blocks.field_150424_aL, 0, 2000.0f, FluidRegistry.LAVA, 1000.0f);
        CrucibleRegistry.register(Blocks.field_150433_aE, 0, 2000.0f, FluidRegistry.WATER, 500.0f);
        CrucibleRegistry.register(Blocks.field_150432_aD, 0, 2000.0f, FluidRegistry.WATER, 1000.0f);
    }
}

