/*
 * Decompiled with CFR 0.152.
 */
package extracells.inventory;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkStorageEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IExternalStorageHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import extracells.part.PartFluidStorage;
import extracells.util.FluidUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class HandlerPartStorageFluid
implements IMEInventoryHandler<IAEFluidStack>,
IMEMonitorHandlerReceiver<IAEFluidStack> {
    protected PartFluidStorage node;
    protected IFluidHandler tank;
    protected AccessRestriction access = AccessRestriction.READ_WRITE;
    protected List<Fluid> prioritizedFluids = new ArrayList<Fluid>();
    protected boolean inverted;
    private IExternalStorageHandler externalHandler = null;
    protected TileEntity tile = null;
    public ITileStorageMonitorable externalSystem;

    public HandlerPartStorageFluid(PartFluidStorage partFluidStorage) {
         $ .node = partFluidStorage;
    }

    public boolean canAccept(IAEFluidStack iAEFluidStack) {
        if (! .node.isActive()) {
            return false;
        }
        if ( .tank == null &&  .externalSystem == null &&  .externalHandler == null ||  .access != AccessRestriction.WRITE &&  .access != AccessRestriction.READ_WRITE || iAEFluidStack == null) {
            return false;
        }
        if ( .externalSystem != null) {
            IStorageMonitorable iStorageMonitorable =  .externalSystem.getMonitorable( .node.getSide().getOpposite(), (BaseActionSource)new MachineSource((IActionHost) .node));
            if (iStorageMonitorable == null) {
                return false;
            }
            IMEMonitor  2 = iStorageMonitorable.getFluidInventory();
            return  2 != null &&  2.canAccept((IAEStack)iAEFluidStack);
        }
        if ( .externalHandler != null) {
            IMEInventory  3 =  .externalHandler.getInventory( .tile,  .node.getSide().getOpposite(), StorageChannel.FLUIDS, (BaseActionSource)new MachineSource((IActionHost) .node));
            return  3 != null;
        }
        FluidTankInfo[] fluidTankInfoArray =  .tank.getTankInfo( .node.getSide().getOpposite());
        if (fluidTankInfoArray != null && fluidTankInfoArray.length > 0) {
            FluidTankInfo fluidTankInfo = fluidTankInfoArray[0];
            if (fluidTankInfo.fluid == null || fluidTankInfo.fluid.amount == 0 || fluidTankInfo.fluid.getFluidID() == iAEFluidStack.getFluidStack().getFluidID()) {
                if ( .inverted) {
                    return ! .prioritizedFluids.isEmpty() || ! .isPrioritized(iAEFluidStack);
                }
                return  .prioritizedFluids.isEmpty() ||  .isPrioritized(iAEFluidStack);
            }
        }
        return false;
    }

    public IAEFluidStack extractItems(IAEFluidStack iAEFluidStack, Actionable actionable, BaseActionSource baseActionSource) {
        if (! .node.isActive() ||  .access != AccessRestriction.READ &&  .access != AccessRestriction.READ_WRITE) {
            return null;
        }
        if ( .externalSystem != null && iAEFluidStack != null) {
            IStorageMonitorable iStorageMonitorable =  .externalSystem.getMonitorable( .node.getSide().getOpposite(), baseActionSource);
            if (iStorageMonitorable == null) {
                return null;
            }
            IMEMonitor  2 = iStorageMonitorable.getFluidInventory();
            if ( 2 == null) {
                return null;
            }
            return (IAEFluidStack) 2.extractItems((IAEStack)iAEFluidStack, actionable, baseActionSource);
        }
        if ( .externalHandler != null && iAEFluidStack != null) {
            IMEInventory  3 =  .externalHandler.getInventory( .tile,  .node.getSide().getOpposite(), StorageChannel.FLUIDS, (BaseActionSource)new MachineSource((IActionHost) .node));
            if ( 3 == null) {
                return null;
            }
            return (IAEFluidStack) 3.extractItems((IAEStack)iAEFluidStack, actionable, (BaseActionSource)new MachineSource((IActionHost) .node));
        }
        if ( .tank == null || iAEFluidStack == null ||  .access == AccessRestriction.WRITE ||  .access == AccessRestriction.NO_ACCESS) {
            return null;
        }
        FluidStack fluidStack = iAEFluidStack.getFluidStack();
        int  4 = 0;
        int  5 = 0;
        while (fluidStack.amount != ( 4 += ( 5 = ( 6 =  .tank.drain( .node.getSide().getOpposite(), new FluidStack(fluidStack.getFluid(), fluidStack.amount -  4), actionable == Actionable.MODULATE)) == null ? 0 :  6.amount)) &&  5 != 0) {
        }
        if ( 4 == 0) {
            return null;
        }
        IItemList<IAEFluidStack>  6 =  .getAvailableItems((IItemList<IAEFluidStack>)AEApi.instance().storage().createFluidList());
        for (IAEFluidStack iAEFluidStack2 :  6) {
            if (iAEFluidStack2.getFluid() != iAEFluidStack.getFluid()) continue;
             4 = (int)Math.min((long) 4, iAEFluidStack2.getStackSize());
        }
        if ( 4 == fluidStack.amount) {
            return iAEFluidStack;
        }
        return FluidUtil.createAEFluidStack(fluidStack.getFluidID(), (long) 4);
    }

    public AccessRestriction getAccess() {
        HandlerPartStorageFluid handlerPartStorageFluid;
        return handlerPartStorageFluid.access;
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> iItemList2) {
        IItemList<IAEFluidStack> iItemList2;
        block8: {
            HandlerPartStorageFluid handlerPartStorageFluid;
            block9: {
                block7: {
                    if (!handlerPartStorageFluid.node.isActive() || handlerPartStorageFluid.access != AccessRestriction.READ && handlerPartStorageFluid.access != AccessRestriction.READ_WRITE) {
                        return iItemList2;
                    }
                    if (handlerPartStorageFluid.externalSystem == null) break block7;
                    IStorageMonitorable iStorageMonitorable = handlerPartStorageFluid.externalSystem.getMonitorable(handlerPartStorageFluid.node.getSide().getOpposite(), (BaseActionSource)new MachineSource((IActionHost)handlerPartStorageFluid.node));
                    if (iStorageMonitorable == null) {
                        return iItemList2;
                    }
                    IMEMonitor  2 = iStorageMonitorable.getFluidInventory();
                    if ( 2 == null) {
                        return iItemList2;
                    }
                    IItemList  3 = handlerPartStorageFluid.externalSystem.getMonitorable(handlerPartStorageFluid.node.getSide().getOpposite(), (BaseActionSource)new MachineSource((IActionHost)handlerPartStorageFluid.node)).getFluidInventory().getStorageList();
                    for (IAEFluidStack iAEFluidStack :  3) {
                        iItemList2.add((IAEStack)iAEFluidStack);
                    }
                    break block8;
                }
                if (handlerPartStorageFluid.externalHandler == null) break block9;
                IMEInventory  4 = handlerPartStorageFluid.externalHandler.getInventory(handlerPartStorageFluid.tile, handlerPartStorageFluid.node.getSide().getOpposite(), StorageChannel.FLUIDS, (BaseActionSource)new MachineSource((IActionHost)handlerPartStorageFluid.node));
                if ( 4 == null) {
                    return iItemList2;
                }
                IItemList  5 =  4.getAvailableItems(AEApi.instance().storage().createFluidList());
                for (IAEFluidStack iAEFluidStack :  5) {
                    iItemList2.add((IAEStack)iAEFluidStack);
                }
                break block8;
            }
            if (handlerPartStorageFluid.tank == null || (  = handlerPartStorageFluid.tank.getTankInfo(handlerPartStorageFluid.node.getSide().getOpposite())) == null ||  .length <= 0) break block8;
            for (FluidTankInfo fluidTankInfo :  ) {
                if (fluidTankInfo.fluid == null) continue;
                iItemList2.add((IAEStack)AEApi.instance().storage().createFluidStack(fluidTankInfo.fluid));
            }
        }
        return iItemList2;
    }

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    public int getPriority() {
        HandlerPartStorageFluid handlerPartStorageFluid;
        return handlerPartStorageFluid.node.getPriority();
    }

    public int getSlot() {
        return 0;
    }

    public IAEFluidStack injectItems(IAEFluidStack iAEFluidStack, Actionable actionable, BaseActionSource baseActionSource) {
        if ( .access != AccessRestriction.WRITE &&  .access != AccessRestriction.READ_WRITE) {
            return null;
        }
        if ( .externalSystem != null && iAEFluidStack != null) {
            IStorageMonitorable iStorageMonitorable =  .externalSystem.getMonitorable( .node.getSide().getOpposite(), baseActionSource);
            if (iStorageMonitorable == null) {
                return iAEFluidStack;
            }
            IMEMonitor  2 = iStorageMonitorable.getFluidInventory();
            if ( 2 == null) {
                return iAEFluidStack;
            }
            return (IAEFluidStack) 2.injectItems((IAEStack)iAEFluidStack, actionable, baseActionSource);
        }
        if ( .externalHandler != null && iAEFluidStack != null) {
            IMEInventory  3 =  .externalHandler.getInventory( .tile,  .node.getSide().getOpposite(), StorageChannel.FLUIDS, (BaseActionSource)new MachineSource((IActionHost) .node));
            if ( 3 == null) {
                return iAEFluidStack;
            }
            return (IAEFluidStack) 3.injectItems((IAEStack)iAEFluidStack, actionable, (BaseActionSource)new MachineSource((IActionHost) .node));
        }
        if ( .tank == null || iAEFluidStack == null || ! .canAccept(iAEFluidStack)) {
            return iAEFluidStack;
        }
        FluidStack fluidStack = iAEFluidStack.getFluidStack();
        int  4 = 0;
        int  5 = 0;
        while (( 5 =  .tank.fill( .node.getSide().getOpposite(), new FluidStack(fluidStack.getFluid(), fluidStack.amount -  4), actionable == Actionable.MODULATE)) != 0 && ( 4 +=  5) != fluidStack.amount) {
        }
        FluidTankInfo[]  6 =  .tank.getTankInfo( .node.getSide().getOpposite());
        int  7 = 0;
        for (FluidTankInfo fluidTankInfo :  6) {
            if (fluidTankInfo.fluid == null) {
                 7 += fluidTankInfo.capacity;
                continue;
            }
            if (fluidTankInfo.fluid.getFluid() != fluidStack.getFluid()) continue;
             7 += fluidTankInfo.capacity - fluidTankInfo.fluid.amount;
        }
        if (( 4 = Math.min( 4,  7)) == fluidStack.amount) {
            return null;
        }
        return FluidUtil.createAEFluidStack(fluidStack.getFluidID(), (long)(fluidStack.amount -  4));
    }

    public boolean isPrioritized(IAEFluidStack iAEFluidStack) {
        if (iAEFluidStack == null) {
            return false;
        }
        for (Fluid fluid :  .prioritizedFluids) {
            if (fluid != iAEFluidStack.getFluid()) continue;
            return true;
        }
        return false;
    }

    public boolean isValid(Object object) {
        return true;
    }

    public void onListUpdate() {
    }

    public void onNeighborChange() {
        HandlerPartStorageFluid handlerPartStorageFluid;
        if (handlerPartStorageFluid.externalSystem != null && ( 2 = handlerPartStorageFluid.externalSystem.getMonitorable(handlerPartStorageFluid.node.getSide().getOpposite(), (BaseActionSource)new MachineSource((IActionHost)handlerPartStorageFluid.node))) != null && ( 3 =  2.getFluidInventory()) != null) {
             3.removeListener((IMEMonitorHandlerReceiver)handlerPartStorageFluid);
        }
        handlerPartStorageFluid.tank = null;
        ForgeDirection  2 = handlerPartStorageFluid.node.getSide();
        TileEntity  3 = handlerPartStorageFluid.node.getHostTile();
        if ( 3 == null) {
            return;
        }
        if ( 3.func_145831_w() == null) {
            return;
        }
        handlerPartStorageFluid.tile =   =  3.func_145831_w().func_147438_o( 3.field_145851_c +  2.offsetX,  3.field_145848_d +  2.offsetY,  3.field_145849_e +  2.offsetZ);
        handlerPartStorageFluid.tank = null;
        handlerPartStorageFluid.externalSystem = null;
        if (  == null) {
            handlerPartStorageFluid.externalHandler = null;
            return;
        }
        handlerPartStorageFluid.externalHandler = AEApi.instance().registries().externalStorage().getHandler( , handlerPartStorageFluid.node.getSide().getOpposite(), StorageChannel.FLUIDS, (BaseActionSource)new MachineSource((IActionHost)handlerPartStorageFluid.node));
        if (  instanceof ITileStorageMonitorable) {
            handlerPartStorageFluid.externalSystem = (ITileStorageMonitorable) ;
            IStorageMonitorable iStorageMonitorable = handlerPartStorageFluid.externalSystem.getMonitorable(handlerPartStorageFluid.node.getSide().getOpposite(), (BaseActionSource)new MachineSource((IActionHost)handlerPartStorageFluid.node));
            if (iStorageMonitorable == null) {
                return;
            }
            IMEMonitor  4 = iStorageMonitorable.getFluidInventory();
            if ( 4 == null) {
                return;
            }
             4.addListener((IMEMonitorHandlerReceiver)handlerPartStorageFluid, null);
        } else if (handlerPartStorageFluid.externalHandler == null &&   instanceof IFluidHandler) {
            handlerPartStorageFluid.tank = (IFluidHandler) ;
        }
    }

    public void postChange(IBaseMonitor<IAEFluidStack> iBaseMonitor, Iterable<IAEFluidStack> iterable, BaseActionSource baseActionSource) {
        IGridNode iGridNode =  .node.getGridNode();
        if (iGridNode != null) {
            IGrid iGrid = iGridNode.getGrid();
            if (iGrid != null) {
                iGrid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                iGridNode.getGrid().postEvent((MENetworkEvent)new MENetworkStorageEvent( .node.getGridBlock().getFluidMonitor(), StorageChannel.FLUIDS));
            }
             .node.getHost().markForUpdate();
        }
    }

    public void setAccessRestriction(AccessRestriction accessRestriction) {
         .access = accessRestriction;
    }

    public void setInverted(boolean bl) {
        \u000a\u000a\u000a\u000a .inverted = bl;
    }

    public void setPrioritizedFluids(Fluid[] fluidArray) {
        \u000a
        .prioritizedFluids.clear();
        for (Fluid fluid : fluidArray) {
            if (fluid == null) continue;
            \u000a
            .prioritizedFluids.add(fluid);
        }
    }

    public boolean validForPass(int n) {
        return true;
    }
}

