/*
 * Decompiled with CFR 0.152.
 */
package extracells.item;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.ICellRegistry;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.15_09_2024__02_32_46.cwp;
import extracells.15_09_2024__02_32_46.lt;
import extracells.15_09_2024__02_32_46.me\u043c;
import extracells.15_09_2024__02_32_46.t\u0441g;
import extracells.15_09_2024__02_32_46.u\u0435\u0430;
import extracells.15_09_2024__02_32_46.v\u0441u;
import extracells.15_09_2024__02_32_46.xll;
import extracells.15_09_2024__02_32_46.y\u0435h;
import extracells.15_09_2024__02_32_46.zvo;
import extracells.15_09_2024__02_32_46.zwn;
import extracells.15_09_2024__02_32_46.\u0430r\u043e;
import extracells.15_09_2024__02_32_46.\u0435el;
import extracells.15_09_2024__02_32_46.\u0435\u0445\u043c;
import extracells.15_09_2024__02_32_46.\u043e\u0441z;
import extracells.15_09_2024__02_32_46.\u0441cw;
import extracells.15_09_2024__02_32_46.\u0441\u0441k;
import extracells.15_09_2024__02_32_46.\u0443kg;
import extracells.15_09_2024__02_32_46.\u0443zf;
import extracells.Extracells;
import extracells.item.ItemECBase;
import extracells.registries.ItemEnum;
import extracells.util.inventory.ECCellInventory;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="cofh.api.energy.IEnergyContainerItem", modid="CoFHAPI|energy")
public class ItemStoragePhysical
extends ItemECBase
implements IStorageCell,
IAEItemPowerStorage,
IEnergyContainerItem {
    public static final String[] suffixes = new String[]{xll." a\u0445x", \u0443zf." tkj", v\u0441u." rec", me\u043c." io", u\u0435\u0430."ys z"};
    public static final int[] bytes_cell = new int[]{262144, 0x100000, 0x400000, 0x1000000, 65536};
    public static final int[] types_cell = new int[]{63, 63, 63, 63, 1};
    private IIcon[] icons;
    private final int MAX_POWER = 32000;

    public ItemStoragePhysical() {
        ItemStoragePhysical itemStoragePhysical;
        itemStoragePhysical.func_77625_d(1);
        itemStoragePhysical.func_77656_e(0);
        itemStoragePhysical.func_77627_a(true);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        ICellRegistry iCellRegistry = AEApi.instance().registries().cell();
        IMEInventoryHandler  2 = iCellRegistry.getCellInventory(itemStack, null, StorageChannel.ITEMS);
        ICellInventoryHandler  3 = (ICellInventoryHandler) 2;
        ICellInventory  4 =  3.getCellInv();
        long  5 =  4.getUsedBytes();
        list.add(String.format(StatCollector.func_74838_a((String)zwn."zp x"),  5,  4.getTotalBytes()));
        list.add(String.format(StatCollector.func_74838_a((String)\u0443zf."d h\u0430"),  4.getStoredItemTypes(),  4.getTotalItemTypes()));
        if ( 5 > 0L) {
            list.add(String.format(StatCollector.func_74838_a((String)\u0441\u0441k."\u0435e n"),  4.getStoredItemCount()));
        }
    }

    public int getBytesPerType(ItemStack itemStack) {
        return Extracells.dynamicTypes ? bytes_cell[MathHelper.func_76125_a((int)itemStack.func_77960_j(), (int)0, (int)(suffixes.length - 1))] / 128 : 8;
    }

    public int BytePerType(ItemStack itemStack) {
        return  .getBytesPerType(itemStack);
    }

    private NBTTagCompound ensureTagCompound(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p();
    }

    public double extractAEPower(ItemStack itemStack, double d) {
        if (itemStack == null || itemStack.func_77960_j() != 4) {
            return 0.0;
        }
        NBTTagCompound nBTTagCompound =  .ensureTagCompound(itemStack);
        double  2 = nBTTagCompound.func_74769_h(\u0435el."q \u0435i");
        double  3 = Math.min(d,  2);
        nBTTagCompound.func_74780_a(\u0435el."q \u0435i",  2 -  3);
        return  3;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int extractEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack == null || itemStack.func_77960_j() != 4) {
            return 0;
        }
        if (bl) {
            return  .getEnergyStored(itemStack) >= n ? n :  .getEnergyStored(itemStack);
        }
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF,  .extractAEPower(itemStack, PowerUnits.RF.convertTo(PowerUnits.AE, (double)n)));
    }

    public double getAECurrentPower(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77960_j() != 4) {
            return 0.0;
        }
        NBTTagCompound nBTTagCompound =  .ensureTagCompound(itemStack);
        return nBTTagCompound.func_74769_h(\u0435el."q \u0435i");
    }

    public double getAEMaxPower(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77960_j() != 4) {
            return 0.0;
        }
        return  .MAX_POWER;
    }

    public int getBytes(ItemStack itemStack) {
        return bytes_cell[MathHelper.func_76125_a((int)itemStack.func_77960_j(), (int)0, (int)(suffixes.length - 1))];
    }

    public IInventory getConfigInventory(ItemStack $) {
        return new ECCellInventory($, \u0443kg."\u043d\u0440 u", 63, 1);
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77960_j() != 4) {
            return super.getDurabilityForDisplay(itemStack);
        }
        return 1.0 - \u000a\u000a
        .getAECurrentPower(itemStack) / (double)\u000a\u000a
        .MAX_POWER;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getEnergyStored(ItemStack itemStack) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF,  .getAECurrentPower(itemStack));
    }

    public FuzzyMode getFuzzyMode(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return FuzzyMode.values()[itemStack.func_77978_p().func_74762_e(lt."\u043ck v")];
    }

    public IIcon func_77617_a(int n) {
        return  .icons[MathHelper.func_76125_a((int)n, (int)0, (int)(suffixes.length - 1))];
    }

    public double getIdleDrain() {
        return 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack itemStack) {
        if (itemStack == null) {
            return super.func_77653_i(itemStack);
        }
        if (itemStack.func_77960_j() == 4) {
            try {
                IItemList iItemList = AEApi.instance().registries().cell().getCellInventory(itemStack, null, StorageChannel.ITEMS).getAvailableItems(AEApi.instance().storage().createItemList());
                if (iItemList.isEmpty()) {
                    return super.func_77653_i(itemStack) + me\u043c."r vz" + StatCollector.func_74838_a((String)y\u0435h." c\u043e\u0430");
                }
                IAEItemStack  2 = (IAEItemStack)iItemList.getFirstItem();
                return super.func_77653_i(itemStack) + me\u043c."r vz" +  2.getItemStack().func_82833_r();
            }
            catch (Throwable throwable) {
                return super.func_77653_i(itemStack) + me\u043c."r vz" + StatCollector.func_74838_a((String)y\u0435h." c\u043e\u0430");
            }
        }
        return super.func_77653_i(itemStack);
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getMaxEnergyStored(ItemStack itemStack) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, \u000a\u000a\u000a\u000a
        .getAEMaxPower(itemStack));
    }

    public AccessRestriction getPowerFlow(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        return itemStack.func_77960_j() == 4 ? AccessRestriction.READ_WRITE : AccessRestriction.NO_ACCESS;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < suffixes.length; ++i) {
            list.add(new ItemStack(item, 1, i));
            if (i != 4) continue;
            ItemStack itemStack = new ItemStack(item, 1, i);
            itemStack.func_77982_d(new NBTTagCompound());
            itemStack.func_77978_p().func_74780_a(\u0435el."q \u0435i", (double) .MAX_POWER);
            list.add(itemStack);
        }
    }

    public int getTotalTypes(ItemStack itemStack) {
        return types_cell[MathHelper.func_76125_a((int)itemStack.func_77960_j(), (int)0, (int)(suffixes.length - 1))];
    }

    public String func_77667_c(ItemStack itemStack) {
        return \u0430r\u043e."\u043c vi" + (itemStack == null ? Integer.valueOf(0) : suffixes[MathHelper.func_76125_a((int)itemStack.func_77960_j(), (int)0, (int)(suffixes.length - 1))]);
    }

    public IInventory getUpgradesInventory(ItemStack itemStack) {
        return new ECCellInventory(itemStack, t\u0441g." on", 2, 1);
    }

    public double injectAEPower(ItemStack itemStack, double d) {
        if (itemStack == null || itemStack.func_77960_j() != 4) {
            return 0.0;
        }
        NBTTagCompound nBTTagCompound =  .ensureTagCompound(itemStack);
        double  2 = nBTTagCompound.func_74769_h(\u0435el."q \u0435i");
        double  3 = Math.min(d, (double) .MAX_POWER -  2);
        nBTTagCompound.func_74780_a(\u0435el."q \u0435i",  2 +  3);
        return  3;
    }

    public boolean isBlackListed(ItemStack itemStack, IAEItemStack iAEItemStack) {
        return false;
    }

    public boolean isEditable(ItemStack itemStack) {
        return true;
    }

    public boolean isStorageCell(ItemStack itemStack) {
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.func_77960_j() == 4 && !world.field_72995_K && entityPlayer.func_70093_af()) {
            switch (itemStack.func_77978_p().func_74762_e(me\u043c."r br")) {
                case 0: {
                    itemStack.func_77978_p().func_74768_a(me\u043c."r br", 1);
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation(\u0441cw."q l\u043d", new Object[0]));
                    break;
                }
                case 1: {
                    itemStack.func_77978_p().func_74768_a(me\u043c."r br", 2);
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation(cwp."x d\u0435", new Object[0]));
                    break;
                }
                case 2: {
                    itemStack.func_77978_p().func_74768_a(me\u043c."r br", 0);
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation(zvo."\u043c\u0445 l", new Object[0]));
                }
            }
            return itemStack;
        }
        if (!entityPlayer.func_70093_af()) {
            return itemStack;
        }
        if (world.field_72995_K) {
            return itemStack;
        }
        IMEInventoryHandler iMEInventoryHandler = AEApi.instance().registries().cell().getCellInventory(itemStack, null, StorageChannel.ITEMS);
        ICellInventoryHandler \u000a\u000a\u000a2 = (ICellInventoryHandler)iMEInventoryHandler;
        ICellInventory \u000a\u000a\u000a3 = \u000a\u000a\u000a2.getCellInv();
        return \u000a\u000a\u000a3.getUsedBytes() == 0L && entityPlayer.field_71071_by.func_70441_a(ItemEnum.STORAGECASING.getDamagedStack(0)) ? ItemEnum.STORAGECOMPONET.getDamagedStack(itemStack.func_77960_j()) : itemStack;
    }

    public boolean func_77648_a(ItemStack itemStack2, EntityPlayer entityPlayer2, World world, int n, int n2, int n3, int n4, float f, float f2, float f3) {
        if (itemStack2 == null || entityPlayer2 == null) {
            return false;
        }
        if (itemStack2.func_77960_j() == 4 && !entityPlayer2.func_70093_af()) {
            double d = $ .getAECurrentPower(itemStack2);
            ForgeDirection $ 2 = ForgeDirection.getOrientation((int)n4);
            IItemList $ 3 = AEApi.instance().registries().cell().getCellInventory(itemStack2, null, StorageChannel.ITEMS).getAvailableItems(AEApi.instance().storage().createItemList());
            if ($ 3.isEmpty()) {
                return false;
            }
            IAEItemStack $ 4 = (IAEItemStack)$ 3.getFirstItem();
            if (world.func_147439_a(n + $ 2.offsetX, n2 + $ 2.offsetY, n3 + $ 2.offsetZ) == Blocks.field_150350_a && $ 4.getStackSize() != 0L && d >= 20.0) {
                if (!world.field_72995_K) {
                    EntityPlayer entityPlayer2;
                    IAEItemStack iAEItemStack = $ 4.copy();
                    iAEItemStack.setStackSize(1L);
                    ItemStack $ 5 = iAEItemStack.getItemStack();
                    if ($ 5.func_77973_b() instanceof ItemBlock) {
                        ItemBlock itemBlock = (ItemBlock)iAEItemStack.getItem();
                        if (world.func_147439_a(n, n2, n3) != Blocks.field_150357_h && world.func_147439_a(n, n2, n3).func_149712_f(world, n, n2, n3) >= 0.0f) {
                            block0 : switch (itemStack2.func_77978_p().func_74762_e(me\u043c."r br")) {
                                case 0: {
                                    iAEItemStack.setStackSize(1L);
                                    itemBlock.onItemUseFirst(iAEItemStack.getItemStack(), entityPlayer2, world, n, n2, n3, n4, f, f2, f3);
                                    itemBlock.func_77648_a(iAEItemStack.getItemStack(), entityPlayer2, world, n, n2, n3, n4, f, f2, f3);
                                    AEApi.instance().registries().cell().getCellInventory(itemStack2, null, StorageChannel.ITEMS).extractItems((IAEStack)iAEItemStack, Actionable.MODULATE, (BaseActionSource)new PlayerSource(entityPlayer2, null));
                                    $ .extractAEPower(entityPlayer2.func_71045_bC(), 20.0);
                                    break;
                                }
                                case 1: {
                                    iAEItemStack.setStackSize(1L);
                                    world.func_147480_a(n, n2, n3, true);
                                    $ .placeBlock(iAEItemStack.getItemStack(), world, entityPlayer2, n, n2, n3, n4, f, f2, f3);
                                    AEApi.instance().registries().cell().getCellInventory(itemStack2, null, StorageChannel.ITEMS).extractItems((IAEStack)iAEItemStack, Actionable.MODULATE, (BaseActionSource)new PlayerSource(entityPlayer2, null));
                                    break;
                                }
                                case 2: {
                                    iAEItemStack.setStackSize(9L);
                                    if ($ 4.getStackSize() <= 9L || !(d >= 180.0)) break;
                                    switch (ForgeDirection.getOrientation((int)n4)) {
                                        case DOWN: {
                                            ItemStack itemStack2;
                                            for (int i = n - 1; i < n + 2; ++i) {
                                                for ($  = n3 - 1; $  < n3 + 2; ++$ ) {
                                                    if (world.func_147439_a(i, n2, $ ) == Blocks.field_150357_h || !(world.func_147439_a(i, n2, $ ).func_149712_f(world, i, n2, $ ) >= 0.0f)) continue;
                                                    world.func_147480_a(i, n2, $ , true);
                                                    $ .placeBlock(iAEItemStack.getItemStack(), world, entityPlayer2, n, n2, n3, n4, f, f2, f3);
                                                }
                                            }
                                            AEApi.instance().registries().cell().getCellInventory(itemStack2, null, StorageChannel.ITEMS).extractItems((IAEStack)iAEItemStack, Actionable.MODULATE, (BaseActionSource)new PlayerSource(entityPlayer2, null));
                                            break block0;
                                        }
                                        case EAST: {
                                            ItemStack itemStack2;
                                            for (int i = n3 - 1; i < n3 + 2; ++i) {
                                                for ($  = n2 - 1; $  < n2 + 2; ++$ ) {
                                                    if (world.func_147439_a(n, $ , i) == Blocks.field_150357_h || !(world.func_147439_a(n, $ , i).func_149712_f(world, n, $ , i) >= 0.0f)) continue;
                                                    world.func_147480_a(n, $ , i, true);
                                                    $ .placeBlock(iAEItemStack.getItemStack(), world, entityPlayer2, n, $ , i, n4, f, f2, f3);
                                                }
                                            }
                                            AEApi.instance().registries().cell().getCellInventory(itemStack2, null, StorageChannel.ITEMS).extractItems((IAEStack)iAEItemStack, Actionable.MODULATE, (BaseActionSource)new PlayerSource(entityPlayer2, null));
                                            break block0;
                                        }
                                        case NORTH: {
                                            ItemStack itemStack2;
                                            for (int i = n - 1; i < n + 2; ++i) {
                                                for ($  = n2 - 1; $  < n2 + 2; ++$ ) {
                                                    if (world.func_147439_a(i, $ , n3) == Blocks.field_150357_h || !(world.func_147439_a(i, $ , n3).func_149712_f(world, i, $ , n3) >= 0.0f)) continue;
                                                    world.func_147480_a(i, $ , n3, true);
                                                    $ .placeBlock(iAEItemStack.getItemStack(), world, entityPlayer2, i, $ , n3, n4, f, f2, f3);
                                                }
                                            }
                                            AEApi.instance().registries().cell().getCellInventory(itemStack2, null, StorageChannel.ITEMS).extractItems((IAEStack)iAEItemStack, Actionable.MODULATE, (BaseActionSource)new PlayerSource(entityPlayer2, null));
                                            break block0;
                                        }
                                        case SOUTH: {
                                            ItemStack itemStack2;
                                            for (int i = n - 1; i < n + 2; ++i) {
                                                for ($  = n2 - 1; $  < n2 + 2; ++$ ) {
                                                    if (world.func_147439_a(i, $ , n3) == Blocks.field_150357_h || !(world.func_147439_a(i, $ , n3).func_149712_f(world, i, $ , n3) >= 0.0f)) continue;
                                                    world.func_147480_a(i, $ , n3, true);
                                                    $ .placeBlock(iAEItemStack.getItemStack(), world, entityPlayer2, i, $ , n3, n4, f, f2, f3);
                                                }
                                            }
                                            AEApi.instance().registries().cell().getCellInventory(itemStack2, null, StorageChannel.ITEMS).extractItems((IAEStack)iAEItemStack, Actionable.MODULATE, (BaseActionSource)new PlayerSource(entityPlayer2, null));
                                            break block0;
                                        }
                                        case UNKNOWN: {
                                            break block0;
                                        }
                                        case UP: {
                                            ItemStack itemStack2;
                                            for (int i = n - 1; i < n + 2; ++i) {
                                                for ($  = n3 - 1; $  < n3 + 2; ++$ ) {
                                                    if (world.func_147439_a(i, n2, $ ) == Blocks.field_150357_h || !(world.func_147439_a(i, n2, $ ).func_149712_f(world, i, n2, $ ) >= 0.0f)) continue;
                                                    world.func_147480_a(i, n2, $ , true);
                                                    $ .placeBlock(iAEItemStack.getItemStack(), world, entityPlayer2, i, n2, $ , n4, f, f2, f3);
                                                }
                                            }
                                            AEApi.instance().registries().cell().getCellInventory(itemStack2, null, StorageChannel.ITEMS).extractItems((IAEStack)iAEItemStack, Actionable.MODULATE, (BaseActionSource)new PlayerSource(entityPlayer2, null));
                                            break block0;
                                        }
                                        case WEST: {
                                            ItemStack itemStack2;
                                            for (int i = n3 - 1; i < n3 + 2; ++i) {
                                                for ($  = n2 - 1; $  < n2 + 2; ++$ ) {
                                                    if (world.func_147439_a(n, $ , i) == Blocks.field_150357_h || !(world.func_147439_a(n, $ , i).func_149712_f(world, n, $ , i) >= 0.0f)) continue;
                                                    world.func_147480_a(n, $ , i, true);
                                                    $ .placeBlock(iAEItemStack.getItemStack(), world, entityPlayer2, n, $ , i, n4, f, f2, f3);
                                                }
                                            }
                                            AEApi.instance().registries().cell().getCellInventory(itemStack2, null, StorageChannel.ITEMS).extractItems((IAEStack)iAEItemStack, Actionable.MODULATE, (BaseActionSource)new PlayerSource(entityPlayer2, null));
                                            break block0;
                                        }
                                    }
                                }
                            }
                            return true;
                        }
                        return false;
                    }
                    entityPlayer2.func_145747_a((IChatComponent)new ChatComponentTranslation(\u043e\u0441z." adt", new Object[0]));
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public void placeBlock(ItemStack itemStack, World world, EntityPlayer entityPlayer, int n, int n2, int n3, int n4, float f, float f2, float f3) {
         .extractAEPower(entityPlayer.func_71045_bC(), 20.0);
        ItemBlock itemBlock = (ItemBlock)itemStack.func_77973_b();
        switch (ForgeDirection.getOrientation((int)n4)) {
            case DOWN: {
                itemBlock.onItemUseFirst(itemStack, entityPlayer, world, n, n2++, n3, n4, f, f2, f3);
                itemBlock.func_77648_a(itemStack, entityPlayer, world, n, n2++, n3, n4, f, f2, f3);
                break;
            }
            case EAST: {
                itemBlock.onItemUseFirst(itemStack, entityPlayer, world, n--, n2, n3, n4, f, f2, f3);
                itemBlock.func_77648_a(itemStack, entityPlayer, world, n--, n2, n3, n4, f, f2, f3);
                break;
            }
            case NORTH: {
                itemBlock.onItemUseFirst(itemStack, entityPlayer, world, n, n2, n3++, n4, f, f2, f3);
                itemBlock.func_77648_a(itemStack, entityPlayer, world, n, n2, n3++, n4, f, f2, f3);
                break;
            }
            case SOUTH: {
                itemBlock.onItemUseFirst(itemStack, entityPlayer, world, n, n2, n3--, n4, f, f2, f3);
                itemBlock.func_77648_a(itemStack, entityPlayer, world, n, n2, n3--, n4, f, f2, f3);
                break;
            }
            case UNKNOWN: {
                break;
            }
            case UP: {
                itemBlock.onItemUseFirst(itemStack, entityPlayer, world, n, n2--, n3, n4, f, f2, f3);
                itemBlock.func_77648_a(itemStack, entityPlayer, world, n, n2--, n3, n4, f, f2, f3);
                break;
            }
            case WEST: {
                itemBlock.onItemUseFirst(itemStack, entityPlayer, world, n++, n2, n3, n4, f, f2, f3);
                itemBlock.func_77648_a(itemStack, entityPlayer, world, n++, n2, n3, n4, f, f2, f3);
                break;
            }
        }
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int receiveEnergy(ItemStack $, int $2, boolean $3) {
        ItemStoragePhysical $4;
        if ($ == null || $.func_77960_j() != 4) {
            return 0;
        }
        if ($3) {
            double $5 = PowerUnits.AE.convertTo(PowerUnits.RF, $4.getAECurrentPower($));
            double $6 = PowerUnits.AE.convertTo(PowerUnits.RF, $4.getAEMaxPower($));
            if ($6 - $5 >= (double)$2) {
                return $2;
            }
            return (int)($6 - $5);
        }
        int $7 = (int)PowerUnits.AE.convertTo(PowerUnits.RF, $4.injectAEPower($, PowerUnits.RF.convertTo(PowerUnits.AE, (double)$2)));
        return $2 - $7;
    }

    public void func_94581_a(IIconRegister iIconRegister) {
         .icons = new IIcon[suffixes.length];
        for (int i = 0; i < suffixes.length; ++i) {
             .icons[i] = iIconRegister.func_94245_a(\u0435\u0445\u043c." dm\u0445" + suffixes[i]);
        }
    }

    public void setFuzzyMode(ItemStack itemStack, FuzzyMode fuzzyMode) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74768_a(lt."\u043ck v", fuzzyMode.ordinal());
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.func_77960_j() == 4;
    }

    public boolean storableInStorageCell() {
        return false;
    }
}

