/*
 * Decompiled with CFR 0.152.
 */
package extracells.network;

import appeng.api.parts.IPartHost;
import com.google.common.base.Charsets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.network.ChannelHandler;
import extracells.part.PartECBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public abstract class AbstractPacket
implements IMessage {
    protected EntityPlayer player;
    protected byte mode;

    @SideOnly(value=Side.CLIENT)
    public static World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static Fluid readFluid(ByteBuf byteBuf) {
        return FluidRegistry.getFluid((int)byteBuf.readInt());
    }

    public static PartECBase readPart(ByteBuf byteBuf) {
        return (PartECBase)((IPartHost)AbstractPacket.readTileEntity(byteBuf)).getPart(ForgeDirection.getOrientation((int)byteBuf.readByte()));
    }

    public static EntityPlayer readPlayer(ByteBuf byteBuf) {
        if (!byteBuf.readBoolean()) {
            return null;
        }
        World world = AbstractPacket.readWorld(byteBuf);
        return world.func_72924_a(AbstractPacket.readString(byteBuf));
    }

    public static String readString(ByteBuf byteBuf) {
        byte[] byArray = new byte[byteBuf.readInt()];
        byteBuf.readBytes(byArray);
        return new String(byArray, Charsets.UTF_8);
    }

    public static TileEntity readTileEntity(ByteBuf byteBuf) {
        return AbstractPacket.readWorld(byteBuf).func_147438_o(byteBuf.readInt(), byteBuf.readInt(), byteBuf.readInt());
    }

    public static World readWorld(ByteBuf byteBuf) {
        WorldServer worldServer = DimensionManager.getWorld((int)byteBuf.readInt());
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return worldServer != null ? worldServer : AbstractPacket.getClientWorld();
        }
        return worldServer;
    }

    public static void writeFluid(Fluid fluid, ByteBuf byteBuf) {
        if (fluid == null) {
            byteBuf.writeInt(-1);
            return;
        }
        byteBuf.writeInt(fluid.getID());
    }

    public static void writePart(PartECBase partECBase, ByteBuf byteBuf) {
        AbstractPacket.writeTileEntity(partECBase.getHost().getTile(), byteBuf);
        byteBuf.writeByte(partECBase.getSide().ordinal());
    }

    public static void writePlayer(EntityPlayer entityPlayer, ByteBuf byteBuf) {
        if (entityPlayer == null) {
            byteBuf.writeBoolean(false);
            return;
        }
        byteBuf.writeBoolean(true);
        AbstractPacket.writeWorld(entityPlayer.field_70170_p, byteBuf);
        AbstractPacket.writeString(entityPlayer.func_70005_c_(), byteBuf);
    }

    public static void writeString(String string, ByteBuf byteBuf) {
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        byteBuf.writeInt(byArray.length);
        byteBuf.writeBytes(byArray);
    }

    public static void writeTileEntity(TileEntity tileEntity, ByteBuf byteBuf) {
        AbstractPacket.writeWorld(tileEntity.func_145831_w(), byteBuf);
        byteBuf.writeInt(tileEntity.field_145851_c);
        byteBuf.writeInt(tileEntity.field_145848_d);
        byteBuf.writeInt(tileEntity.field_145849_e);
    }

    public static void writeWorld(World world, ByteBuf byteBuf) {
        byteBuf.writeInt(world.field_73011_w.field_76574_g);
    }

    public AbstractPacket() {
        AbstractPacket abstractPacket;
        abstractPacket.player = null;
    }

    public AbstractPacket(EntityPlayer entityPlayer) {
        \u000a\u000a\u000a
        .player = entityPlayer;
    }

    public abstract void execute();

    public void fromBytes(ByteBuf byteBuf) {
         .mode = byteBuf.readByte();
         .player = Minecraft.func_71410_x().func_71356_B() ? AbstractPacket.readPlayer(byteBuf) : Minecraft.func_71410_x().field_71439_g;
         .readData(byteBuf);
    }

    public abstract void readData(ByteBuf var1);

    public void sendPacketToAllPlayers() {
        AbstractPacket abstractPacket;
        ChannelHandler.sendPacketToAllPlayers(abstractPacket);
    }

    public void sendPacketToPlayer(EntityPlayer entityPlayer) {
        ChannelHandler.sendPacketToPlayer( , entityPlayer);
    }

    public void sendPacketToPlayersAround(NetworkRegistry.TargetPoint targetPoint) {
        ChannelHandler.sendPacketToPlayersAround( , targetPoint);
    }

    public void sendPacketToServer() {
        AbstractPacket abstractPacket;
        ChannelHandler.sendPacketToServer(abstractPacket);
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeByte((int) .mode);
        if (Minecraft.func_71410_x().func_71356_B()) {
            AbstractPacket.writePlayer( .player, byteBuf);
        }
         .writeData(byteBuf);
    }

    public abstract void writeData(ByteBuf var1);
}

