/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.RedstoneMode;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.15_09_2024__02_32_46.euk;
import extracells.15_09_2024__02_32_46.ldx;
import extracells.15_09_2024__02_32_46.lqd;
import extracells.15_09_2024__02_32_46.vrc;
import extracells.15_09_2024__02_32_46.\u0435el;
import extracells.15_09_2024__02_32_46.\u043c\u0441q;
import extracells.15_09_2024__02_32_46.\u0441\u0441k;
import extracells.container.ContainerBusFluidIO;
import extracells.gui.GuiBusFluidIO;
import extracells.network.packet.other.IFluidSlotPartOrBlock;
import extracells.network.packet.other.PacketFluidSlot;
import extracells.network.packet.part.PacketBusFluidIO;
import extracells.part.PartECBase;
import extracells.util.inventory.ECPrivateInventory;
import extracells.util.inventory.IInventoryUpdateReceiver;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public abstract class PartFluidIO
extends PartECBase
implements IGridTickable,
IInventoryUpdateReceiver,
IFluidSlotPartOrBlock {
    public Fluid[] filterFluids = new Fluid[9];
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    protected byte filterSize;
    protected byte speedState;
    protected boolean redstoneControlled;
    private boolean lastRedstone;
    private ECPrivateInventory upgradeInventory;

    public PartFluidIO() {
        PartFluidIO partFluidIO;
        partFluidIO.upgradeInventory = new ECPrivateInventory(\u0441\u0441k."d\u043e d", 4, 1, partFluidIO){

            @Override
            public boolean func_94041_b(int n, ItemStack itemStack) {
                if (itemStack == null) {
                    return false;
                }
                if (AEApi.instance().definitions().materials().cardCapacity().isSameAs(itemStack)) {
                    return true;
                }
                if (AEApi.instance().definitions().materials().cardSpeed().isSameAs(itemStack)) {
                    return true;
                }
                return AEApi.instance().definitions().materials().cardRedstone().isSameAs(itemStack);
            }
        };
    }

    @Override
    public void getDrops(List<ItemStack> list, boolean bl) {
        for (ItemStack itemStack :  .upgradeInventory.slots) {
            if (itemStack == null) continue;
            list.add(itemStack);
        }
    }

    @Override
    public ItemStack getItemStack(PartItemStack partItemStack) {
        ItemStack itemStack = super.getItemStack(partItemStack);
        if (partItemStack.equals((Object)PartItemStack.Wrench)) {
            itemStack.func_77978_p().func_82580_o(\u0435el."qs \u0443");
        }
        return itemStack;
    }

    @Override
    public int cableConnectionRenderTo() {
        return 5;
    }

    private boolean canDoWork() {
        PartFluidIO partFluidIO;
        boolean  2 = partFluidIO.isRedstonePowered();
        if (!partFluidIO.redstoneControlled) {
            return true;
        }
        switch (partFluidIO.getRedstoneMode()) {
            case IGNORE: {
                return true;
            }
            case LOW_SIGNAL: {
                return ! 2;
            }
            case HIGH_SIGNAL: {
                return  2;
            }
            case SIGNAL_PULSE: {
                return false;
            }
        }
        return false;
    }

    public byte getSpeedState() {
        PartFluidIO partFluidIO;
        return partFluidIO.speedState;
    }

    public abstract boolean doWork(int var1, int var2);

    @Override
    public abstract void getBoxes(IPartCollisionHelper var1);

    @Override
    public Object getClientGuiElement(EntityPlayer $) {
        PartFluidIO $2;
        return new GuiBusFluidIO($2, $);
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    public RedstoneMode getRedstoneMode() {
        PartFluidIO partFluidIO;
        return partFluidIO.redstoneMode;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer entityPlayer) {
        return new ContainerBusFluidIO(\u000a\u000a\u000a
        , entityPlayer);
    }

    public final TickingRequest getTickingRequest(IGridNode iGridNode) {
        return new TickingRequest(1, 20, false, false);
    }

    public ECPrivateInventory getUpgradeInventory() {
        PartFluidIO partFluidIO;
        return partFluidIO.upgradeInventory;
    }

    @Override
    public List<String> getWailaBodey(NBTTagCompound nBTTagCompound, List<String> list) {
        if (nBTTagCompound.func_74764_b(vrc."ai g")) {
            list.add(nBTTagCompound.func_74762_e(vrc."ai g") + \u043c\u0441q." g\u0435\u0435");
        } else {
            list.add(ldx." tgk");
        }
        return list;
    }

    @Override
    public NBTTagCompound getWailaTag(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74768_a(vrc."ai g", 125 +  .speedState * 125);
        return nBTTagCompound;
    }

    public void loopRedstoneMode(EntityPlayer entityPlayer) {
         .redstoneMode =  .redstoneMode.ordinal() + 1 < RedstoneMode.values().length ? RedstoneMode.values()[ .redstoneMode.ordinal() + 1] : RedstoneMode.values()[0];
        new PacketBusFluidIO( .redstoneMode).sendPacketToPlayer(entityPlayer);
         .saveData();
    }

    @Override
    public boolean onActivate(EntityPlayer entityPlayer, Vec3 vec3) {
        boolean bl = super.onActivate(entityPlayer, vec3);
        
        .onInventoryChanged();
        return bl;
    }

    @Override
    public void onInventoryChanged() {
        PartFluidIO partFluidIO;
        partFluidIO.filterSize = 0;
        partFluidIO.redstoneControlled = false;
        partFluidIO.speedState = 0;
        for (int i = 0; i < partFluidIO.upgradeInventory.func_70302_i_(); ++i) {
            ItemStack itemStack = partFluidIO.upgradeInventory.func_70301_a(i);
            if (itemStack == null) continue;
            if (AEApi.instance().definitions().materials().cardCapacity().isSameAs(itemStack)) {
                partFluidIO.filterSize = (byte)(partFluidIO.filterSize + 1);
            }
            if (AEApi.instance().definitions().materials().cardRedstone().isSameAs(itemStack)) {
                partFluidIO.redstoneControlled = true;
            }
            if (!AEApi.instance().definitions().materials().cardSpeed().isSameAs(itemStack)) continue;
            partFluidIO.speedState = (byte)(partFluidIO.speedState + 1);
        }
        if (!Minecraft.func_71410_x().func_71356_B()) {
            return;
        }
        new PacketBusFluidIO(partFluidIO.filterSize).sendPacketToAllPlayers();
        new PacketBusFluidIO(partFluidIO.redstoneControlled).sendPacketToAllPlayers();
        partFluidIO.saveData();
    }

    @Override
    public void onNeighborChanged() {
        PartFluidIO partFluidIO;
        super.onNeighborChanged();
        partFluidIO.lastRedstone =   = partFluidIO.isRedstonePowered();
    }

    @Override
    public final void readFromNBT(NBTTagCompound nBTTagCompound) {
        PartFluidIO partFluidIO;
        super.readFromNBT(nBTTagCompound);
        partFluidIO.redstoneMode = RedstoneMode.values()[nBTTagCompound.func_74762_e(euk."k z\u0441")];
        for (int i = 0; i < 9; ++i) {
            partFluidIO.filterFluids[i] = FluidRegistry.getFluid((String)nBTTagCompound.func_74779_i(lqd." quq" + i));
        }
        partFluidIO.upgradeInventory.readFromNBT(nBTTagCompound.func_150295_c(\u0435el."qs \u0443", 10));
        partFluidIO.onInventoryChanged();
    }

    @Override
    public final boolean readFromStream(ByteBuf byteBuf) throws IOException {
        return super.readFromStream(byteBuf);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void renderDynamic(double d, double d2, double d3, IPartRenderHelper iPartRenderHelper, RenderBlocks renderBlocks) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract void renderInventory(IPartRenderHelper var1, RenderBlocks var2);

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract void renderStatic(int var1, int var2, int var3, IPartRenderHelper var4, RenderBlocks var5);

    public void sendInformation(EntityPlayer entityPlayer) {
        new PacketFluidSlot(Arrays.asList( .filterFluids)).sendPacketToPlayer(entityPlayer);
        new PacketBusFluidIO( .redstoneMode).sendPacketToPlayer(entityPlayer);
        new PacketBusFluidIO( .filterSize).sendPacketToPlayer(entityPlayer);
    }

    @Override
    public final void setFluid(int n, Fluid fluid, EntityPlayer entityPlayer) {
        \u000a
        .filterFluids[n] = fluid;
        new PacketFluidSlot(Arrays.asList(\u000a
        .filterFluids)).sendPacketToPlayer(entityPlayer);
        \u000a
        .saveData();
    }

    @Override
    public void setPartHostInfo(ForgeDirection forgeDirection, IPartHost iPartHost, TileEntity tileEntity) {
        super.setPartHostInfo(forgeDirection, iPartHost, tileEntity);
         .onInventoryChanged();
    }

    public final TickRateModulation tickingRequest(IGridNode iGridNode, int n) {
        if (\u000a\u000a\u000a
        .canDoWork()) {
            return \u000a\u000a\u000a
            .doWork(125 + \u000a\u000a\u000a
            .speedState * 125, n) ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
        }
        return TickRateModulation.SLOWER;
    }

    @Override
    public final void writeToNBT(NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        super.writeToNBT(nBTTagCompound2);
        nBTTagCompound2.func_74768_a(euk."k z\u0441",  .redstoneMode.ordinal());
        for (int i = 0; i <  .filterFluids.length; ++i) {
            Fluid fluid =  .filterFluids[i];
            if (fluid != null) {
                nBTTagCompound2.func_74778_a(lqd." quq" + i, fluid.getName());
                continue;
            }
            nBTTagCompound2.func_74778_a(lqd." quq" + i, \u0441\u0441k."d\u043e d");
        }
        nBTTagCompound2.func_74782_a(\u0435el."qs \u0443", (NBTBase) .upgradeInventory.writeToNBT());
    }

    @Override
    public final void writeToStream(ByteBuf byteBuf) throws IOException {
        super.writeToStream(byteBuf);
    }
}

