/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.15_09_2024__02_32_46.b\u0440s;
import extracells.15_09_2024__02_32_46.me\u043c;
import extracells.15_09_2024__02_32_46.rj\u043e;
import extracells.15_09_2024__02_32_46.\u0441\u0441k;
import extracells.container.ContainerFluidEmitter;
import extracells.gui.GuiFluidEmitter;
import extracells.network.packet.other.IFluidSlotPartOrBlock;
import extracells.network.packet.other.PacketFluidSlot;
import extracells.network.packet.part.PacketFluidEmitter;
import extracells.part.PartECBase;
import extracells.render.TextureManager;
import extracells.util.PermissionUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Random;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PartFluidLevelEmitter
extends PartECBase
implements IStackWatcherHost,
IFluidSlotPartOrBlock {
    private Fluid fluid;
    private RedstoneMode mode = RedstoneMode.HIGH_SIGNAL;
    private IStackWatcher watcher;
    private long wantedAmount;
    private long currentAmount;
    private boolean clientRedstoneOutput = false;

    public PartFluidLevelEmitter() {
        PartFluidLevelEmitter partFluidLevelEmitter;
    }

    @Override
    public int cableConnectionRenderTo() {
        return 8;
    }

    public void changeWantedAmount(int n, EntityPlayer entityPlayer) {
         .setWantedAmount( .wantedAmount + (long)n, entityPlayer);
    }

    @Override
    public void getBoxes(IPartCollisionHelper iPartCollisionHelper) {
        iPartCollisionHelper.addBox(7.0, 7.0, 11.0, 9.0, 9.0, 16.0);
    }

    @Override
    public Object getClientGuiElement(EntityPlayer entityPlayer) {
        return new GuiFluidEmitter( , entityPlayer);
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer entityPlayer) {
        return new ContainerFluidEmitter( , entityPlayer);
    }

    private boolean isPowering() {
        PartFluidLevelEmitter partFluidLevelEmitter;
        switch (partFluidLevelEmitter.mode) {
            case LOW_SIGNAL: {
                return partFluidLevelEmitter.wantedAmount >= partFluidLevelEmitter.currentAmount;
            }
            case HIGH_SIGNAL: {
                return partFluidLevelEmitter.wantedAmount <= partFluidLevelEmitter.currentAmount;
            }
        }
        return false;
    }

    @Override
    public int isProvidingStrongPower() {
        PartFluidLevelEmitter partFluidLevelEmitter;
        return partFluidLevelEmitter.isPowering() ? 15 : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        PartFluidLevelEmitter partFluidLevelEmitter;
        return partFluidLevelEmitter.isProvidingStrongPower();
    }

    private void notifyTargetBlock(TileEntity tileEntity, ForgeDirection forgeDirection) {
        tileEntity.func_145831_w().func_147459_d(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, Blocks.field_150350_a);
        tileEntity.func_145831_w().func_147459_d(tileEntity.field_145851_c + forgeDirection.offsetX, tileEntity.field_145848_d + forgeDirection.offsetY, tileEntity.field_145849_e + forgeDirection.offsetZ, Blocks.field_150350_a);
    }

    @Override
    public boolean onActivate(EntityPlayer entityPlayer, Vec3 vec3) {
        if (entityPlayer.field_70170_p.field_72995_K) {
            return true;
        }
        if (PermissionUtil.hasPermission(entityPlayer, SecurityPermissions.BUILD,  )) {
            return super.onActivate(entityPlayer, vec3);
        }
        return false;
    }

    public void onStackChange(IItemList iItemList, IAEStack iAEStack, IAEStack iAEStack2, BaseActionSource baseActionSource, StorageChannel storageChannel) {
        if (storageChannel == StorageChannel.FLUIDS && iAEStack2 != null && ((IAEFluidStack)iAEStack2).getFluid() ==  .fluid) {
             .currentAmount = iAEStack != null ? iAEStack.getStackSize() : 0L;
            IGridNode iGridNode =  .getGridNode();
            if (iGridNode != null) {
                 .setActive(iGridNode.isActive());
                 .getHost().markForUpdate();
                 .notifyTargetBlock( .getHostTile(),  .getSide());
            }
        }
    }

    @Override
    public void randomDisplayTick(World world, int n, int n2, int n3, Random random) {
        if (\u000a\u000a
        .clientRedstoneOutput) {
            ForgeDirection forgeDirection = \u000a\u000a
            .getSide();
            double \u000a\u000a\u000a2 = (double)((float)forgeDirection.offsetX * 0.45f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double \u000a\u000a\u000a3 = (double)((float)forgeDirection.offsetY * 0.45f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double \u000a\u000a\u000a4 = (double)((float)forgeDirection.offsetZ * 0.45f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            world.func_72869_a(rj\u043e."b\u043e v", 0.5 + (double)n + \u000a\u000a\u000a2, 0.5 + (double)n2 + \u000a\u000a\u000a3, 0.5 + (double)n3 + \u000a\u000a\u000a4, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        super.readFromNBT(nBTTagCompound);
         .fluid = FluidRegistry.getFluid((String)nBTTagCompound.func_74779_i(b\u0440s." \u0430tp"));
         .mode = RedstoneMode.values()[nBTTagCompound.func_74762_e(me\u043c."r br")];
         .wantedAmount = nBTTagCompound.func_74763_f(\u0441\u0441k." pm\u0435");
        if ( .wantedAmount < 0L) {
             .wantedAmount = 0L;
        }
    }

    @Override
    public boolean readFromStream(ByteBuf byteBuf) throws IOException {
        super.readFromStream(byteBuf);
         .clientRedstoneOutput = byteBuf.readBoolean();
        if ( .getHost() != null) {
             .getHost().markForUpdate();
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper iPartRenderHelper, RenderBlocks renderBlocks) {
        iPartRenderHelper.setTexture(TextureManager.LEVEL_FRONT.getTextures()[0]);
        iPartRenderHelper.setBounds(7.0f, 7.0f, 11.0f, 9.0f, 9.0f, 14.0f);
        iPartRenderHelper.renderInventoryBox(renderBlocks);
        iPartRenderHelper.setTexture(TextureManager.LEVEL_FRONT.getTextures()[1]);
        iPartRenderHelper.setBounds(7.0f, 7.0f, 14.0f, 9.0f, 9.0f, 16.0f);
        iPartRenderHelper.renderInventoryBox(renderBlocks);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int n, int n2, int n3, IPartRenderHelper iPartRenderHelper, RenderBlocks renderBlocks) {
        iPartRenderHelper.setTexture(TextureManager.LEVEL_FRONT.getTextures()[0]);
        iPartRenderHelper.setBounds(7.0f, 7.0f, 11.0f, 9.0f, 9.0f, 14.0f);
        iPartRenderHelper.renderBlock(n, n2, n3, renderBlocks);
        iPartRenderHelper.setTexture( .clientRedstoneOutput ? TextureManager.LEVEL_FRONT.getTextures()[2] : TextureManager.LEVEL_FRONT.getTextures()[1]);
        iPartRenderHelper.setBounds(7.0f, 7.0f, 14.0f, 9.0f, 9.0f, 16.0f);
        iPartRenderHelper.renderBlock(n, n2, n3, renderBlocks);
    }

    @Override
    public void setFluid(int $, Fluid $2, EntityPlayer $3) {
        PartFluidLevelEmitter $4;
        $4.fluid = $2;
        if ($4.watcher == null) {
            return;
        }
        $4.watcher.clear();
        $4.updateWatcher($4.watcher);
        new PacketFluidSlot(Lists.newArrayList((Object[])new Fluid[]{$4.fluid})).sendPacketToPlayer($3);
        $4.saveData();
    }

    public void setWantedAmount(long l, EntityPlayer entityPlayer) {
         .wantedAmount = l;
        if ( .wantedAmount < 0L) {
             .wantedAmount = 0L;
        }
        new PacketFluidEmitter( .wantedAmount, entityPlayer).sendPacketToPlayer(entityPlayer);
         .notifyTargetBlock( .getHostTile(),  .getSide());
         .saveData();
    }

    public void syncClientGui(EntityPlayer entityPlayer) {
        new PacketFluidEmitter( .mode, entityPlayer).sendPacketToPlayer(entityPlayer);
        new PacketFluidEmitter( .wantedAmount, entityPlayer).sendPacketToPlayer(entityPlayer);
        new PacketFluidSlot(Lists.newArrayList((Object[])new Fluid[]{ .fluid})).sendPacketToPlayer(entityPlayer);
    }

    public void toggleMode(EntityPlayer entityPlayer) {
        switch ( .mode) {
            case LOW_SIGNAL: {
                 .mode = RedstoneMode.HIGH_SIGNAL;
                break;
            }
            default: {
                 .mode = RedstoneMode.LOW_SIGNAL;
            }
        }
         .notifyTargetBlock( .getHostTile(),  .getSide());
        new PacketFluidEmitter( .mode, entityPlayer).sendPacketToPlayer(entityPlayer);
         .saveData();
    }

    public void updateWatcher(IStackWatcher iStackWatcher) {
         .watcher = iStackWatcher;
        if ( .fluid != null) {
             .watcher.add((Object)AEApi.instance().storage().createFluidStack(new FluidStack( .fluid, 1)));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        super.writeToNBT(nBTTagCompound);
        if ( .fluid != null) {
            nBTTagCompound.func_74778_a(b\u0440s." \u0430tp",  .fluid.getName());
        } else {
            nBTTagCompound.func_82580_o(b\u0440s." \u0430tp");
        }
        nBTTagCompound.func_74768_a(me\u043c."r br",  .mode.ordinal());
        nBTTagCompound.func_74772_a(\u0441\u0441k." pm\u0435",  .wantedAmount);
    }

    @Override
    public void writeToStream(ByteBuf byteBuf) throws IOException {
        super.writeToStream(byteBuf);
        byteBuf.writeBoolean(\u000a\u000a
        .isPowering());
    }
}

