/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.repack.com.unascribed.ears.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import pl.asie.foamfix.repack.com.unascribed.ears.api.features.AlfalfaData;
import pl.asie.foamfix.repack.com.unascribed.ears.api.features.EarsFeatures;
import pl.asie.foamfix.repack.com.unascribed.ears.common.Alfalfa;
import pl.asie.foamfix.repack.com.unascribed.ears.common.WritableEarsImage;
import pl.asie.foamfix.repack.com.unascribed.ears.common.util.BitOutputStream;

public class EarsFeaturesWriterV1 {
    public static void write(EarsFeatures feat, OutputStream os) throws IOException {
        BitOutputStream bos = new BitOutputStream(os);
        bos.write(8, 0L);
        int ears = feat.earMode == EarsFeatures.EarMode.NONE ? 0 : (feat.earMode.ordinal() - 1) * 3 + feat.earAnchor.ordinal() + 1;
        bos.write(6, ears);
        bos.write(feat.claws);
        bos.write(feat.horn);
        bos.write(3, feat.tailMode.ordinal());
        if (feat.tailMode != EarsFeatures.TailMode.NONE) {
            bos.write(2, feat.tailSegments - 1);
            bos.writeSAMUnit(6, feat.tailBend0 / 90.0f);
            if (feat.tailSegments > 1) {
                bos.writeSAMUnit(6, feat.tailBend1 / 90.0f);
            }
            if (feat.tailSegments > 2) {
                bos.writeSAMUnit(6, feat.tailBend2 / 90.0f);
            }
            if (feat.tailSegments > 3) {
                bos.writeSAMUnit(6, feat.tailBend3 / 90.0f);
            }
        }
        if (feat.snoutWidth > 0 && feat.snoutHeight > 0 && feat.snoutDepth > 0) {
            bos.write(3, feat.snoutWidth);
            bos.write(2, feat.snoutHeight - 1);
            bos.write(3, feat.snoutDepth - 1);
            bos.write(3, feat.snoutOffset);
        } else {
            bos.write(3, 0L);
        }
        bos.writeUnit(5, feat.chestSize);
        bos.write(3, feat.wingMode.ordinal());
        if (feat.wingMode != EarsFeatures.WingMode.NONE) {
            bos.write(feat.animateWings);
        }
        bos.write(feat.capeEnabled);
        bos.write(feat.emissive);
        bos.flush();
    }

    public static void write(EarsFeatures feat, WritableEarsImage img) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        EarsFeaturesWriterV1.write(feat, baos);
        if (baos.size() > 45) {
            throw new IOException("Cannot write " + baos.size() + " bytes - only have room for 141");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                int c;
                if (x == 0 && y == 0) {
                    c = -1432319;
                } else {
                    c = -16777216;
                    c |= (EarsFeaturesWriterV1.readEOF0(bais) & 0xFF) << 16;
                    c |= (EarsFeaturesWriterV1.readEOF0(bais) & 0xFF) << 8;
                    c |= EarsFeaturesWriterV1.readEOF0(bais) & 0xFF;
                }
                img.setARGB(x, 32 + y, c);
            }
        }
        if (feat.alfalfa != null) {
            Alfalfa.write(feat.alfalfa, img);
        } else {
            Alfalfa.write(AlfalfaData.NONE, img);
        }
    }

    private static int readEOF0(InputStream in) throws IOException {
        int i = in.read();
        if (i == -1) {
            return 0;
        }
        return i;
    }
}

