/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block.fluid;

import cofh.core.fluid.BlockFluidCoFHBase;
import cofh.lib.util.RegistryUtils;
import cofh.lib.util.WeightedRandomItemStack;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.IRedNetDecorative;
import powercrystals.minefactoryreloaded.setup.MFRThings;

public class BlockFactoryFluid
extends BlockFluidCoFHBase
implements IRedNetDecorative {
    private static DamageSource steam = new DamageSource("steam");
    public static final Material material = new MaterialLiquid(MapColor.field_151662_n);
    @SideOnly(value=Side.CLIENT)
    protected IIcon _iconFlowing;
    @SideOnly(value=Side.CLIENT)
    protected IIcon _iconStill;
    @SideOnly(value=Side.CLIENT)
    public int color;
    protected String fluidName;

    private static Fluid ensureFluid(String var0) {
        Fluid var1 = FluidRegistry.getFluid((String)var0);
        if (var1.canBePlacedInWorld()) {
            ReflectionHelper.setPrivateValue(Fluid.class, (Object)var1, null, (String[])new String[]{"block"});
        }
        return var1;
    }

    public BlockFactoryFluid(String var1) {
        this(var1, Material.field_151586_h);
    }

    public BlockFactoryFluid(String var1, Material var2) {
        super(BlockFactoryFluid.ensureFluid(var1), var2, var1);
        steam.func_76348_h().func_76361_j().func_76351_m();
        steam.func_151518_m();
        this.func_149663_c("mfr." + var1 + ".still");
        this.func_149711_c(100.0f);
        this.func_149713_g(3);
        this.setDisplaceFluids(true);
        this.fluidName = var1;
    }

    public void func_149670_a(World var1, int var2, int var3, int var4, Entity var5) {
        super.func_149670_a(var1, var2, var3, var4, var5);
        if (var5 instanceof EntityLivingBase) {
            NBTTagCompound var6 = var5.getEntityData();
            if (var1.field_72995_K || var6.func_74763_f("mfr:fluidTimer" + this.fluidName) > var1.func_82737_E()) {
                return;
            }
            var6.func_74772_a("mfr:fluidTimer" + this.fluidName, var1.func_82737_E() + 40L);
            EntityLivingBase var7 = (EntityLivingBase)var5;
            if (this == MFRThings.milkLiquid) {
                var7.func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, 120, 0, true));
            } else if (this == MFRThings.sludgeLiquid) {
                var7.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 240, 0));
                var7.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 240, 0, true));
                var7.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 320, 0, true));
            } else if (this == MFRThings.sewageLiquid) {
                var7.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 240, 0, true));
                var7.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 240, 0));
                var7.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 240, 0, true));
            } else if (this == MFRThings.essenceLiquid) {
                var7.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 1200, 0, true));
            } else if (this == MFRThings.biofuelLiquid) {
                var7.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 240, 0, true));
            } else if (this == MFRThings.steamFluid) {
                var7.func_70097_a(steam, 6.0f);
            }
        }
    }

    public int getLightValue(IBlockAccess var1, int var2, int var3, int var4) {
        int var5 = super.getLightValue(var1, var2, var3, var4);
        if (this.maxScaledLight != 0) {
            var5 = Math.max(var5, 2);
        }
        return var5;
    }

    public void func_149726_b(World var1, int var2, int var3, int var4) {
        super.func_149726_b(var1, var2, var3, var4);
        this.checkCanStay(var1, var2, var3, var4, var1.field_73012_v);
    }

    public void func_149674_a(World var1, int var2, int var3, int var4, Random var5) {
        this.checkCanStay(var1, var2, var3, var4, var5);
        super.func_149674_a(var1, var2, var3, var4, var5);
    }

    protected void checkCanStay(World var1, int var2, int var3, int var4, Random var5) {
        if (var1.field_73011_w.field_76575_d) {
            if (!this.isSourceBlock((IBlockAccess)var1, var2, var3, var4)) {
                if (var1.func_147468_f(var2, var3, var4)) {
                    return;
                }
            } else {
                ItemStack var6 = null;
                Block var7 = Blocks.field_150350_a;
                if (this == MFRThings.milkLiquid) {
                    if (var5.nextInt(50) == 0) {
                        var6 = new ItemStack(Items.field_151100_aR, var5.nextInt(2), 15);
                    }
                } else if (this == MFRThings.sludgeLiquid) {
                    var6 = ((WeightedRandomItemStack)WeightedRandom.func_76271_a((Random)var5, MFRRegistry.getSludgeDrops())).getStack();
                } else if (this == MFRThings.sewageLiquid) {
                    var6 = new ItemStack(MFRThings.fertilizerItem, 1 + var5.nextInt(2));
                } else {
                    if (this == MFRThings.essenceLiquid) {
                        if (var1.func_147468_f(var2, var3, var4)) {
                            int var9;
                            for (int var8 = var5.nextInt(5) + 10; var8 > 0; var8 -= var9) {
                                var9 = EntityXPOrb.func_70527_a((int)var8);
                                var1.func_72838_d((Entity)new EntityXPOrb(var1, (double)var2 + var5.nextDouble(), (double)var3 + var5.nextDouble(), (double)var4 + var5.nextDouble(), var9));
                            }
                            this.fizz(var1, var2, var3, var4, var5);
                            return;
                        }
                        return;
                    }
                    if (this == MFRThings.meatLiquid) {
                        var6 = var5.nextInt(5) != 0 ? new ItemStack(MFRThings.meatIngotRawItem, var5.nextInt(2)) : new ItemStack(MFRThings.meatIngotCookedItem, var5.nextInt(2));
                    } else if (this == MFRThings.pinkSlimeLiquid) {
                        var6 = var5.nextBoolean() ? new ItemStack(MFRThings.pinkSlimeItem, var5.nextInt(3)) : (var5.nextInt(5) != 0 ? new ItemStack(MFRThings.meatNuggetRawItem, var5.nextInt(2)) : new ItemStack(MFRThings.meatNuggetCookedItem, var5.nextInt(2)));
                    } else if (this == MFRThings.chocolateMilkLiquid) {
                        if (var5.nextBoolean()) {
                            var6 = new ItemStack(Items.field_151100_aR, var5.nextInt(2), 3);
                        }
                    } else if (this == MFRThings.mushroomSoupLiquid) {
                        if (var5.nextInt(5) == 0) {
                            var7 = var5.nextBoolean() ? Blocks.field_150338_P : Blocks.field_150337_Q;
                        } else {
                            var6 = var5.nextBoolean() ? new ItemStack((Block)Blocks.field_150338_P, var5.nextInt(2)) : new ItemStack((Block)Blocks.field_150337_Q, var5.nextInt(2));
                        }
                    }
                }
                if (var1.func_147465_d(var2, var3, var4, var7, 0, 3)) {
                    if (var6 != null && var6.field_77994_a > 0) {
                        this.func_149642_a(var1, var2, var3, var4, var6);
                    }
                    this.fizz(var1, var2, var3, var4, var5);
                    return;
                }
            }
        }
    }

    protected void fizz(World var1, int var2, int var3, int var4, Random var5) {
        var1.func_72908_a((double)var2 + 0.5, (double)var3 + 0.5, (double)var4 + 0.5, "random.fizz", 0.5f, 2.6f + (var5.nextFloat() - var5.nextFloat()) * 0.8f);
        for (int var6 = 0; var6 < 8; ++var6) {
            var1.func_72869_a("largesmoke", (double)var2 + var5.nextDouble(), (double)var3 + var5.nextDouble(), (double)var4 + var5.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    public String func_149739_a() {
        return "fluid." + this.field_149770_b;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister var1) {
        String var2 = "minefactoryreloaded:";
        String var3 = this.func_149739_a();
        if (!RegistryUtils.blockTextureExists((String)(var2 + var3))) {
            var2 = var2 + "fluid/";
        }
        String var4 = var2 + var3;
        this.setIcons(var1.func_94245_a(var4), var1.func_94245_a(var4.replace(".still", ".flowing")));
    }

    @SideOnly(value=Side.CLIENT)
    public void setIcons(IIcon var1, IIcon var2) {
        this._iconStill = var1;
        this._iconFlowing = var2;
        this.color = var1 != null && var1.func_94215_i() != null ? RegistryUtils.getBlockTextureColor((String)var1.func_94215_i()) : (var2 != null && var2.func_94215_i() != null ? RegistryUtils.getBlockTextureColor((String)var2.func_94215_i()) : 0xFFFFFF);
        this.setParticleColor(this.color);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int var1, int var2) {
        return var1 <= 1 ? this._iconStill : this._iconFlowing;
    }
}

