/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.forestry;

import cofh.mod.ChildMod;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.IFactoryFruit;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.farmables.drinkhandlers.DrinkHandlerBiofuel;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizerStandard;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableWood;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableStandard;
import powercrystals.minefactoryreloaded.modhelpers.forestry.ForestryBogEarth;
import powercrystals.minefactoryreloaded.modhelpers.forestry.ForestryLeaf;
import powercrystals.minefactoryreloaded.modhelpers.forestry.ForestryPod;
import powercrystals.minefactoryreloaded.modhelpers.forestry.ForestrySapling;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityUnifier;

@ChildMod(parent="MineFactoryReloaded", mod={@Mod(modid="MineFactoryReloaded|CompatForestry", name="MFR Compat: Forestry", version="1.7.10R2.8.2B1", dependencies="after:MineFactoryReloaded;after:Forestry", customProperties={@Mod.CustomProperty(k="cofhversion", v="true")})})
public class Forestry {
    private static final String name = "Forestry";

    @Mod.EventHandler
    public void load(FMLInitializationEvent fMLInitializationEvent) {
        try {
            Forestry.initForestry();
        }
        catch (Throwable throwable) {
            ModContainer modContainer = FMLCommonHandler.instance().findContainerFor((Object)this);
            LogManager.getLogger((String)modContainer.getModId()).log(Level.ERROR, "There was a problem loading " + modContainer.getName(), throwable);
        }
    }

    private static void initForestry() {
        PlantableStandard plantableStandard;
        Item item = GameRegistry.findItem((String)name, (String)"fertilizerCompound");
        if (item != null) {
            MFRRegistry.registerFertilizer(new FertilizerStandard(item, 0));
        } else {
            MineFactoryReloadedCore.log().error("Forestry fertilizer null!");
        }
        item = GameRegistry.findItem((String)name, (String)"fertilizerBio");
        if (item != null) {
            MFRRegistry.registerFertilizer(new FertilizerStandard(item, 0));
        } else {
            MineFactoryReloadedCore.log().error("Forestry compost null!");
        }
        item = GameRegistry.findItem((String)name, (String)"peat");
        if (item != null) {
            MFRRegistry.registerSludgeDrop(10, new ItemStack(item));
        } else {
            MineFactoryReloadedCore.log().error("Forestry peat null!");
        }
        item = GameRegistry.findItem((String)name, (String)"ash");
        if (item != null) {
            MFRRegistry.registerSludgeDrop(1, new ItemStack(item));
        } else {
            MineFactoryReloadedCore.log().error("Forestry ash null!");
        }
        item = GameRegistry.findItem((String)name, (String)"decayingWheat");
        if (item != null) {
            MFRRegistry.registerSludgeDrop(20, new ItemStack(item));
        } else {
            MineFactoryReloadedCore.log().error("Forestry wheat null!");
        }
        item = GameRegistry.findItem((String)name, (String)"sapling");
        Block block = GameRegistry.findBlock((String)name, (String)"saplingGE");
        if (item != null && block != null) {
            plantableStandard = new ForestrySapling(item, block);
            MFRRegistry.registerPlantable(plantableStandard);
            MFRRegistry.registerFertilizable(plantableStandard);
        } else {
            MineFactoryReloadedCore.log().error("Forestry sapling/block null!");
        }
        block = GameRegistry.findBlock((String)name, (String)"soil");
        if (block != null) {
            plantableStandard = new ForestryBogEarth(block);
            MFRRegistry.registerPlantable(plantableStandard);
            MFRRegistry.registerFertilizable(plantableStandard);
            MFRRegistry.registerHarvestable((IFactoryHarvestable)((Object)plantableStandard));
            MFRRegistry.registerFruit((IFactoryFruit)((Object)plantableStandard));
        } else {
            MineFactoryReloadedCore.log().error("Forestry bog earth null!");
        }
        int n = 1;
        while (true) {
            if ((block = GameRegistry.findBlock((String)name, (String)("log" + n))) == null) {
                if (n > 1) {
                    MineFactoryReloadedCore.log().debug("Forestry logs null at " + n + ".");
                    break;
                }
                block = GameRegistry.findBlock((String)name, (String)"logs");
                if (block == null) {
                    MineFactoryReloadedCore.log().error("Forestry logs null!");
                    break;
                }
            }
            MFRRegistry.registerHarvestable(new HarvestableWood(block));
            MFRRegistry.registerFruitLogBlock(block);
            ++n;
        }
        n = 1;
        while (true) {
            if ((block = GameRegistry.findBlock((String)name, (String)("fireproofLog" + n))) == null) {
                if (n > 1) {
                    MineFactoryReloadedCore.log().debug("Forestry logs null at " + n + ".");
                    break;
                }
                block = GameRegistry.findBlock((String)name, (String)"logsFireproof");
                if (block == null) {
                    MineFactoryReloadedCore.log().error("Forestry logs null!");
                    break;
                }
            }
            MFRRegistry.registerHarvestable(new HarvestableWood(block));
            MFRRegistry.registerFruitLogBlock(block);
            ++n;
        }
        block = GameRegistry.findBlock((String)name, (String)"leaves");
        if (block != null) {
            ForestryLeaf forestryLeaf = new ForestryLeaf(block);
            MFRRegistry.registerFertilizable(forestryLeaf);
            MFRRegistry.registerHarvestable(forestryLeaf);
            MFRRegistry.registerFruit(forestryLeaf);
        } else {
            MineFactoryReloadedCore.log().error("Forestry leaves null!");
        }
        block = GameRegistry.findBlock((String)name, (String)"pods");
        item = GameRegistry.findItem((String)name, (String)"grafterProven");
        if (block != null) {
            ForestryPod forestryPod = new ForestryPod(block, item);
            MFRRegistry.registerFertilizable(forestryPod);
            MFRRegistry.registerHarvestable(forestryPod);
            MFRRegistry.registerFruit(forestryPod);
        } else {
            MineFactoryReloadedCore.log().error("Forestry pods null!");
        }
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        MFRRegistry.registerLiquidDrinkHandler("bioethanol", new DrinkHandlerBiofuel());
        TileEntityUnifier.updateUnifierLiquids();
    }
}

