/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.position.Area;
import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.core.HarvestMode;
import powercrystals.minefactoryreloaded.core.IHarvestManager;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.SideOffset;
import powercrystals.minefactoryreloaded.core.TreeHarvestManager;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiHarvester;
import powercrystals.minefactoryreloaded.gui.container.ContainerHarvester;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityHarvester
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private static boolean skip = false;
    private static Map<String, Boolean> DEFAULT_SETTINGS;
    private Map<String, Boolean> _settings;
    private Map<String, Boolean> _immutableSettings;
    private Random _rand;
    private IHarvestManager _treeManager;
    private BlockPosition _lastTree;

    public TileEntityHarvester() {
        super(Machine.Harvester);
        TileEntityHarvester.createHAM(this, 1);
        this.setManageSolids(true);
        this._settings = new HashMap<String, Boolean>();
        this._settings.putAll(DEFAULT_SETTINGS);
        this._immutableSettings = Collections.unmodifiableMap(this._settings);
        this._rand = new Random();
        this.setCanRotate(true);
        skip = MFRConfig.harvesterSkip.getBoolean(false);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this._treeManager != null) {
            this._treeManager.free();
        }
        this._lastTree = null;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            TileEntityHarvester.createHAM(this, 1);
            this.onFactoryInventoryChanged();
            if (this._treeManager != null && this._areaManager.getHarvestArea().contains(this._treeManager.getOrigin())) {
                this._treeManager.setWorld(this.field_145850_b);
            } else {
                this._treeManager = new TreeHarvestManager(this.field_145850_b, new Area(new BlockPosition((TileEntity)this), 0, 0, 0), HarvestMode.FruitTree, this._immutableSettings);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer var1) {
        return new GuiHarvester(this.getContainer(var1), this);
    }

    @Override
    public ContainerHarvester getContainer(InventoryPlayer var1) {
        return new ContainerHarvester(this, var1);
    }

    public Map<String, Boolean> getSettings() {
        return this._settings;
    }

    public Map<String, Boolean> getImmutableSettings() {
        return this._immutableSettings;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 5 + this.getExtraIdleTime(10);
    }

    protected int getExtraIdleTime(int var1) {
        return this._tanks[0].getFluidAmount() * var1 / this._tanks[0].getCapacity();
    }

    @Override
    public boolean activateMachine() {
        BlockPosition var1 = this.getNextHarvest();
        if (var1 == null) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        Block var2 = this.field_145850_b.func_147439_a(var1.x, var1.y, var1.z);
        int var3 = this.field_145850_b.func_72805_g(var1.x, var1.y, var1.z);
        IFactoryHarvestable var4 = MFRRegistry.getHarvestables().get(var2);
        List<ItemStack> var5 = var4.getDrops(this.field_145850_b, this._rand, this._immutableSettings, var1.x, var1.y, var1.z);
        var4.preHarvest(this.field_145850_b, var1.x, var1.y, var1.z);
        if (var5 instanceof ArrayList) {
            ForgeEventFactory.fireBlockHarvesting((ArrayList)((ArrayList)var5), (World)this.field_145850_b, (Block)var2, (int)var1.x, (int)var1.y, (int)var1.z, (int)var3, (int)0, (float)1.0f, (this._settings.get("silkTouch") == Boolean.TRUE ? 1 : 0) != 0, null);
        }
        if (var4.breakBlock()) {
            if (!this.field_145850_b.func_147465_d(var1.x, var1.y, var1.z, Blocks.field_150350_a, 0, 2)) {
                return false;
            }
            if (this._settings.get("playSounds") == Boolean.TRUE) {
                this.field_145850_b.func_72889_a(null, 2001, var1.x, var1.y, var1.z, Block.func_149682_b((Block)var2) + (var3 << 12));
            }
        }
        this.setIdleTicks(this.getExtraIdleTime(10));
        this.doDrop(var5);
        this._tanks[0].fill(FluidRegistry.getFluidStack((String)"sludge", (int)10), true);
        var4.postHarvest(this.field_145850_b, var1.x, var1.y, var1.z);
        return true;
    }

    private BlockPosition getNextHarvest() {
        int var2;
        if (!this._treeManager.getIsDone()) {
            return this.getNextTreeSegment(this._lastTree, false);
        }
        BlockPosition var1 = this._areaManager.getNextBlock();
        this._lastTree = null;
        if (skip && (var2 = this.getExtraIdleTime(10)) > 0 && var2 > this._rand.nextInt(15)) {
            return null;
        }
        if (!this.field_145850_b.func_72899_e(var1.x, var1.y, var1.z)) {
            return null;
        }
        Block var5 = this.field_145850_b.func_147439_a(var1.x, var1.y, var1.z);
        if (!MFRRegistry.getHarvestables().containsKey(var5)) {
            this._lastTree = null;
            return null;
        }
        this._settings.put("isHarvestingTree", Boolean.FALSE);
        IFactoryHarvestable var3 = MFRRegistry.getHarvestables().get(var5);
        HarvestType var4 = var3.getHarvestType();
        if (var4 == HarvestType.Gourd || var3.canBeHarvested(this.field_145850_b, this._immutableSettings, var1.x, var1.y, var1.z)) {
            switch (var4) {
                case Gourd: {
                    return this.getNextAdjacent(var1.x, var1.y, var1.z, var3);
                }
                case Column: 
                case LeaveBottom: {
                    return this.getNextVertical(var1.x, var1.y, var1.z, var4 == HarvestType.Column ? 0 : 1, var3);
                }
                case Tree: 
                case TreeFlipped: 
                case TreeLeaf: {
                    return this.getNextTreeSegment(var1, var4 == HarvestType.TreeFlipped);
                }
                case TreeFruit: 
                case Normal: {
                    return var1;
                }
            }
        }
        return null;
    }

    private BlockPosition getNextAdjacent(int var1, int var2, int var3, IFactoryHarvestable var4) {
        for (SideOffset var8 : SideOffset.SIDES) {
            int var9 = var1 + var8.offsetX;
            int var10 = var2 + var8.offsetY;
            int var11 = var3 + var8.offsetX;
            if (!this.field_145850_b.func_72899_e(var9, var10, var11) || !var4.canBeHarvested(this.field_145850_b, this._immutableSettings, var9, var10, var11)) continue;
            return new BlockPosition(var9, var10, var11);
        }
        return null;
    }

    private BlockPosition getNextVertical(int var1, int var2, int var3, int var4, IFactoryHarvestable var5) {
        Block var10;
        int var6 = -1;
        int var7 = MFRConfig.verticalHarvestSearchMaxVertical.getInt();
        Block var8 = var5.getPlant();
        int var9 = var4;
        while (var9 < var7 && (var10 = this.field_145850_b.func_147439_a(var1, var2 + var9, var3)).equals(var8) && var5.canBeHarvested(this.field_145850_b, this._immutableSettings, var1, var2 + var9, var3)) {
            var6 = var9++;
        }
        return var6 >= 0 ? new BlockPosition(var1, var2 + var6, var3) : null;
    }

    private BlockPosition getNextTreeSegment(BlockPosition var1, boolean var2) {
        this._settings.put("isHarvestingTree", Boolean.TRUE);
        if (!var1.equals(this._lastTree) || this._treeManager.getIsDone()) {
            int var4 = 0;
            int var5 = MFRConfig.treeSearchMaxVertical.getInt();
            if (var2) {
                var4 = var5;
                var5 = 0;
            }
            this._lastTree = new BlockPosition(var1);
            Area var6 = new Area(this._lastTree, MFRConfig.treeSearchMaxHorizontal.getInt(), var4, var5);
            this._treeManager.reset(this.field_145850_b, var6, var2 ? HarvestMode.HarvestTreeInverted : HarvestMode.HarvestTree, this._immutableSettings);
        }
        Map<Block, IFactoryHarvestable> var8 = MFRRegistry.getHarvestables();
        while (!this._treeManager.getIsDone()) {
            IFactoryHarvestable var10;
            HarvestType var7;
            BlockPosition var9 = this._treeManager.getNextBlock();
            this._treeManager.moveNext();
            if (!this.field_145850_b.func_72899_e(var9.x, var9.y, var9.z)) {
                return null;
            }
            Block var3 = this.field_145850_b.func_147439_a(var9.x, var9.y, var9.z);
            if (!var8.containsKey(var3) || !((var7 = (var10 = var8.get(var3)).getHarvestType()) == HarvestType.Tree | var7 == HarvestType.TreeFlipped | var7 == HarvestType.TreeLeaf | var7 == HarvestType.TreeFruit) || !var10.canBeHarvested(this.field_145850_b, this._immutableSettings, var9.x, var9.y, var9.z)) continue;
            return var9;
        }
        return null;
    }

    @Override
    public boolean allowBucketDrain(ItemStack var1) {
        return true;
    }

    public int fill(ForgeDirection var1, FluidStack var2, boolean var3) {
        return 0;
    }

    public FluidStack drain(ForgeDirection var1, int var2, boolean var3) {
        return this.drain(var2, var3);
    }

    public FluidStack drain(ForgeDirection var1, FluidStack var2, boolean var3) {
        return this.drain(var2, var3);
    }

    @Override
    protected FluidTankAdv[] createTanks() {
        return new FluidTankAdv[]{new FluidTankAdv(4000)};
    }

    @Override
    public void writePortableData(EntityPlayer var1, NBTTagCompound var2) {
        NBTTagCompound var3 = new NBTTagCompound();
        for (Map.Entry<String, Boolean> var5 : this._settings.entrySet()) {
            String var6 = var5.getKey();
            if ("playSounds" == var6 || "isHarvestingTree" == var6) continue;
            var3.func_74757_a(var6, var5.getValue() == Boolean.TRUE);
        }
        var2.func_74782_a("harvesterSettings", (NBTBase)var3);
    }

    @Override
    public void readPortableData(EntityPlayer var1, NBTTagCompound var2) {
        NBTTagCompound var3 = (NBTTagCompound)var2.func_74781_a("harvesterSettings");
        if (var3 != null) {
            for (String var5 : this._settings.keySet()) {
                if ("playSounds".equals(var5)) continue;
                boolean var6 = var3.func_74767_n(var5);
                this._settings.put(var5.intern(), var6);
            }
        }
    }

    @Override
    public void writeItemNBT(NBTTagCompound var1) {
        super.writeItemNBT(var1);
        NBTTagCompound var2 = new NBTTagCompound();
        for (Map.Entry<String, Boolean> var4 : this._settings.entrySet()) {
            String var5 = var4.getKey();
            if ("playSounds" == var5 | "isHarvestingTree" == var5 || DEFAULT_SETTINGS.get(var5) == var4.getValue()) continue;
            var2.func_74757_a(var5, var4.getValue() == Boolean.TRUE);
        }
        if (!var2.func_82582_d()) {
            var1.func_74782_a("harvesterSettings", (NBTBase)var2);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound var1) {
        super.func_145841_b(var1);
        if (this._treeManager != null) {
            this._treeManager.writeToNBT(var1);
        }
        if (this._areaManager != null) {
            var1.func_74768_a("bpos", this._areaManager.getPosition());
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound var1) {
        super.func_145839_a(var1);
        NBTTagCompound var2 = (NBTTagCompound)var1.func_74781_a("harvesterSettings");
        if (var2 != null) {
            for (String var4 : this._settings.keySet()) {
                if ("playSounds".equals(var4)) continue;
                boolean var5 = var2.func_74767_n(var4);
                this._settings.put(var4.intern(), var5);
            }
        }
        if (this._treeManager != null) {
            this._treeManager.free();
        }
        this._treeManager = new TreeHarvestManager(var1, this._immutableSettings);
        if (!this._treeManager.getIsDone()) {
            this._lastTree = this._treeManager.getOrigin();
        }
        this._areaManager.getHarvestArea();
        this._areaManager.setPosition(var1.func_74762_e("bpos"));
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public int getStartInventorySide(ForgeDirection var1) {
        return 0;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection var1) {
        return 0;
    }

    public boolean canFill(ForgeDirection var1, Fluid var2) {
        return false;
    }

    public boolean canDrain(ForgeDirection var1, Fluid var2) {
        return true;
    }

    @Override
    public int getUpgradeSlot() {
        return 0;
    }

    @Override
    public boolean func_102007_a(int var1, ItemStack var2, int var3) {
        return var1 == 0 && this.isUsableAugment(var2);
    }

    @Override
    public boolean func_102008_b(int var1, ItemStack var2, int var3) {
        return false;
    }

    static {
        HashMap<String, Boolean> var0 = new HashMap<String, Boolean>();
        var0.put("silkTouch", Boolean.FALSE);
        var0.put("harvestSmallMushrooms", Boolean.FALSE);
        var0.put("playSounds", MFRConfig.playSounds.getBoolean(true));
        var0.put("isHarvestingTree", Boolean.FALSE);
        DEFAULT_SETTINGS = Collections.unmodifiableMap(var0);
    }
}

