/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.rednet;

import appeng.api.implementations.tiles.ICrankable;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.energy.IEnergyTransport;
import cofh.asm.relauncher.Strippable;
import cofh.lib.util.position.BlockPosition;
import cofh.repack.codechicken.lib.raytracer.IndexedCuboid6;
import cofh.repack.codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.block.transport.BlockRedNetCable;
import powercrystals.minefactoryreloaded.core.IGridController;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.net.Packets;
import powercrystals.minefactoryreloaded.tile.rednet.RedstoneEnergyNetwork;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetCable;

@Strippable(value={"appeng.api.implementations.tiles.ICrankable"})
public class TileEntityRedNetEnergy
extends TileEntityRedNetCable
implements IEnergyTransport,
ICrankable {
    private static boolean IC2Classes = false;
    private static boolean IC2Net = false;
    private byte[] sideMode = new byte[]{1, 1, 1, 1, 1, 1, 0};
    private IEnergyTransport.InterfaceType[] transportTypes = null;
    private IEnergyReceiver[] receiverCache = null;
    private IEnergyProvider[] providerCache = null;
    private IC2Cache ic2Cache = null;
    private boolean deadCache = false;
    private boolean readFromNBT = false;
    boolean isNode = false;
    int energyForGrid = 0;
    RedstoneEnergyNetwork _grid;

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.deadCache = true;
        this.receiverCache = null;
        this.providerCache = null;
        this.ic2Cache = null;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
    }

    @Override
    public void func_145843_s() {
        if (this._grid != null) {
            this.removeFromGrid();
        }
        super.func_145843_s();
    }

    private void removeFromGrid() {
        this._grid.removeConduit(this);
        this._grid.storage.modifyEnergyStored(-this.energyForGrid);
        this.markForRegen();
        this.deadCache = true;
        this._grid = null;
    }

    private void markForRegen() {
        int n = 0;
        int n2 = 6;
        while (n2-- > 0) {
            if (this.sideMode[n2] != 9) continue;
            ++n;
        }
        if (n > 1) {
            this._grid.regenerate();
        }
    }

    private void reCache() {
        if (this.deadCache) {
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                if (!BlockPosition.blockExists((TileEntity)this, (ForgeDirection)forgeDirection)) continue;
                this.addCache(BlockPosition.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)forgeDirection));
            }
            this.deadCache = false;
            RedstoneEnergyNetwork.HANDLER.addConduitForUpdate(this);
        }
    }

    @Override
    public void cofh_validate() {
        super.cofh_validate();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this._grid == null) {
            this.incorporateTiles();
            if (this._grid == null) {
                this.setGrid(new RedstoneEnergyNetwork(this));
            }
        }
        this.readFromNBT = true;
        this.reCache();
        this.func_70296_d();
        Packets.sendToAllPlayersWatching(this);
    }

    private void incorporateTiles() {
        if (this._grid == null) {
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                TileEntityRedNetEnergy tileEntityRedNetEnergy;
                if (this.readFromNBT && (this.sideMode[forgeDirection.getOpposite().ordinal()] & 1) == 0 || !BlockPosition.blockExists((TileEntity)this, (ForgeDirection)forgeDirection) || (tileEntityRedNetEnergy = (TileEntityRedNetEnergy)BlockPosition.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)forgeDirection, TileEntityRedNetEnergy.class)) == null || tileEntityRedNetEnergy._grid == null || !tileEntityRedNetEnergy.canInterface(this, forgeDirection)) continue;
                tileEntityRedNetEnergy._grid.addConduit(this);
            }
        }
    }

    public boolean canInterface(TileEntityRedNetEnergy tileEntityRedNetEnergy, ForgeDirection forgeDirection) {
        return (this.sideMode[forgeDirection.ordinal()] & 1) != 0;
    }

    @Override
    public void onNeighborTileChange(int n, int n2, int n3) {
        TileEntity tileEntity;
        if (this.field_145850_b.field_72995_K | this.deadCache) {
            return;
        }
        TileEntity tileEntity2 = tileEntity = this.field_145850_b.func_72899_e(n, n2, n3) ? this.field_145850_b.func_147438_o(n, n2, n3) : null;
        if (n < this.field_145851_c) {
            this.addCache(tileEntity, 5);
        } else if (n > this.field_145851_c) {
            this.addCache(tileEntity, 4);
        } else if (n3 < this.field_145849_e) {
            this.addCache(tileEntity, 3);
        } else if (n3 > this.field_145849_e) {
            this.addCache(tileEntity, 2);
        } else if (n2 < this.field_145848_d) {
            this.addCache(tileEntity, 1);
        } else if (n2 > this.field_145848_d) {
            this.addCache(tileEntity, 0);
        }
    }

    private void addCache(TileEntity tileEntity) {
        if (tileEntity == null) {
            return;
        }
        int n = tileEntity.field_145851_c;
        int n2 = tileEntity.field_145848_d;
        int n3 = tileEntity.field_145849_e;
        if (n < this.field_145851_c) {
            this.addCache(tileEntity, 5);
        } else if (n > this.field_145851_c) {
            this.addCache(tileEntity, 4);
        } else if (n3 < this.field_145849_e) {
            this.addCache(tileEntity, 3);
        } else if (n3 > this.field_145849_e) {
            this.addCache(tileEntity, 2);
        } else if (n2 < this.field_145848_d) {
            this.addCache(tileEntity, 1);
        } else if (n2 > this.field_145848_d) {
            this.addCache(tileEntity, 0);
        }
    }

    private void addCache(TileEntity tileEntity, int n) {
        if (this.receiverCache != null) {
            this.receiverCache[n] = null;
        }
        if (this.providerCache != null) {
            this.providerCache[n] = null;
        }
        if (this.ic2Cache != null) {
            this.ic2Cache.erase(n);
        }
        byte by = this.sideMode[n];
        int n2 = n;
        this.sideMode[n2] = (byte)(this.sideMode[n2] & 1);
        if (tileEntity instanceof TileEntityRedNetEnergy) {
            TileEntityRedNetEnergy tileEntityRedNetEnergy = (TileEntityRedNetEnergy)tileEntity;
            int n3 = n;
            this.sideMode[n3] = (byte)(this.sideMode[n3] | 8);
            if (tileEntityRedNetEnergy.canInterface(this, ForgeDirection.getOrientation((int)(n ^ 1)))) {
                if (this._grid == null && tileEntityRedNetEnergy._grid != null) {
                    tileEntityRedNetEnergy._grid.addConduit(this);
                }
                if (tileEntityRedNetEnergy._grid == this._grid || this._grid.addConduit(tileEntityRedNetEnergy)) {
                    int n4 = n;
                    this.sideMode[n4] = (byte)(this.sideMode[n4] | 1);
                }
            } else {
                int n5 = n;
                this.sideMode[n5] = (byte)(this.sideMode[n5] & 0xFFFFFFFE);
            }
        } else if (tileEntity instanceof IEnergyConnection) {
            if (((IEnergyConnection)tileEntity).canConnectEnergy(ForgeDirection.VALID_DIRECTIONS[n])) {
                if (tileEntity instanceof IEnergyTransport) {
                    IEnergyTransport iEnergyTransport = (IEnergyTransport)tileEntity;
                    IEnergyTransport.InterfaceType interfaceType = iEnergyTransport.getTransportState(ForgeDirection.getOrientation((int)n)).getOpposite();
                    if (interfaceType != IEnergyTransport.InterfaceType.BALANCE) {
                        this.createTransportTypes();
                        this.transportTypes[n] = interfaceType;
                    }
                    int n6 = n;
                    this.sideMode[n6] = (byte)(this.sideMode[n6] | 4);
                } else {
                    int n7 = n;
                    this.sideMode[n7] = (byte)(this.sideMode[n7] | 2);
                    if (this.transportTypes != null) {
                        this.transportTypes[n] = IEnergyTransport.InterfaceType.BALANCE;
                    }
                }
                if (tileEntity instanceof IEnergyReceiver) {
                    if (this.receiverCache == null) {
                        this.receiverCache = new IEnergyReceiver[6];
                    }
                    this.receiverCache[n] = (IEnergyReceiver)tileEntity;
                }
                if (tileEntity instanceof IEnergyProvider) {
                    if (this.providerCache == null) {
                        this.providerCache = new IEnergyProvider[6];
                    }
                    this.providerCache[n] = (IEnergyProvider)tileEntity;
                }
            }
        } else if (this.checkIC2Tiles(tileEntity, n)) {
            // empty if block
        }
        if (!this.deadCache && by != this.sideMode[n]) {
            RedstoneEnergyNetwork.HANDLER.addConduitForUpdate(this);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void createTransportTypes() {
        this.transportTypes = new IEnergyTransport.InterfaceType[6];
        int n = this.transportTypes.length;
        while (n-- > 0) {
            this.transportTypes[n] = IEnergyTransport.InterfaceType.BALANCE;
        }
    }

    private boolean checkIC2Tiles(TileEntity tileEntity, int n) {
        if (!IC2Classes) {
            return false;
        }
        if (this.ic2Cache == null) {
            this.ic2Cache = new IC2Cache();
        }
        return this.ic2Cache.add(tileEntity, n);
    }

    @Override
    public Packet func_145844_m() {
        if (this.deadCache) {
            return null;
        }
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74783_a("colors", this._sideColors);
        nBTTagCompound.func_74768_a("mode[0]", this._cableMode[0] & 0xFF | (this._cableMode[1] & 0xFF) << 8 | (this._cableMode[2] & 0xFF) << 16 | (this._cableMode[3] & 0xFF) << 24);
        nBTTagCompound.func_74768_a("mode[1]", this._cableMode[4] & 0xFF | (this._cableMode[5] & 0xFF) << 8 | (this._cableMode[6] & 0xFF) << 16);
        nBTTagCompound.func_74768_a("mode[2]", this.sideMode[0] & 0xFF | (this.sideMode[1] & 0xFF) << 8 | (this.sideMode[2] & 0xFF) << 16 | (this.sideMode[3] & 0xFF) << 24);
        nBTTagCompound.func_74768_a("mode[3]", this.sideMode[4] & 0xFF | (this.sideMode[5] & 0xFF) << 8 | (this.sideMode[6] & 0xFF) << 16);
        nBTTagCompound.func_74768_a("state[0]", this._connectionState[0].ordinal() | this._connectionState[1].ordinal() << 4 | this._connectionState[2].ordinal() << 8 | this._connectionState[3].ordinal() << 12 | this._connectionState[4].ordinal() << 16 | this._connectionState[5].ordinal() << 20);
        S35PacketUpdateTileEntity s35PacketUpdateTileEntity = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nBTTagCompound);
        return s35PacketUpdateTileEntity;
    }

    @Override
    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity s35PacketUpdateTileEntity) {
        super.onDataPacket(networkManager, s35PacketUpdateTileEntity);
        NBTTagCompound nBTTagCompound = s35PacketUpdateTileEntity.func_148857_g();
        switch (s35PacketUpdateTileEntity.func_148853_f()) {
            case 0: {
                int n = nBTTagCompound.func_74762_e("mode[2]");
                this.sideMode[0] = (byte)(n & 0xFF);
                this.sideMode[1] = (byte)(n >> 8 & 0xFF);
                this.sideMode[2] = (byte)(n >> 16 & 0xFF);
                this.sideMode[3] = (byte)(n >> 24 & 0xFF);
                n = nBTTagCompound.func_74762_e("mode[3]");
                this.sideMode[4] = (byte)(n & 0xFF);
                this.sideMode[5] = (byte)(n >> 8 & 0xFF);
                this.sideMode[6] = (byte)(n >> 16 & 0xFF);
            }
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public void setModes(byte[] byArray) {
        this.sideMode = byArray;
    }

    public int receiveEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return 0;
        }
        if ((this.sideMode[forgeDirection.ordinal() ^ 1] & 1) != 0 & this._grid != null) {
            return this._grid.storage.receiveEnergy(n, bl);
        }
        return 0;
    }

    public int extractEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return 0;
    }

    public boolean canConnectEnergy(ForgeDirection forgeDirection) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return false;
        }
        return (this.sideMode[forgeDirection.ordinal() ^ 1] & 1) != 0 & this._grid != null;
    }

    public int getEnergyStored(ForgeDirection forgeDirection) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return 0;
        }
        if ((this.sideMode[forgeDirection.ordinal() ^ 1] & 1) != 0 & this._grid != null) {
            return this._grid.storage.getEnergyStored();
        }
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return 0;
        }
        if ((this.sideMode[forgeDirection.ordinal() ^ 1] & 1) != 0 & this._grid != null) {
            return this._grid.storage.getMaxEnergyStored();
        }
        return 0;
    }

    public IEnergyTransport.InterfaceType getTransportState(ForgeDirection forgeDirection) {
        if (this.transportTypes != null) {
            return this.transportTypes[forgeDirection.ordinal() ^ 1];
        }
        return IEnergyTransport.InterfaceType.BALANCE;
    }

    public boolean setTransportState(IEnergyTransport.InterfaceType interfaceType, ForgeDirection forgeDirection) {
        if (this.sideMode[forgeDirection.ordinal() ^ 1] >> 1 == 1 || !this.isInterfacing(forgeDirection)) {
            return false;
        }
        if (this.transportTypes == null) {
            this.createTransportTypes();
        }
        this.transportTypes[forgeDirection.ordinal() ^ 1] = interfaceType;
        return true;
    }

    public boolean canTurn() {
        return this._grid.storage.getEnergyStored() < this._grid.storage.getMaxEnergyStored();
    }

    public void applyTurn() {
        this._grid.storage.receiveEnergy(90, false);
    }

    public boolean canCrankAttach(ForgeDirection forgeDirection) {
        return true;
    }

    public boolean isInterfacing(ForgeDirection forgeDirection) {
        int n = forgeDirection.getOpposite().ordinal();
        int n2 = this.sideMode[n] >> 1;
        return (this.sideMode[n] & 1) != 0 & n2 != 0;
    }

    public int interfaceMode(ForgeDirection forgeDirection) {
        int n = forgeDirection.getOpposite().ordinal();
        int n2 = this.sideMode[n] >> 1;
        return (this.sideMode[n] & 1) != 0 ? n2 : 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.sideMode = nBTTagCompound.func_74770_j("SideMode");
        if (this.sideMode.length != 7) {
            this.sideMode = new byte[]{1, 1, 1, 1, 1, 1, 0};
        }
        this.energyForGrid = nBTTagCompound.func_74762_e("Energy");
        this.readFromNBT = true;
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74773_a("SideMode", this.sideMode);
        if (this._grid != null && this.isNode) {
            this.energyForGrid = this._grid.getNodeShare(this);
        }
        if (this.energyForGrid > 0) {
            nBTTagCompound.func_74768_a("Energy", this.energyForGrid);
        } else {
            this.energyForGrid = 0;
        }
    }

    void extract(ForgeDirection forgeDirection, EnergyStorage energyStorage) {
        if (this.deadCache) {
            return;
        }
        int n = forgeDirection.ordinal();
        if ((this.sideMode[n] & 1) != 0) {
            switch (this.sideMode[n] >> 1) {
                case 1: {
                    int n2;
                    IEnergyProvider iEnergyProvider;
                    if (this.providerCache == null || (iEnergyProvider = this.providerCache[n]) == null || (n2 = iEnergyProvider.extractEnergy(forgeDirection, 2560, true)) <= 0) break;
                    iEnergyProvider.extractEnergy(forgeDirection, energyStorage.receiveEnergy(n2, false), false);
                    break;
                }
                case 2: {
                    int n3;
                    IEnergyProvider iEnergyProvider;
                    IEnergyTransport.InterfaceType interfaceType = this.getTransportState(forgeDirection);
                    if (this.providerCache == null || interfaceType != IEnergyTransport.InterfaceType.RECEIVE || (iEnergyProvider = this.providerCache[n]) == null || (n3 = iEnergyProvider.extractEnergy(forgeDirection, 2560, true)) <= 0) break;
                    iEnergyProvider.extractEnergy(forgeDirection, energyStorage.receiveEnergy(n3, false), false);
                    break;
                }
                case 3: {
                    if (this.ic2Cache == null) break;
                    this.ic2Cache.extract(n);
                    break;
                }
            }
        }
    }

    int transfer(ForgeDirection forgeDirection, int n) {
        if (this.deadCache) {
            return 0;
        }
        int n2 = forgeDirection.ordinal();
        if ((this.sideMode[n2] & 1) != 0) {
            switch (this.sideMode[n2] >> 1) {
                case 1: {
                    IEnergyReceiver iEnergyReceiver;
                    if (this.receiverCache == null || (iEnergyReceiver = this.receiverCache[n2]) == null) break;
                    return iEnergyReceiver.receiveEnergy(forgeDirection, n, false);
                }
                case 2: {
                    IEnergyReceiver iEnergyReceiver;
                    IEnergyTransport.InterfaceType interfaceType = this.getTransportState(forgeDirection);
                    if (this.receiverCache == null || interfaceType == IEnergyTransport.InterfaceType.RECEIVE || (iEnergyReceiver = this.receiverCache[n2]) == null || interfaceType != IEnergyTransport.InterfaceType.SEND && iEnergyReceiver.getEnergyStored(forgeDirection) >= this._grid.storage.getEnergyStored()) break;
                    return iEnergyReceiver.receiveEnergy(forgeDirection, n, false);
                }
                case 3: {
                    if (this.ic2Cache == null) break;
                    return this.ic2Cache.transmit(n, forgeDirection, n2);
                }
            }
        }
        return 0;
    }

    void setGrid(RedstoneEnergyNetwork redstoneEnergyNetwork) {
        this._grid = redstoneEnergyNetwork;
    }

    @Override
    public void updateInternalTypes(IGridController iGridController) {
        super.updateInternalTypes(iGridController);
        if (this.deadCache) {
            return;
        }
        if (iGridController != RedstoneEnergyNetwork.HANDLER) {
            return;
        }
        this.isNode = false;
        for (int i = 0; i < 6; ++i) {
            int n;
            if (!((this.sideMode[i] & 1) != 0 & (n = this.sideMode[i] >> 1) != 0 & n != 4)) continue;
            this.isNode = true;
        }
        if (this._grid != null) {
            this._grid.addConduit(this);
        }
        Packets.sendToAllPlayersWatching(this);
    }

    @Override
    public boolean onPartHit(EntityPlayer entityPlayer, int n, int n2) {
        if (n2 >= 26 && n2 < 38 && MFRUtil.isHoldingUsableTool(entityPlayer, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            if (!entityPlayer.field_70170_p.field_72995_K) {
                int n3 = ForgeDirection.OPPOSITES[n];
                if (this.sideMode[n3] == 9) {
                    this.removeFromGrid();
                }
                int n4 = n3;
                this.sideMode[n4] = (byte)(this.sideMode[n4] ^ 1);
                this.func_70296_d();
                if (this.sideMode[n3] == 8) {
                    this.deadCache = true;
                    this.reCache();
                    if (this._grid == null) {
                        this.setGrid(new RedstoneEnergyNetwork(this));
                    }
                }
                RedstoneEnergyNetwork.HANDLER.addConduitForUpdate(this);
                Packets.sendToAllPlayersWatching(this);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void addTraceableCuboids(List<IndexedCuboid6> var1_1, boolean var2_2, boolean var3_3) {
        var4_4 = new Vector3((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        var5_5 = new IndexedCuboid6((Object)0, BlockRedNetCable.subSelection[1]);
        var1_1.add(var5_5);
        var6_6 = ForgeDirection.VALID_DIRECTIONS;
        var7_7 = ForgeDirection.OPPOSITES;
        var8_8 = var6_6.length;
        while (var8_8-- > 0) {
            block12: {
                block10: {
                    block11: {
                        var9_9 = this.getConnectionState(var6_6[var8_8], true);
                        var10_10 = this.sideMode[var7_7[var8_8]];
                        var11_11 = var10_10 > 1 & ((var10_10 & 1) == 1 | var3_3);
                        var13_13 = var12_12 = 2 + var8_8;
                        if (!var9_9.isConnected) break block10;
                        if (!var9_9.isPlate) break block11;
                        var12_12 += 6;
                        ** GOTO lbl-1000
                    }
                    if (var9_9.isCable && var9_9.isAllSubnets) {
                        if (var11_11 == false | var3_3 == false) {
                            var12_12 = 20 + var8_8;
                        }
                        var1_1.add((IndexedCuboid6)new IndexedCuboid6((Object)(var3_3 != false ? var13_13 + 36 : 1), BlockRedNetCable.subSelection[var12_12]).add(var4_4));
                    } else lbl-1000:
                    // 2 sources

                    {
                        var13_13 = 20 + var8_8;
                        if (var11_11) {
                            var13_13 += var2_2 != false ? 6 : 12;
                        }
                        var1_1.add((IndexedCuboid6)new IndexedCuboid6((Object)((var11_11 & var3_3) != false ? var13_13 : 1), BlockRedNetCable.subSelection[var13_13]).add(var4_4));
                        var1_1.add((IndexedCuboid6)new IndexedCuboid6((Object)var12_12, BlockRedNetCable.subSelection[var12_12]).add(var4_4));
                        var12_12 = 14 + var8_8;
                        if (var9_9.isSingleSubnet) {
                            var1_1.add((IndexedCuboid6)new IndexedCuboid6((Object)var12_12, BlockRedNetCable.subSelection[var12_12]).add(var4_4));
                        }
                        var11_11 = false;
                    }
                    break block12;
                }
                if (var2_2 & var3_3 & this._cableMode[6] != 1) {
                    var9_9 = this.getConnectionState(var6_6[var8_8], false);
                    if (var9_9.isConnected) {
                        if (var9_9.isAllSubnets & var9_9.isCable) {
                            if (!var11_11) {
                                var13_13 += 18;
                            }
                            var12_12 += 36;
                        }
                        var1_1.add((IndexedCuboid6)new IndexedCuboid6((Object)var12_12, BlockRedNetCable.subSelection[var13_13]).add(var4_4));
                    }
                }
            }
            if (!var11_11) continue;
            var12_12 = 32 + var8_8;
            var1_1.add((IndexedCuboid6)new IndexedCuboid6((Object)(var3_3 != false ? var12_12 : 1), BlockRedNetCable.subSelection[var12_12]).add(var4_4));
        }
        var5_5.add(var4_4);
    }

    @Override
    public void getTileInfo(List<IChatComponent> list, ForgeDirection forgeDirection, EntityPlayer entityPlayer, boolean bl) {
        list.add(this.text("-Redstone-"));
        super.getTileInfo(list, forgeDirection, entityPlayer, bl && entityPlayer.func_70093_af());
        list.add(this.text("-Energy-"));
        if (this._grid != null) {
            if (!bl) {
                float f = 0.0f;
                if (this._grid.getNodeCount() != 0) {
                    f = (float)(Math.ceil((float)this._grid.storage.getEnergyStored() / (float)this._grid.storage.getMaxEnergyStored() * 1000.0f) / 10.0);
                }
                list.add(this.text("Saturation: " + f));
            }
        } else if (!bl) {
            list.add(this.text("Null Grid"));
        }
        if (bl) {
            if (this._grid != null) {
                list.add(this.text("Grid:" + this._grid));
                list.add(this.text("Conduits: " + this._grid.getConduitCount() + ", Nodes: " + this._grid.getNodeCount()));
                list.add(this.text("Grid Max: " + this._grid.storage.getMaxEnergyStored() + ", Grid Cur: " + this._grid.storage.getEnergyStored()));
                list.add(this.text("Caches: (RF, EU):({" + Arrays.toString(this.receiverCache) + "," + Arrays.toString(this.providerCache) + "}, " + this.ic2Cache + ")"));
            } else {
                list.add(this.text("Null Grid"));
            }
            list.add(this.text("SideType: " + Arrays.toString(this.sideMode)));
            list.add(this.text("Node: " + this.isNode + ", Energy: " + this.energyForGrid));
            return;
        }
    }

    static {
        try {
            Class.forName("ic2.api.energy.tile.IEnergySource");
            Class.forName("ic2.api.energy.tile.IEnergySink");
            IC2Classes = true;
            Class.forName("ic2.api.energy.EnergyNet");
            IC2Net = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class IC2Cache {
        IEnergySource[] sourceCache = null;
        IEnergySink[] sinkCache = null;

        private IC2Cache() {
        }

        void erase(int n) {
            if (this.sourceCache != null) {
                this.sourceCache[n] = null;
            }
            if (this.sinkCache != null) {
                this.sinkCache[n] = null;
            }
        }

        public boolean add(TileEntity tileEntity, int n) {
            boolean bl = false;
            if (tileEntity instanceof IEnergyTile) {
                ForgeDirection forgeDirection = ForgeDirection.VALID_DIRECTIONS[n];
                if (tileEntity instanceof IEnergySource && ((IEnergySource)tileEntity).emitsEnergyTo((TileEntity)TileEntityRedNetEnergy.this, forgeDirection)) {
                    if (this.sourceCache == null) {
                        this.sourceCache = new IEnergySource[6];
                    }
                    this.sourceCache[n] = (IEnergySource)tileEntity;
                    byte[] byArray = TileEntityRedNetEnergy.this.sideMode;
                    int n2 = n;
                    byArray[n2] = (byte)(byArray[n2] | 6);
                    bl = true;
                }
                if (tileEntity instanceof IEnergySink && ((IEnergySink)tileEntity).acceptsEnergyFrom((TileEntity)TileEntityRedNetEnergy.this, forgeDirection)) {
                    if (this.sinkCache == null) {
                        this.sinkCache = new IEnergySink[6];
                    }
                    this.sinkCache[n] = (IEnergySink)tileEntity;
                    byte[] byArray = TileEntityRedNetEnergy.this.sideMode;
                    int n3 = n;
                    byArray[n3] = (byte)(byArray[n3] | 6);
                    bl = true;
                }
            }
            return bl;
        }

        void extract(int n) {
            if (this.sourceCache != null) {
                IEnergySource iEnergySource = this.sourceCache[n];
                if (iEnergySource == null) {
                    return;
                }
                int n2 = Math.min((int)(iEnergySource.getOfferedEnergy() * 4.0), 2560);
                if (n2 > 0 && (n2 = TileEntityRedNetEnergy.this._grid.storage.receiveEnergy(n2, false)) > 0) {
                    iEnergySource.drawEnergy((double)((float)n2 / 4.0f));
                }
            }
        }

        int transmit(int n, ForgeDirection forgeDirection, int n2) {
            if (this.sinkCache != null) {
                IEnergySink iEnergySink = this.sinkCache[n2];
                if (iEnergySink == null) {
                    return 0;
                }
                int n3 = (int)Math.min(this.getPowerFromTier(iEnergySink.getSinkTier()) * 4.0, (double)n);
                n3 = Math.min((int)(iEnergySink.getDemandedEnergy() * 4.0), n3);
                if (n3 > 0) {
                    float f = (float)n3 / 4.0f;
                    return n3 -= (int)Math.ceil(iEnergySink.injectEnergy(forgeDirection, (double)f, this.getPowerFromTier(this.getTierFromPower(f))) * 4.0);
                }
            }
            return 0;
        }

        private double getPowerFromTier(int n) {
            if (IC2Net) {
                return this.getPower(n);
            }
            return n * 32;
        }

        private double getPower(int n) {
            if (EnergyNet.instance != null) {
                return EnergyNet.instance.getPowerFromTier(n);
            }
            return n * 32;
        }

        private int getTierFromPower(double d) {
            if (IC2Net) {
                return this.getTier(d);
            }
            return 1;
        }

        private int getTier(double d) {
            if (EnergyNet.instance != null) {
                return EnergyNet.instance.getTierFromPower(d);
            }
            return 1;
        }

        public String toString() {
            return "{Source:" + Arrays.toString(this.sourceCache) + ", Sink:" + Arrays.toString(this.sinkCache) + "}";
        }
    }
}

