/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.mekanism.handlers;

import java.util.HashMap;
import java.util.Map;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ChemicalPairInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.ChemicalInfuserRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IngredientAny;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.mekanism.MekanismHelper;
import modtweaker2.mods.mekanism.gas.IGasStack;
import modtweaker2.mods.mekanism.gas.MCGasStack;
import modtweaker2.mods.mekanism.util.AddMekanismRecipe;
import modtweaker2.mods.mekanism.util.RemoveMekanismRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.chemical.Infuser")
public class ChemicalInfuser {
    public static final String name = "Mekanism Infuser";

    @ZenMethod
    public static void addRecipe(IGasStack leftGasInput, IGasStack rightGasInput, IGasStack gasOutput) {
        if (leftGasInput == null || rightGasInput == null || gasOutput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        ChemicalInfuserRecipe recipe = new ChemicalInfuserRecipe(MekanismHelper.toGas(leftGasInput), MekanismHelper.toGas(rightGasInput), MekanismHelper.toGas(gasOutput));
        MineTweakerAPI.apply((IUndoableAction)new AddMekanismRecipe(name, (Map<MachineInput, MachineRecipe>)RecipeHandler.Recipe.CHEMICAL_INFUSER.get(), (MachineRecipe)recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient gasOutput, @Optional IIngredient leftGasInput, @Optional IIngredient rightGasInput) {
        if (gasOutput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (leftGasInput == null) {
            leftGasInput = IngredientAny.INSTANCE;
        }
        if (rightGasInput == null) {
            rightGasInput = IngredientAny.INSTANCE;
        }
        HashMap<MachineInput, MachineRecipe> recipes = new HashMap<MachineInput, MachineRecipe>();
        for (Map.Entry entry : RecipeHandler.Recipe.CHEMICAL_INFUSER.get().entrySet()) {
            MCGasStack inputGasLeft = new MCGasStack(((ChemicalPairInput)entry.getKey()).leftGas);
            MCGasStack inputGasRight = new MCGasStack(((ChemicalPairInput)entry.getKey()).rightGas);
            MCGasStack outputGas = new MCGasStack(((GasOutput)((ChemicalInfuserRecipe)entry.getValue()).recipeOutput).output);
            if (!StackHelper.matches(gasOutput, outputGas) || !StackHelper.matches(leftGasInput, inputGasLeft) || !StackHelper.matches(rightGasInput, inputGasRight)) continue;
            recipes.put((MachineInput)entry.getKey(), (MachineRecipe)entry.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveMekanismRecipe(name, RecipeHandler.Recipe.CHEMICAL_INFUSER.get(), (Map<MachineInput, MachineRecipe>)recipes));
        } else {
            LogHelper.logWarning(String.format("No %s recipe found for %s, %s and %s. Command ignored!", name, gasOutput.toString(), leftGasInput.toString(), rightGasInput.toString()));
        }
    }
}

