/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.logic;

import com.google.common.collect.ImmutableList;
import openmods.api.IValueProvider;
import openmods.api.IValueReceiver;
import openmods.gui.logic.IValueUpdateAction;

public class ValueCopyAction<T>
implements IValueUpdateAction {
    private final Object trigger;
    private final IValueProvider<T> provider;
    private final IValueReceiver<T> receiver;

    public ValueCopyAction(Object trigger, IValueProvider<T> provider, IValueReceiver<T> receiver) {
        this.trigger = trigger;
        this.provider = provider;
        this.receiver = receiver;
    }

    @Override
    public Iterable<?> getTriggers() {
        return ImmutableList.of((Object)this.trigger);
    }

    @Override
    public void execute() {
        T value = this.provider.getValue();
        this.receiver.setValue(value);
    }

    public static <T> ValueCopyAction<T> create(IValueProvider<T> provider, IValueReceiver<T> receiver) {
        return new ValueCopyAction<T>(provider, provider, receiver);
    }

    public static <T> ValueCopyAction<T> create(Object trigger, IValueProvider<T> provider, IValueReceiver<T> receiver) {
        return new ValueCopyAction<T>(trigger, provider, receiver);
    }
}

